package gov.va.caret.controller.dashboard.config;

import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;

public class CslDashboardConfig extends DashboardConfig {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7440796283781503750L;
	public final String VIEW = "/jsp/dashboard/csl.jsp";
	
	public CslDashboardConfig() {
		super();
		
		this.enabledSearch = new EnabledSearch( new CachedReport(CaretStrPool.CALLS), new CachedReport("referrals") );
		this.reports = new GenericReport[]{ 
					new GenericReport("myCalls", false, "creationDate", true, ReportParameter.userId ),
					new GenericReport("myReferrals", false, "creationDate", true, ReportParameter.userId ) ,
					new GenericReport("groupCalls", false, "creationDate", true, ReportParameter.roleId ) ,
					new GenericReport("groupReferrals", false, "creationDate", true, ReportParameter.roleId ) ,
					new GenericReport("groupSocs", false, "creationDate", true, ReportParameter.roleId, ReportParameter.socDueDate ) };
	}

	public final CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{
			CAction.CaretCan.CREATE_CALLS,
			CAction.CaretCan.CREATE_CALL_TYPE,
			CAction.CaretCan.CREATE_REFERRAL,
			CAction.CaretCan.CREATE_MESSAGES
		};
	}
	
	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{};
	}
	
	@Override
	public String getView() {
		return VIEW;
	}
}
/*
                Dashboard CSL
                                Main view
                                                create new call record
                                                search for existing call record
                                                view/edit/update call record
                                                create referral work item
                                                view CSL referrals
                                                create/read/reply internal messaging



 * 
 * 
 */
