package gov.va.caret.controller.dashboard.config;

import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;

public class CbopcFmDashboardConfig extends DashboardConfig {

	private static final long serialVersionUID = 1L;
	public final String VIEW = "/jsp/dashboard/cbopcfm.jsp";
	
	public CbopcFmDashboardConfig() {
		super();
		this.enabledSearch = new EnabledSearch( new CachedReport("vcgs"), new CachedReport("workItems")  );
		this.reports = new GenericReport[]{ 
								new GenericReport("cbopcStipend"),
								new GenericReport("blsRates", true, "county, city", false ) };
	}
	
	public final CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{
			CAction.CaretCan.CREATE_MESSAGES
		};
	}
	
	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{
				CAction.CaretCan.STIPEND_CALCULATOR
			};
	}

	@Override
	public String getView() {
		return VIEW;
	}

}
