package gov.va.caret.controller;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.CountryConstants;
import com.liferay.portal.service.RegionServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.dashboard.config.OnlineDashboardConfig;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.impl.VcgAnImpl;
import gov.va.caret.model.support.Person;
import gov.va.caret.pdf.FileType;
import gov.va.caret.security.CAction;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.VcgLocalServiceUtil;
import gov.va.caret.util.CaretMap;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.OnlineUtil;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ResultMap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.BaseURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;


/*
 * Central controller for CareT Online... shared between ResourceCommand and ActionCommand
 * 
 */

public class OnlineViewController extends CaretBaseViewController implements Serializable {
	
	private static final long serialVersionUID = 1L;
	private static final String APPLICATION_VIEW = "/jsp/online/edit1010cg.jsp";
	private static final String INFORMATION_VIEW = "/jsp/online/information.jsp";
	private static final String PRIMARY_VIEW = "/jsp/online/primary.jsp";
	private static final String SECONDARY_VIEW = "/jsp/online/secondary.jsp";
	private static final String SECONDARY_TWO_VIEW = "/jsp/online/secondaryTwo.jsp";
	
	public static Log _log = LogFactoryUtil.getLog(  OnlineViewController.class );
	
	private static OnlineViewController viewController = null;
	
	public static OnlineViewController get(){
		if ( viewController == null ){
			viewController = new OnlineViewController();
		}
		return viewController;
	}
	
	@Override
	public String loadDefaultView( PortletRequest request, MimeResponse response ){
		
		String mvcPath = ParamUtil.get( request, CaretStrPool.MVC_PATH, StringPool.BLANK );
		_log.info("mvcPath..." + mvcPath);
		
		if ( StringPool.BLANK.equals( mvcPath ) && request.getAttribute( CaretStrPool.MVC_PATH ) != null ){
			mvcPath = (String) request.getAttribute( CaretStrPool.MVC_PATH );
		}
		if ( StringPool.BLANK.equals( mvcPath ) ){
			try {
				mvcPath = loadRoleView( request, response ); 
			} catch (PortalException e) {
				e.printStackTrace();
			} catch (SystemException e) {
				e.printStackTrace();
			}
		}
		return mvcPath;
	}
	
	@SuppressWarnings({ "unused", "rawtypes", "unchecked" })
	public String loadRoleView ( PortletRequest request, MimeResponse response ) throws PortalException, SystemException{
		
		OnlineDashboardConfig dashboard = CAction.loadOnlineRoleId( request );
		if ( dashboard == null ){
			return CaretBaseViewController.INVALID_ACCESS_VIEW;
		}
		
		long userId = PortalUtil.getUserId( request );
//		long siteId = PortalUtil.getScopeGroupId( request );
		request.setAttribute( "isDemoEnabled", StringPool.TRUE.equals( PortletProps.get(CaretStrPool.DEMO_FEATURES_ENABLED) ) ); 
		PortletSession session = request.getPortletSession();
		
		Map persnIdMap = Collections.singletonMap(CaretStrPool.PERSN_ID, CaretParam.getPersnId(request) );
		int count = CaretLocalServiceUtil.getReportCount (dashboard.getDashboardReport(), persnIdMap);
		
		Map<String,List<?>> results = ResultMap.getResultListMap( request );
		Map<String,Integer> total = ResultMap.getResultTotalMap( request );
		Map<String,BaseURL> urlMap = ResultMap.getResultUrlMap( request, response.createRenderURL() );

		request.setAttribute(CaretStrPool.VA_CG_HREF, PortletProps.get(CaretStrPool.VA_CAREGIVER_SITE) );
		
		if ( count == 0 ){
			getForm(request).put(CaretStrPool.SHOW_ALL_TABS, true);
			loadOnlineQuestionaire(request);

		} else {
			total.put( GenericReport.MY_APPLICATIONS, count );
			List myApplications = CaretLocalServiceUtil.getReport( dashboard.getDashboardReport(), persnIdMap );
			
			results.put( GenericReport.MY_APPLICATIONS, myApplications );
			List myVcgStatus;
			if ( dashboard.isVeteran() ){
				myVcgStatus = OnlineUtil.myCaregivers( myApplications, request );
				loadPrimaryAppStatus( request );
				
			} else {
				getForm(request).put(CaretStrPool.CAREGIVER, true);
				myVcgStatus = OnlineUtil.myVeterans( myApplications, request);

				results.put( GenericReport.MY_STIPENDS, CaretLocalServiceUtil.getReport( GenericReport.MY_STIPENDS, userId ) );
				total.put( GenericReport.MY_STIPENDS, CaretLocalServiceUtil.getReportCount( GenericReport.MY_STIPENDS, userId ) );
			}
			results.put( GenericReport.MY_VCG_STATUS, myVcgStatus );
			total.put( GenericReport.MY_VCG_STATUS, myVcgStatus.size() );
			
			results.put( GenericReport.MY_MESSAGES, CaretLocalServiceUtil.getReport( GenericReport.MY_MESSAGES, persnIdMap ) );
			total.put( GenericReport.MY_MESSAGES, CaretLocalServiceUtil.getReportCount( GenericReport.MY_MESSAGES , persnIdMap ) );
		}
		
		return "/jsp/online/" + dashboard.getJsp();
	}
	

	private void loadPrimaryAppStatus(PortletRequest request) {
		int status = 0;
		try {
			VcgAn vcgAn = CaretLocalServiceUtil.getPrimaryApp( CaretParam.getPersnId(request) );
			if ( vcgAn != null &&  vcgAn.getStatus() != null ){
				
				if ( vcgAn.getStatus().endsWith( "APPROVED" ) ){
					status = 4;
				} else if ( "IN_REVIEW".equals( vcgAn.getStatus() ) ){
					status = 3;
				} else if ( "SUBMITTED".equals( vcgAn.getStatus() ) ){
					status = 2;
				} else {
					status = 1;
				}
			}
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}
		getForm(request).put("primaryApp", status);
		
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	private void loadOnlineQuestionaire(PortletRequest request) throws ApplicationWorkFlowException {
		
		List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.ONLINE_QUESTIONAIRE_YN);
		
		if ( groups.isEmpty() ){
			groups = new ArrayList<BoxGp>();
			int i = 0;
			for ( String subgroup: PortletProps.get( CaretStrPool.ONLINE_QUESTIONAIRE_YN ).split( StringPool.SEMICOLON ) ){
				Toolbox.initYesNoBoxGp(subgroup, CaretStrPool.ONLINE_QUESTIONAIRE_YN, groups, i);
				i = i + 2;
			}
		}
		
		Map<String, Object> form =  getForm(request);
		
		form.put(CaretStrPool.BOX_GROUP, groups );
		
		Map boxGrp = new CaretMap( false );
		form.put(CaretStrPool.BOX_GROUP_ASSN, boxGrp);
		for ( BgAsn bgAsn0: BoxGpLocalServiceUtil.getBoxGroupAssociations( CaretParam.getPersnId(request), true ) ) {
			boxGrp.put( bgAsn0.getBoxGpId(), true );
		}
		Map<String,List<BoxGp>> boxGpMap = new HashMap<String,List<BoxGp>>();
		int i = 0;
		List boxGpList = new ArrayList(5);
		for ( BoxGp boxGp: groups ){
			boxGpList.add( boxGp );
			if ( i % 2 == 1 ){
				boxGpMap.put( boxGp.getBoxSubGroup(), boxGpList );
				boxGpList = new ArrayList(5);
			}
			i++;
		}
		form.put( CaretStrPool.BOX_GROUP, boxGpMap );
	}
	

	public void loadApplication ( PortletRequest request ){
		try {
			Map<String, Object> form = getForm(request);
			long userId =  PortalUtil.getUserId(request);
			long vcgAnId = ParamUtil.getLong(request, CaretStrPool.VCGANID, 0);
			if ( vcgAnId == 0 && request.getAttribute(CaretStrPool.VCGANID) != null){
				vcgAnId = (Long) request.getAttribute(CaretStrPool.VCGANID);
			}
			
			String view = APPLICATION_VIEW;
			Person person = new Person( PersnLocalServiceUtil.getByUser(userId) );
			
			form.put(CaretStrPool.PERSN, person);
			
//			Set<String> caregivers = new HashSet<String>();
			long roleId = ((OnlineDashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.ONLINE_DASHBOARD_CONFIG)).getRoleId();
			
			boolean vaHealthEnrolled = false;
			if ( vcgAnId == 0 ){ //is-new
				
				loadRequiredInputs( CaretStrPool.VETERAN_PERSN, form );
				
				if ( OnlineDashboardConfig.VETERAN_FUNCTION.getRoleId() != roleId ){
					view = INFORMATION_VIEW;
				}
				form.put(CaretStrPool.VETERAN_PERSN, person);
				
				List<VcgAn> list = VcgAnLocalServiceUtil.getByPersn( person.getPersnId() );
				for ( VcgAn vcgAn : list ){
					if ( vcgAn.getPrimaryId() > 0 ){
						form.put( CaretStrPool.PRIMARY_PERSN, new Person( PersnLocalServiceUtil.getPersn( vcgAn.getPrimaryId() ) ) );
					}
					if ( vcgAn.getSecondaryId() > 0 ){
						form.put( CaretStrPool.SECONDARY_PERSN, new Person( PersnLocalServiceUtil.getPersn( vcgAn.getSecondaryId() ) ) );
					}
					if ( vcgAn.getSecondaryTwoId() > 0 ){
						form.put( CaretStrPool.SECONDARY_TWO_PERSN, new Person( PersnLocalServiceUtil.getPersn( vcgAn.getSecondaryTwoId() ) ) );
					}
					vaHealthEnrolled = vaHealthEnrolled || vcgAn.isVaHealthEnrolled();
				}
				request.getPortletSession().setAttribute( CaretStrPool.APP_NDX, list.size() );
			}
			
			Map<String,Object> caret = ResultMap.getCaretMap(request);

			caret.put( CaretStrPool.VHA_SYSTEM, Toolbox.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
			caret.put( CaretStrPool.GENDER_TYPES, PortletProps.get(CaretStrPool.PERSN_GENDER_TYPES).split(StringPool.COMMA) );
			try {
				caret.put(CaretStrPool.STATES, RegionServiceUtil.getRegions( CountryConstants.DEFAULT_COUNTRY_ID ) );
			} catch (SystemException e) {
				e.printStackTrace();
			}
			
			
			form.put(CaretStrPool.VCGANID, vcgAnId);
			String prefix = CaretStrPool.VETERAN_PERSN;
			if ( vcgAnId > 0 ){  // not-new
				VcgAn vcgApplication = VcgAnLocalServiceUtil.getVcgAn(vcgAnId);
				
				form.put(CaretStrPool.VETERAN_PERSN, new Person( PersnLocalServiceUtil.getPersn( vcgApplication.getVeteranId() ) ) );
				
				long persnId = vcgApplication.getPrimaryId();
				if ( persnId > 0 ){
					form.put( CaretStrPool.PRIMARY_PERSN, new Person( PersnLocalServiceUtil.getPersn( persnId ) ) );
					if ( person.getPersnId() == persnId ){
						prefix = CaretStrPool.PRIMARY_PERSN;
						form.put("signing", true);
						view = PRIMARY_VIEW;
						loadRequiredInputs( CaretStrPool.PRIMARY_PERSN, form );
					}
				}
				persnId = vcgApplication.getSecondaryId();
				if ( persnId > 0 ){
					form.put( CaretStrPool.SECONDARY_PERSN, new Person( PersnLocalServiceUtil.getPersn( persnId ) ) );
					if ( person.getPersnId() == persnId ){
						 prefix = CaretStrPool.SECONDARY_PERSN;
						 form.put("signing", true);
						view = SECONDARY_VIEW;
						loadRequiredInputs( CaretStrPool.SECONDARY_PERSN, form );
					}
				}
				persnId = vcgApplication.getSecondaryTwoId();
				if ( persnId > 0 ){
					form.put( CaretStrPool.SECONDARY_TWO_PERSN, new Person( PersnLocalServiceUtil.getPersn( persnId ) ) );
					if ( person.getPersnId() == persnId ){
						prefix = CaretStrPool.SECONDARY_TWO_PERSN;
						form.put("signing", true);
						view = SECONDARY_TWO_VIEW;
						loadRequiredInputs( CaretStrPool.SECONDARY_TWO_PERSN, form );
					}
				}
				
				if ( prefix == CaretStrPool.VETERAN_PERSN ){
					Vcg vcg = VcgLocalServiceUtil.getVeteranVcg( person.getPersnId() );
					if ( vcg != null ){
						form.put("generalCaregiver", vcg.getGeneralCaregiver() );
					} else {
						form.put("generalCaregiver", false );
					}
				}
						
				form.put( CaretStrPool.VCGAN, vcgApplication );
				
				List<Docum> documents = DocumLocalServiceUtil.getByClass(vcgAnId, PortalUtil.getClassNameId(VcgAn.class), FileType.TEN_TEN_CG.name() );
				if (! documents.isEmpty() ){
					Docum d = documents.get(0);
					_log.info( "Application form is " +  d.getName() );
//					form.put("documName", d.getName() );
//					form.put("documId", d.getDocumId() );
				}
				
			} else {
				VcgAn vcgAn = new VcgAnImpl();
				Object o = request.getAttribute(CaretStrPool.ENROLLED_BG);
				if ( o != null ){
					vcgAn.setVaHealthEnrolled((Boolean)o);
				} 
				form.put( CaretStrPool.VCGAN, vcgAn );
			}
			loadAddress(caret, person, prefix);
			
			String relationshipNotFamily = PortletProps.get(CaretStrPool.RELATIONSHIP_NOT_FAMILY);
			String relationshipFamily = PortletProps.get(CaretStrPool.RELATIONSHIP_FAMILY);
			if ( !relationshipNotFamily.isEmpty() ){
				caret.put(CaretStrPool.RELATIONSHIP_NOT_FAMILY, relationshipNotFamily.split(StringPool.COMMA) );
				caret.put(CaretStrPool.RELATIONSHIP_FAMILY, relationshipFamily.split(StringPool.COMMA) );
			}
			
			try {
				String extensions = StringUtil.merge(PrefsPropsUtil.getStringArray(PropsKeys.DL_FILE_EXTENSIONS, StringPool.COMMA));
//				dl.file.max.size
				long maxSize = Long.parseLong(PrefsPropsUtil.getString(PropsKeys.DL_FILE_MAX_SIZE)) / 1024;
				_log.info("extensions = " + extensions + ", maxSize=" + maxSize );
				form.put("extensions",  extensions );
				form.put("maxSize",  maxSize );
				
			} catch (NumberFormatException e) {
				e.printStackTrace();
			} catch (SystemException e) {
				e.printStackTrace();
			}
			
			request.setAttribute(CaretStrPool.MVC_PATH, view);
			caret.put( CaretStrPool.SEARCH_CSS, SearchController.getSearchCss() );
			
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		} catch (PortalException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
	}
	
	public void loadRequiredInputs( String persn, Map<String, Object> form) {
		
		Map<String,Object> required = new CaretMap<String,Object>(StringPool.BLANK);
		form.put("required", required);
		
		if ( CaretStrPool.VETERAN_PERSN == persn ){
			for ( String key : PortletProps.get("required.veteran.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};
		} else if ( CaretStrPool.PRIMARY_PERSN == persn ){
			for ( String key : PortletProps.get("required.primary.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};		
		} else if ( CaretStrPool.SECONDARY_PERSN == persn ){
			for ( String key : PortletProps.get("required.secondary.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};
		} else if ( CaretStrPool.SECONDARY_TWO_PERSN == persn ){
			for ( String key : PortletProps.get("required.secondaryTwo.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};
		}
	}
	
	public boolean validateRequired( String context, PortletRequest request ){
		return true;
	}

	public void loadPersnAddress(PortletRequest request, Person persn,
			String prefix) throws ApplicationWorkFlowException {

		if ( StringPool.FALSE.equals( persn.getCountry() ) || StringPool.BLANK.equals( persn.getCountry() ) ){ // USA
			CaretParam.loadModel(request, persn, Toolbox.getAddressCollection(), prefix + CaretStrPool.U_UNDERLINE);
		} else { // World
			CaretParam.loadModel(request, persn, Toolbox.getAddressCollection(), prefix + CaretStrPool.G_UNDERLINE);
		}
		persn.setAddress(request.getParameter(prefix +  CaretStrPool._ADDRESS));
	}
}
