package gov.va.caret.controller;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.controller.dashboard.config.DashboardConfig;
import gov.va.caret.controller.dashboard.config.DashboardConfigFactory;
import gov.va.caret.util.CaretMap;
import gov.va.caret.util.CaretStrPool;

import java.io.Serializable;
import java.util.Map;

import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;

/*
 * Central controller for CareT Online... shared between ResourceCommand and ActionCommand
 * 
 */

public class CaretViewController extends CaretBaseViewController implements Serializable {
	
	private static final long serialVersionUID = 1L;
	private static CaretViewController viewController = new CaretViewController();
	public static Log _log = LogFactoryUtil.getLog(  CaretViewController.class );
	
	public static CaretViewController getViewController(){
		if ( viewController == null ){
			viewController = new CaretViewController();
		}
		return viewController;
	}
	
	@Override
	public String loadDefaultView( PortletRequest request, MimeResponse response ) {
		
		request.setAttribute( "isDemoEnabled", PortletProps.get(CaretStrPool.DEMO_FEATURES_ENABLED) );
		
		DashboardConfig dashboardConfig = DashboardConfigFactory.loadInstance( request, response );
		if ( dashboardConfig != null ){
			return dashboardConfig.getView();
		}
		return StringPool.BLANK;
	}

	public void loadRequiredInputs( String context, Map<String, Object> form ) {

		Map<String, String> required = new CaretMap<String, String>(StringPool.BLANK);
		form.put("required", required);
		
		if ( CaretStrPool.CALL ==  context ){
			for ( String key : PortletProps.get("required.call.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};
		} else if ( CaretStrPool.REFFERAL ==  context ){
			for ( String key : PortletProps.get("required.referral.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};
		} else if ( CaretStrPool.VETERAN_PERSN == context ){
			for ( String key : PortletProps.get("csc.required.veteran.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
				form.put("veteranRequired", required);
			}
		} else if ( CaretStrPool.PRIMARY_PERSN == context ){
			for ( String key : PortletProps.get("csc.required.primary.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
				form.put("primaryRequired", required);
			}		
		} else if ( CaretStrPool.SECONDARY_PERSN == context ){
			for ( String key : PortletProps.get("csc.required.secondary.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
				form.put("secondaryRequired", required);
			}	
		} else if ( CaretStrPool.SECONDARY_TWO_PERSN == context ){
			for ( String key : PortletProps.get("csc.required.secondaryTwo.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
				form.put("secondaryTwoRequired", required);
			}
		}
				
//		HashMap map = (HashMap) form.get("required");
		
	}
	
	public boolean validateRequired( String context, PortletRequest request ){
		Map<String, Object> form = getForm(request);
		loadRequiredInputs( context, form );
		for ( String key : form.keySet() ){
			
		}
		return true;
	}
	
}
