create table CARET_APPLICATION (
	vcgAnId LONG not null primary key,
	vcgId LONG,
	veteranId LONG,
	primaryId LONG,
	secondaryId LONG,
	secondaryTwoId LONG,
	status VARCHAR(75) null,
	receivedDate DATE null,
	primaryRelationship VARCHAR(75) null,
	secondaryRelationship VARCHAR(75) null,
	secondaryTwoRelationship VARCHAR(75) null,
	primarySignDate DATE null,
	secondarySignDate DATE null,
	secondaryTwoSignDate DATE null,
	vaHealthEnrolled BOOLEAN,
	mediEnrolled BOOLEAN,
	lastTreatmentPlace VARCHAR(75) null,
	hospital BOOLEAN,
	clinic BOOLEAN,
	submitDate DATE null,
	creationDate DATE null,
	groupId LONG
);

create table CARET_ASSESSMENT (
	assmtId LONG not null primary key,
	vcgId LONG,
	noteId LONG,
	completionDate DATE null,
	type_ VARCHAR(75) null,
	scheduleDate DATE null,
	userId LONG
);

create table CARET_AUDIT_LOG (
	audLgId LONG not null primary key,
	classPk LONG,
	classId LONG,
	attribute VARCHAR(75) null,
	oldValue VARCHAR(75) null,
	newValue VARCHAR(75) null,
	coverUserId LONG,
	modifiedById LONG,
	modifiedDate DATE null,
	groupId LONG,
	roleName VARCHAR(75) null,
	SYS_DATETIME LONG
);

create table CARET_BLS (
	blsReId LONG not null primary key,
	blsAeId LONG,
	year INTEGER,
	h75 DOUBLE,
	city VARCHAR(75) null,
	zip VARCHAR(75) null,
	state_ VARCHAR(75) null,
	county VARCHAR(75) null
);

create table CARET_BLS_AREA (
	blsAeId LONG not null primary key,
	areaName VARCHAR(75) null,
	areaNumber INTEGER
);

create table CARET_BOXED_GROUP (
	boxGpId LONG not null primary key,
	boxGroup VARCHAR(75) null,
	boxSubGroup VARCHAR(75) null,
	label VARCHAR(255) null,
	viewSequence INTEGER
);


create table CARET_BOXED_GROUP_BOOL (
	bgAsnId LONG not null primary key,
	ownerId LONG,
	boxGpId LONG,
	selected BOOLEAN
);

create table CARET_BOXED_GROUP_CHAR (
	bgLaeId LONG not null primary key,
	ownerId LONG,
	boxGpId LONG,
	largeText VARCHAR(75) null
);

create table CARET_BOXED_GROUP_NUMERIC (
	bgNumId LONG not null primary key,
	ownerId LONG,
	boxGpId LONG,
	value DOUBLE
);

create table CARET_CALL (
	callId LONG not null primary key,
	callType VARCHAR(75) null,
	callerRelationship VARCHAR(75) null,
	workPrimaryKey LONG,
	callState VARCHAR(75) null,
	callerPersnId LONG,
	callerTitle VARCHAR(75) null,
	callerLearnAbout VARCHAR(75) null,
	veteranPersnId LONG,
	message VARCHAR(75) null,
	summary VARCHAR(75) null,
	transferRemarks VARCHAR(75) null,
	cespGoal VARCHAR(75) null,
	cespOutcome VARCHAR(75) null,
	transferredTo VARCHAR(75) null,
	otherBenefits VARCHAR(75) null,
	contactInfo VARCHAR(75) null,
	eraService VARCHAR(75) null,
	serviceBranch VARCHAR(75) null,
	serviceStatus VARCHAR(75) null,
	contactInfoProvided BOOLEAN,
	referralAgreeable BOOLEAN,
	withoutContact BOOLEAN,
	hangUp BOOLEAN,
	wrongNumber BOOLEAN,
	sameAddress BOOLEAN,
	enrolled BOOLEAN,
	dutyDischargeAfter911 BOOLEAN,
	scCondition BOOLEAN,
	pcafcQaulified BOOLEAN,
	verified BOOLEAN,
	anonymous BOOLEAN,
	createGroupId LONG,
	userId LONG,
	creationDate DATE null,
	callbackPref VARCHAR(75) null
);

create table CARET_CALL_EVENT (
	calEtId LONG not null primary key,
	callId LONG,
	event VARCHAR(75) null,
	comment_ VARCHAR(75) null,
	creationDate DATE null,
	userId LONG
);

create table CARET_CESP (
	cespId LONG not null primary key,
	callId LONG,
	createdByPersnId LONG,
	creationDate DATE null,
	step VARCHAR(75) null,
	status VARCHAR(75) null,
	referredBy VARCHAR(75) null,
	assignedCslPersnId VARCHAR(75) null,
	goals VARCHAR(75) null,
	planProgressBarrier VARCHAR(75) null,
	cespClosed VARCHAR(75) null,
	cespClosedReason VARCHAR(75) null,
	goalsReached VARCHAR(75) null
);

create table CARET_CRYPTO_VALUES (
	cryptoId LONG not null primary key,
	ownerId LONG,
	type_ VARCHAR(75) null,
	value VARCHAR(75) null,
	hcode INTEGER
);

create table CARET_DOCUMENT (
	documId LONG not null primary key,
	document BLOB,
	classId LONG,
	classPk LONG,
	name VARCHAR(75) null,
	type_ VARCHAR(75) null
);

create table CARET_FACILITY (
	facilId LONG not null primary key,
	facilityNumber VARCHAR(75) null,
	location VARCHAR(75) null,
	groupId LONG
);

create table CARET_FACILITY_ZIP (
	zipFyId LONG not null primary key,
	facilId LONG,
	facilZip VARCHAR(75) null,
	distance DOUBLE
);

create table CARET_NOTE (
	uuid_ VARCHAR(75) null,
	noteId LONG not null primary key,
	value VARCHAR(400) null,
	userId LONG,
	creationDate DATE null,
	groupId LONG,
	chainId LONG
);

create table CARET_NOTIFICATION (
	notifId LONG not null primary key,
	ownerId LONG,
	type_ VARCHAR(75) null,
	discontinueDate DATE null
);

create table CARET_PAYMENT_CONFIG (
	stiPtId LONG not null primary key,
	stiRdId LONG,
	vendrId LONG,
	tier VARCHAR(75) null,
	tierHours VARCHAR(75) null,
	blsRateHourly VARCHAR(75) null,
	dailyRate VARCHAR(75) null,
	monthlyPayment VARCHAR(75) null,
	stipendStatus VARCHAR(75) null,
	stipendApprovedDate DATE null,
	stipendStartDate DATE null,
	groupId LONG
);

create table CARET_PAYMENT_LOG (
	paymentLogId LONG not null primary key,
	stiPtId LONG,
	amount DOUBLE,
	paymentDate DATE null,
	status VARCHAR(75) null,
	reason VARCHAR(75) null,
	creationDate DATE null,
	userId LONG
);

create table CARET_PERSON (
	persnId LONG not null primary key,
	persnUserId LONG,
	lastName VARCHAR(75) null,
	firstName VARCHAR(75) null,
	middleName VARCHAR(75) null,
	prefix VARCHAR(75) null,
	suffix VARCHAR(75) null,
	birthDate DATE null,
	deceasedDate DATE null,
	gender VARCHAR(75) null,
	address VARCHAR(75) null,
	address2 VARCHAR(75) null,
	city VARCHAR(75) null,
	state_ VARCHAR(75) null,
	country VARCHAR(75) null,
	zip VARCHAR(75) null,
	phone VARCHAR(75) null,
	phone2 VARCHAR(75) null,
	email VARCHAR(75) null,
	email2 VARCHAR(75) null,
	status VARCHAR(75) null,
	source VARCHAR(75) null,
	MVI200MID VARCHAR(75) null,
	otherHealthInsurance VARCHAR(75) null,
	userId LONG,
	groupId LONG
);

create table CARET_SOC (
	clSocId LONG not null primary key,
	callId LONG,
	persnId LONG,
	surveyStatus VARCHAR(75) null,
	surveyComment VARCHAR(75) null,
	creationDate DATE null,
	attemptNum VARCHAR(75) null,
	callerAvailable VARCHAR(75) null,
	requestedCallbackTime VARCHAR(75) null,
	willingToAnsQues VARCHAR(75) null,
	calledCsl VARCHAR(75) null,
	cslKnowledgable VARCHAR(75) null,
	cslSupportive VARCHAR(75) null,
	localResSuggested VARCHAR(75) null,
	localResContacted VARCHAR(75) null,
	rsnLocalResNotContacted VARCHAR(75) null,
	localResHelpful VARCHAR(75) null,
	concernsAnswered VARCHAR(75) null,
	understandNextSteps VARCHAR(75) null,
	callCslAgain VARCHAR(75) null,
	recommendCsl VARCHAR(75) null,
	suggestions VARCHAR(75) null,
	followupCall VARCHAR(75) null,
	followupCallTime VARCHAR(75) null,
	tresholdMet VARCHAR(75) null
);

create table CARET_STIPEND (
	stiRdId LONG not null primary key,
	vcgAnId LONG,
	cscStatus VARCHAR(75) null,
	cscStatusDate DATE null,
	cbopcStatus VARCHAR(75) null,
	cbopcStatusDate DATE null,
	creationDate DATE null,
	userId LONG,
	groupId LONG
);



create table CARET_VENDOR (
	vendrId LONG not null primary key,
	lastName VARCHAR(75) null,
	firstName VARCHAR(75) null,
	middleName VARCHAR(75) null,
	fedTaxId VARCHAR(75) null,
	address VARCHAR(75) null,
	address2 VARCHAR(75) null,
	city VARCHAR(75) null,
	state_ VARCHAR(75) null,
	zip VARCHAR(75) null,
	phone VARCHAR(75) null,
	phone2 VARCHAR(75) null,
	gracePeriod VARCHAR(75) null,
	gracePeriodDuration VARCHAR(75) null,
	directDepositInfo VARCHAR(75) null,
	paymentMethod VARCHAR(75) null,
	crypto1 VARCHAR(75) null,
	groupId LONG
);

create table CARET_VETERAN_VENDOR (
	vetVrId LONG not null primary key,
	vendrId LONG,
	cgId LONG,
	veteranId LONG,
	groupId LONG
);

create table CARET_WAIVER (
	waivrId LONG not null primary key,
	classPk LONG,
	adjudication VARCHAR(75) null,
	reason VARCHAR(75) null,
	note VARCHAR(75) null,
	creationDate DATE null,
	completionDate DATE null,
	userId LONG
);

create table CARET_WORK_ITEM (
	worImId LONG not null primary key,
	type_ VARCHAR(75) null,
	classId LONG,
	classPk LONG,
	status VARCHAR(75) null,
	creationDate DATE null,
	dueDate DATE null,
	completionDate DATE null,
	completionBy LONG,
	groupId LONG,
	userId LONG,
	caregiverId LONG,
	persnId LONG,
	queId LONG,
	vcgId LONG
);

create table CareT_VCG (
	vcgId LONG not null primary key,
	veteranId LONG,
	status VARCHAR(75) null,
	assessCompletionDate DATE null,
	primaryTrainedDate DATE null,
	visitationDate DATE null,
	primaryId LONG,
	secondaryId LONG,
	secondaryTwoId LONG,
	generalCaregiver BOOLEAN,
	primaryType VARCHAR(75) null,
	secondaryType VARCHAR(75) null,
	secondaryTwoType VARCHAR(75) null,
	primaryDispositionDate DATE null,
	secondaryDispositionDate DATE null,
	secondaryTwoDispositionDate DATE null,
	tierLevel INTEGER,
	tierEffectiveDate DATE null,
	veteranDispReason VARCHAR(75) null,
	primaryDispReason VARCHAR(75) null,
	secondaryDispReason VARCHAR(75) null,
	secondaryTwoDispReason VARCHAR(75) null,
	primaryRevocationDate DATE null,
	secondaryRevocationDate DATE null,
	secondaryTwoRevocationDate DATE null,
	groupId LONG
);