package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.Crypto;

/**
 * The persistence interface for the crypto service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see CryptoPersistenceImpl
 * @see CryptoUtil
 * @generated
 */
public interface CryptoPersistence extends BasePersistence<Crypto> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link CryptoUtil} to access the crypto persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns the crypto where type = &#63; and ownerId = &#63; or throws a {@link gov.va.caret.NoSuchCryptoException} if it could not be found.
    *
    * @param type the type
    * @param ownerId the owner ID
    * @return the matching crypto
    * @throws gov.va.caret.NoSuchCryptoException if a matching crypto could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Crypto findByCryptoValue(java.lang.String type,
        long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCryptoException;

    /**
    * Returns the crypto where type = &#63; and ownerId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param type the type
    * @param ownerId the owner ID
    * @return the matching crypto, or <code>null</code> if a matching crypto could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Crypto fetchByCryptoValue(java.lang.String type,
        long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the crypto where type = &#63; and ownerId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param type the type
    * @param ownerId the owner ID
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching crypto, or <code>null</code> if a matching crypto could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Crypto fetchByCryptoValue(java.lang.String type,
        long ownerId, boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes the crypto where type = &#63; and ownerId = &#63; from the database.
    *
    * @param type the type
    * @param ownerId the owner ID
    * @return the crypto that was removed
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Crypto removeByCryptoValue(
        java.lang.String type, long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCryptoException;

    /**
    * Returns the number of cryptos where type = &#63; and ownerId = &#63;.
    *
    * @param type the type
    * @param ownerId the owner ID
    * @return the number of matching cryptos
    * @throws SystemException if a system exception occurred
    */
    public int countByCryptoValue(java.lang.String type, long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the crypto in the entity cache if it is enabled.
    *
    * @param crypto the crypto
    */
    public void cacheResult(gov.va.caret.model.Crypto crypto);

    /**
    * Caches the cryptos in the entity cache if it is enabled.
    *
    * @param cryptos the cryptos
    */
    public void cacheResult(java.util.List<gov.va.caret.model.Crypto> cryptos);

    /**
    * Creates a new crypto with the primary key. Does not add the crypto to the database.
    *
    * @param cryptoId the primary key for the new crypto
    * @return the new crypto
    */
    public gov.va.caret.model.Crypto create(long cryptoId);

    /**
    * Removes the crypto with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param cryptoId the primary key of the crypto
    * @return the crypto that was removed
    * @throws gov.va.caret.NoSuchCryptoException if a crypto with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Crypto remove(long cryptoId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCryptoException;

    public gov.va.caret.model.Crypto updateImpl(
        gov.va.caret.model.Crypto crypto)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the crypto with the primary key or throws a {@link gov.va.caret.NoSuchCryptoException} if it could not be found.
    *
    * @param cryptoId the primary key of the crypto
    * @return the crypto
    * @throws gov.va.caret.NoSuchCryptoException if a crypto with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Crypto findByPrimaryKey(long cryptoId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCryptoException;

    /**
    * Returns the crypto with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param cryptoId the primary key of the crypto
    * @return the crypto, or <code>null</code> if a crypto with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Crypto fetchByPrimaryKey(long cryptoId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the cryptos.
    *
    * @return the cryptos
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Crypto> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the cryptos.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CryptoModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of cryptos
    * @param end the upper bound of the range of cryptos (not inclusive)
    * @return the range of cryptos
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Crypto> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the cryptos.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CryptoModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of cryptos
    * @param end the upper bound of the range of cryptos (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of cryptos
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Crypto> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the cryptos from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of cryptos.
    *
    * @return the number of cryptos
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
