package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.CalEt;

import java.util.List;

/**
 * The persistence utility for the cal et service. This utility wraps {@link CalEtPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see CalEtPersistence
 * @see CalEtPersistenceImpl
 * @generated
 */
public class CalEtUtil {
    private static CalEtPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(CalEt calEt) {
        getPersistence().clearCache(calEt);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<CalEt> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<CalEt> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<CalEt> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static CalEt update(CalEt calEt) throws SystemException {
        return getPersistence().update(calEt);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static CalEt update(CalEt calEt, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(calEt, serviceContext);
    }

    /**
    * Returns all the cal ets where callId = &#63;.
    *
    * @param callId the call ID
    * @return the matching cal ets
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.CalEt> findByCallId(
        long callId) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByCallId(callId);
    }

    /**
    * Returns a range of all the cal ets where callId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CalEtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callId the call ID
    * @param start the lower bound of the range of cal ets
    * @param end the upper bound of the range of cal ets (not inclusive)
    * @return the range of matching cal ets
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.CalEt> findByCallId(
        long callId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByCallId(callId, start, end);
    }

    /**
    * Returns an ordered range of all the cal ets where callId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CalEtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callId the call ID
    * @param start the lower bound of the range of cal ets
    * @param end the upper bound of the range of cal ets (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching cal ets
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.CalEt> findByCallId(
        long callId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByCallId(callId, start, end, orderByComparator);
    }

    /**
    * Returns the first cal et in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching cal et
    * @throws gov.va.caret.NoSuchCalEtException if a matching cal et could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.CalEt findByCallId_First(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCalEtException {
        return getPersistence().findByCallId_First(callId, orderByComparator);
    }

    /**
    * Returns the first cal et in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching cal et, or <code>null</code> if a matching cal et could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.CalEt fetchByCallId_First(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByCallId_First(callId, orderByComparator);
    }

    /**
    * Returns the last cal et in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching cal et
    * @throws gov.va.caret.NoSuchCalEtException if a matching cal et could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.CalEt findByCallId_Last(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCalEtException {
        return getPersistence().findByCallId_Last(callId, orderByComparator);
    }

    /**
    * Returns the last cal et in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching cal et, or <code>null</code> if a matching cal et could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.CalEt fetchByCallId_Last(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByCallId_Last(callId, orderByComparator);
    }

    /**
    * Returns the cal ets before and after the current cal et in the ordered set where callId = &#63;.
    *
    * @param calEtId the primary key of the current cal et
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next cal et
    * @throws gov.va.caret.NoSuchCalEtException if a cal et with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.CalEt[] findByCallId_PrevAndNext(
        long calEtId, long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCalEtException {
        return getPersistence()
                   .findByCallId_PrevAndNext(calEtId, callId, orderByComparator);
    }

    /**
    * Removes all the cal ets where callId = &#63; from the database.
    *
    * @param callId the call ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByCallId(long callId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByCallId(callId);
    }

    /**
    * Returns the number of cal ets where callId = &#63;.
    *
    * @param callId the call ID
    * @return the number of matching cal ets
    * @throws SystemException if a system exception occurred
    */
    public static int countByCallId(long callId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByCallId(callId);
    }

    /**
    * Caches the cal et in the entity cache if it is enabled.
    *
    * @param calEt the cal et
    */
    public static void cacheResult(gov.va.caret.model.CalEt calEt) {
        getPersistence().cacheResult(calEt);
    }

    /**
    * Caches the cal ets in the entity cache if it is enabled.
    *
    * @param calEts the cal ets
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.CalEt> calEts) {
        getPersistence().cacheResult(calEts);
    }

    /**
    * Creates a new cal et with the primary key. Does not add the cal et to the database.
    *
    * @param calEtId the primary key for the new cal et
    * @return the new cal et
    */
    public static gov.va.caret.model.CalEt create(long calEtId) {
        return getPersistence().create(calEtId);
    }

    /**
    * Removes the cal et with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param calEtId the primary key of the cal et
    * @return the cal et that was removed
    * @throws gov.va.caret.NoSuchCalEtException if a cal et with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.CalEt remove(long calEtId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCalEtException {
        return getPersistence().remove(calEtId);
    }

    public static gov.va.caret.model.CalEt updateImpl(
        gov.va.caret.model.CalEt calEt)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(calEt);
    }

    /**
    * Returns the cal et with the primary key or throws a {@link gov.va.caret.NoSuchCalEtException} if it could not be found.
    *
    * @param calEtId the primary key of the cal et
    * @return the cal et
    * @throws gov.va.caret.NoSuchCalEtException if a cal et with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.CalEt findByPrimaryKey(long calEtId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCalEtException {
        return getPersistence().findByPrimaryKey(calEtId);
    }

    /**
    * Returns the cal et with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param calEtId the primary key of the cal et
    * @return the cal et, or <code>null</code> if a cal et with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.CalEt fetchByPrimaryKey(long calEtId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(calEtId);
    }

    /**
    * Returns all the cal ets.
    *
    * @return the cal ets
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.CalEt> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the cal ets.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CalEtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of cal ets
    * @param end the upper bound of the range of cal ets (not inclusive)
    * @return the range of cal ets
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.CalEt> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the cal ets.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CalEtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of cal ets
    * @param end the upper bound of the range of cal ets (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of cal ets
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.CalEt> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the cal ets from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of cal ets.
    *
    * @return the number of cal ets
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static CalEtPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (CalEtPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    CalEtPersistence.class.getName());

            ReferenceRegistry.registerReference(CalEtUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(CalEtPersistence persistence) {
    }
}
