package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.BgNum;

/**
 * The persistence interface for the bg num service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BgNumPersistenceImpl
 * @see BgNumUtil
 * @generated
 */
public interface BgNumPersistence extends BasePersistence<BgNum> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link BgNumUtil} to access the bg num persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the bg nums where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @return the matching bg nums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgNum> findByBoxGroupNumberAssociations(
        long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the bg nums where ownerId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgNumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param start the lower bound of the range of bg nums
    * @param end the upper bound of the range of bg nums (not inclusive)
    * @return the range of matching bg nums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgNum> findByBoxGroupNumberAssociations(
        long ownerId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the bg nums where ownerId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgNumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param start the lower bound of the range of bg nums
    * @param end the upper bound of the range of bg nums (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching bg nums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgNum> findByBoxGroupNumberAssociations(
        long ownerId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first bg num in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg num
    * @throws gov.va.caret.NoSuchBgNumException if a matching bg num could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgNum findByBoxGroupNumberAssociations_First(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgNumException;

    /**
    * Returns the first bg num in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg num, or <code>null</code> if a matching bg num could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgNum fetchByBoxGroupNumberAssociations_First(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last bg num in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg num
    * @throws gov.va.caret.NoSuchBgNumException if a matching bg num could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgNum findByBoxGroupNumberAssociations_Last(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgNumException;

    /**
    * Returns the last bg num in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg num, or <code>null</code> if a matching bg num could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgNum fetchByBoxGroupNumberAssociations_Last(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bg nums before and after the current bg num in the ordered set where ownerId = &#63;.
    *
    * @param bgNumId the primary key of the current bg num
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next bg num
    * @throws gov.va.caret.NoSuchBgNumException if a bg num with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgNum[] findByBoxGroupNumberAssociations_PrevAndNext(
        long bgNumId, long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgNumException;

    /**
    * Removes all the bg nums where ownerId = &#63; from the database.
    *
    * @param ownerId the owner ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByBoxGroupNumberAssociations(long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of bg nums where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @return the number of matching bg nums
    * @throws SystemException if a system exception occurred
    */
    public int countByBoxGroupNumberAssociations(long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bg num where ownerId = &#63; and boxGpId = &#63; or throws a {@link gov.va.caret.NoSuchBgNumException} if it could not be found.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the matching bg num
    * @throws gov.va.caret.NoSuchBgNumException if a matching bg num could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgNum findByBgNumInst(long ownerId, long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgNumException;

    /**
    * Returns the bg num where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the matching bg num, or <code>null</code> if a matching bg num could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgNum fetchByBgNumInst(long ownerId, long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bg num where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching bg num, or <code>null</code> if a matching bg num could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgNum fetchByBgNumInst(long ownerId,
        long boxGpId, boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes the bg num where ownerId = &#63; and boxGpId = &#63; from the database.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the bg num that was removed
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgNum removeByBgNumInst(long ownerId, long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgNumException;

    /**
    * Returns the number of bg nums where ownerId = &#63; and boxGpId = &#63;.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the number of matching bg nums
    * @throws SystemException if a system exception occurred
    */
    public int countByBgNumInst(long ownerId, long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the bg num in the entity cache if it is enabled.
    *
    * @param bgNum the bg num
    */
    public void cacheResult(gov.va.caret.model.BgNum bgNum);

    /**
    * Caches the bg nums in the entity cache if it is enabled.
    *
    * @param bgNums the bg nums
    */
    public void cacheResult(java.util.List<gov.va.caret.model.BgNum> bgNums);

    /**
    * Creates a new bg num with the primary key. Does not add the bg num to the database.
    *
    * @param bgNumId the primary key for the new bg num
    * @return the new bg num
    */
    public gov.va.caret.model.BgNum create(long bgNumId);

    /**
    * Removes the bg num with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param bgNumId the primary key of the bg num
    * @return the bg num that was removed
    * @throws gov.va.caret.NoSuchBgNumException if a bg num with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgNum remove(long bgNumId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgNumException;

    public gov.va.caret.model.BgNum updateImpl(gov.va.caret.model.BgNum bgNum)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bg num with the primary key or throws a {@link gov.va.caret.NoSuchBgNumException} if it could not be found.
    *
    * @param bgNumId the primary key of the bg num
    * @return the bg num
    * @throws gov.va.caret.NoSuchBgNumException if a bg num with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgNum findByPrimaryKey(long bgNumId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgNumException;

    /**
    * Returns the bg num with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param bgNumId the primary key of the bg num
    * @return the bg num, or <code>null</code> if a bg num with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgNum fetchByPrimaryKey(long bgNumId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the bg nums.
    *
    * @return the bg nums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgNum> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the bg nums.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgNumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bg nums
    * @param end the upper bound of the range of bg nums (not inclusive)
    * @return the range of bg nums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgNum> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the bg nums.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgNumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bg nums
    * @param end the upper bound of the range of bg nums (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of bg nums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgNum> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the bg nums from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of bg nums.
    *
    * @return the number of bg nums
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
