/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.BgMem;

import java.util.List;

/**
 * The persistence utility for the bg mem service. This utility wraps {@link BgMemPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BgMemPersistence
 * @see BgMemPersistenceImpl
 * @generated
 */
public class BgMemUtil {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
	 */

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
	 */
	public static void clearCache() {
		getPersistence().clearCache();
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
	 */
	public static void clearCache(BgMem bgMem) {
		getPersistence().clearCache(bgMem);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
	 */
	public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
		throws SystemException {
		return getPersistence().countWithDynamicQuery(dynamicQuery);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
	 */
	public static List<BgMem> findWithDynamicQuery(DynamicQuery dynamicQuery)
		throws SystemException {
		return getPersistence().findWithDynamicQuery(dynamicQuery);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
	 */
	public static List<BgMem> findWithDynamicQuery(DynamicQuery dynamicQuery,
		int start, int end) throws SystemException {
		return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
	 */
	public static List<BgMem> findWithDynamicQuery(DynamicQuery dynamicQuery,
		int start, int end, OrderByComparator orderByComparator)
		throws SystemException {
		return getPersistence()
				   .findWithDynamicQuery(dynamicQuery, start, end,
			orderByComparator);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
	 */
	public static BgMem update(BgMem bgMem) throws SystemException {
		return getPersistence().update(bgMem);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
	 */
	public static BgMem update(BgMem bgMem, ServiceContext serviceContext)
		throws SystemException {
		return getPersistence().update(bgMem, serviceContext);
	}

	/**
	* Returns all the bg mems where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @return the matching bg mems
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<gov.va.caret.model.BgMem> findByBoxGroupMediumAssociations(
		long ownerId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findByBoxGroupMediumAssociations(ownerId);
	}

	/**
	* Returns a range of all the bg mems where ownerId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgMemModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param ownerId the owner ID
	* @param start the lower bound of the range of bg mems
	* @param end the upper bound of the range of bg mems (not inclusive)
	* @return the range of matching bg mems
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<gov.va.caret.model.BgMem> findByBoxGroupMediumAssociations(
		long ownerId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .findByBoxGroupMediumAssociations(ownerId, start, end);
	}

	/**
	* Returns an ordered range of all the bg mems where ownerId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgMemModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param ownerId the owner ID
	* @param start the lower bound of the range of bg mems
	* @param end the upper bound of the range of bg mems (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching bg mems
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<gov.va.caret.model.BgMem> findByBoxGroupMediumAssociations(
		long ownerId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .findByBoxGroupMediumAssociations(ownerId, start, end,
			orderByComparator);
	}

	/**
	* Returns the first bg mem in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching bg mem
	* @throws gov.va.caret.NoSuchBgMemException if a matching bg mem could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.BgMem findByBoxGroupMediumAssociations_First(
		long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchBgMemException {
		return getPersistence()
				   .findByBoxGroupMediumAssociations_First(ownerId,
			orderByComparator);
	}

	/**
	* Returns the first bg mem in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching bg mem, or <code>null</code> if a matching bg mem could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.BgMem fetchByBoxGroupMediumAssociations_First(
		long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .fetchByBoxGroupMediumAssociations_First(ownerId,
			orderByComparator);
	}

	/**
	* Returns the last bg mem in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching bg mem
	* @throws gov.va.caret.NoSuchBgMemException if a matching bg mem could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.BgMem findByBoxGroupMediumAssociations_Last(
		long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchBgMemException {
		return getPersistence()
				   .findByBoxGroupMediumAssociations_Last(ownerId,
			orderByComparator);
	}

	/**
	* Returns the last bg mem in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching bg mem, or <code>null</code> if a matching bg mem could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.BgMem fetchByBoxGroupMediumAssociations_Last(
		long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .fetchByBoxGroupMediumAssociations_Last(ownerId,
			orderByComparator);
	}

	/**
	* Returns the bg mems before and after the current bg mem in the ordered set where ownerId = &#63;.
	*
	* @param bgMemId the primary key of the current bg mem
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next bg mem
	* @throws gov.va.caret.NoSuchBgMemException if a bg mem with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.BgMem[] findByBoxGroupMediumAssociations_PrevAndNext(
		long bgMemId, long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchBgMemException {
		return getPersistence()
				   .findByBoxGroupMediumAssociations_PrevAndNext(bgMemId,
			ownerId, orderByComparator);
	}

	/**
	* Removes all the bg mems where ownerId = &#63; from the database.
	*
	* @param ownerId the owner ID
	* @throws SystemException if a system exception occurred
	*/
	public static void removeByBoxGroupMediumAssociations(long ownerId)
		throws com.liferay.portal.kernel.exception.SystemException {
		getPersistence().removeByBoxGroupMediumAssociations(ownerId);
	}

	/**
	* Returns the number of bg mems where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @return the number of matching bg mems
	* @throws SystemException if a system exception occurred
	*/
	public static int countByBoxGroupMediumAssociations(long ownerId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().countByBoxGroupMediumAssociations(ownerId);
	}

	/**
	* Returns the bg mem where ownerId = &#63; and boxGpId = &#63; or throws a {@link gov.va.caret.NoSuchBgMemException} if it could not be found.
	*
	* @param ownerId the owner ID
	* @param boxGpId the box gp ID
	* @return the matching bg mem
	* @throws gov.va.caret.NoSuchBgMemException if a matching bg mem could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.BgMem findByBgMemAsnInst(long ownerId,
		long boxGpId)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchBgMemException {
		return getPersistence().findByBgMemAsnInst(ownerId, boxGpId);
	}

	/**
	* Returns the bg mem where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
	*
	* @param ownerId the owner ID
	* @param boxGpId the box gp ID
	* @return the matching bg mem, or <code>null</code> if a matching bg mem could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.BgMem fetchByBgMemAsnInst(long ownerId,
		long boxGpId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByBgMemAsnInst(ownerId, boxGpId);
	}

	/**
	* Returns the bg mem where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
	*
	* @param ownerId the owner ID
	* @param boxGpId the box gp ID
	* @param retrieveFromCache whether to use the finder cache
	* @return the matching bg mem, or <code>null</code> if a matching bg mem could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.BgMem fetchByBgMemAsnInst(long ownerId,
		long boxGpId, boolean retrieveFromCache)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .fetchByBgMemAsnInst(ownerId, boxGpId, retrieveFromCache);
	}

	/**
	* Removes the bg mem where ownerId = &#63; and boxGpId = &#63; from the database.
	*
	* @param ownerId the owner ID
	* @param boxGpId the box gp ID
	* @return the bg mem that was removed
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.BgMem removeByBgMemAsnInst(long ownerId,
		long boxGpId)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchBgMemException {
		return getPersistence().removeByBgMemAsnInst(ownerId, boxGpId);
	}

	/**
	* Returns the number of bg mems where ownerId = &#63; and boxGpId = &#63;.
	*
	* @param ownerId the owner ID
	* @param boxGpId the box gp ID
	* @return the number of matching bg mems
	* @throws SystemException if a system exception occurred
	*/
	public static int countByBgMemAsnInst(long ownerId, long boxGpId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().countByBgMemAsnInst(ownerId, boxGpId);
	}

	/**
	* Caches the bg mem in the entity cache if it is enabled.
	*
	* @param bgMem the bg mem
	*/
	public static void cacheResult(gov.va.caret.model.BgMem bgMem) {
		getPersistence().cacheResult(bgMem);
	}

	/**
	* Caches the bg mems in the entity cache if it is enabled.
	*
	* @param bgMems the bg mems
	*/
	public static void cacheResult(
		java.util.List<gov.va.caret.model.BgMem> bgMems) {
		getPersistence().cacheResult(bgMems);
	}

	/**
	* Creates a new bg mem with the primary key. Does not add the bg mem to the database.
	*
	* @param bgMemId the primary key for the new bg mem
	* @return the new bg mem
	*/
	public static gov.va.caret.model.BgMem create(long bgMemId) {
		return getPersistence().create(bgMemId);
	}

	/**
	* Removes the bg mem with the primary key from the database. Also notifies the appropriate model listeners.
	*
	* @param bgMemId the primary key of the bg mem
	* @return the bg mem that was removed
	* @throws gov.va.caret.NoSuchBgMemException if a bg mem with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.BgMem remove(long bgMemId)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchBgMemException {
		return getPersistence().remove(bgMemId);
	}

	public static gov.va.caret.model.BgMem updateImpl(
		gov.va.caret.model.BgMem bgMem)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().updateImpl(bgMem);
	}

	/**
	* Returns the bg mem with the primary key or throws a {@link gov.va.caret.NoSuchBgMemException} if it could not be found.
	*
	* @param bgMemId the primary key of the bg mem
	* @return the bg mem
	* @throws gov.va.caret.NoSuchBgMemException if a bg mem with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.BgMem findByPrimaryKey(long bgMemId)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchBgMemException {
		return getPersistence().findByPrimaryKey(bgMemId);
	}

	/**
	* Returns the bg mem with the primary key or returns <code>null</code> if it could not be found.
	*
	* @param bgMemId the primary key of the bg mem
	* @return the bg mem, or <code>null</code> if a bg mem with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.BgMem fetchByPrimaryKey(long bgMemId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByPrimaryKey(bgMemId);
	}

	/**
	* Returns all the bg mems.
	*
	* @return the bg mems
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<gov.va.caret.model.BgMem> findAll()
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findAll();
	}

	/**
	* Returns a range of all the bg mems.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgMemModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param start the lower bound of the range of bg mems
	* @param end the upper bound of the range of bg mems (not inclusive)
	* @return the range of bg mems
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<gov.va.caret.model.BgMem> findAll(int start,
		int end) throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findAll(start, end);
	}

	/**
	* Returns an ordered range of all the bg mems.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgMemModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param start the lower bound of the range of bg mems
	* @param end the upper bound of the range of bg mems (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of bg mems
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<gov.va.caret.model.BgMem> findAll(int start,
		int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findAll(start, end, orderByComparator);
	}

	/**
	* Removes all the bg mems from the database.
	*
	* @throws SystemException if a system exception occurred
	*/
	public static void removeAll()
		throws com.liferay.portal.kernel.exception.SystemException {
		getPersistence().removeAll();
	}

	/**
	* Returns the number of bg mems.
	*
	* @return the number of bg mems
	* @throws SystemException if a system exception occurred
	*/
	public static int countAll()
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().countAll();
	}

	public static BgMemPersistence getPersistence() {
		if (_persistence == null) {
			_persistence = (BgMemPersistence)PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
					BgMemPersistence.class.getName());

			ReferenceRegistry.registerReference(BgMemUtil.class, "_persistence");
		}

		return _persistence;
	}

	/**
	 * @deprecated As of 6.2.0
	 */
	public void setPersistence(BgMemPersistence persistence) {
	}

	private static BgMemPersistence _persistence;
}