/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.BgMem;

/**
 * The persistence interface for the bg mem service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BgMemPersistenceImpl
 * @see BgMemUtil
 * @generated
 */
public interface BgMemPersistence extends BasePersistence<BgMem> {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. Always use {@link BgMemUtil} to access the bg mem persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
	 */

	/**
	* Returns all the bg mems where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @return the matching bg mems
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.BgMem> findByBoxGroupMediumAssociations(
		long ownerId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the bg mems where ownerId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgMemModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param ownerId the owner ID
	* @param start the lower bound of the range of bg mems
	* @param end the upper bound of the range of bg mems (not inclusive)
	* @return the range of matching bg mems
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.BgMem> findByBoxGroupMediumAssociations(
		long ownerId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the bg mems where ownerId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgMemModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param ownerId the owner ID
	* @param start the lower bound of the range of bg mems
	* @param end the upper bound of the range of bg mems (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching bg mems
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.BgMem> findByBoxGroupMediumAssociations(
		long ownerId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the first bg mem in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching bg mem
	* @throws gov.va.caret.NoSuchBgMemException if a matching bg mem could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.BgMem findByBoxGroupMediumAssociations_First(
		long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchBgMemException;

	/**
	* Returns the first bg mem in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching bg mem, or <code>null</code> if a matching bg mem could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.BgMem fetchByBoxGroupMediumAssociations_First(
		long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the last bg mem in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching bg mem
	* @throws gov.va.caret.NoSuchBgMemException if a matching bg mem could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.BgMem findByBoxGroupMediumAssociations_Last(
		long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchBgMemException;

	/**
	* Returns the last bg mem in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching bg mem, or <code>null</code> if a matching bg mem could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.BgMem fetchByBoxGroupMediumAssociations_Last(
		long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the bg mems before and after the current bg mem in the ordered set where ownerId = &#63;.
	*
	* @param bgMemId the primary key of the current bg mem
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next bg mem
	* @throws gov.va.caret.NoSuchBgMemException if a bg mem with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.BgMem[] findByBoxGroupMediumAssociations_PrevAndNext(
		long bgMemId, long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchBgMemException;

	/**
	* Removes all the bg mems where ownerId = &#63; from the database.
	*
	* @param ownerId the owner ID
	* @throws SystemException if a system exception occurred
	*/
	public void removeByBoxGroupMediumAssociations(long ownerId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of bg mems where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @return the number of matching bg mems
	* @throws SystemException if a system exception occurred
	*/
	public int countByBoxGroupMediumAssociations(long ownerId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the bg mem where ownerId = &#63; and boxGpId = &#63; or throws a {@link gov.va.caret.NoSuchBgMemException} if it could not be found.
	*
	* @param ownerId the owner ID
	* @param boxGpId the box gp ID
	* @return the matching bg mem
	* @throws gov.va.caret.NoSuchBgMemException if a matching bg mem could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.BgMem findByBgMemAsnInst(long ownerId,
		long boxGpId)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchBgMemException;

	/**
	* Returns the bg mem where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
	*
	* @param ownerId the owner ID
	* @param boxGpId the box gp ID
	* @return the matching bg mem, or <code>null</code> if a matching bg mem could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.BgMem fetchByBgMemAsnInst(long ownerId,
		long boxGpId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the bg mem where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
	*
	* @param ownerId the owner ID
	* @param boxGpId the box gp ID
	* @param retrieveFromCache whether to use the finder cache
	* @return the matching bg mem, or <code>null</code> if a matching bg mem could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.BgMem fetchByBgMemAsnInst(long ownerId,
		long boxGpId, boolean retrieveFromCache)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Removes the bg mem where ownerId = &#63; and boxGpId = &#63; from the database.
	*
	* @param ownerId the owner ID
	* @param boxGpId the box gp ID
	* @return the bg mem that was removed
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.BgMem removeByBgMemAsnInst(long ownerId,
		long boxGpId)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchBgMemException;

	/**
	* Returns the number of bg mems where ownerId = &#63; and boxGpId = &#63;.
	*
	* @param ownerId the owner ID
	* @param boxGpId the box gp ID
	* @return the number of matching bg mems
	* @throws SystemException if a system exception occurred
	*/
	public int countByBgMemAsnInst(long ownerId, long boxGpId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Caches the bg mem in the entity cache if it is enabled.
	*
	* @param bgMem the bg mem
	*/
	public void cacheResult(gov.va.caret.model.BgMem bgMem);

	/**
	* Caches the bg mems in the entity cache if it is enabled.
	*
	* @param bgMems the bg mems
	*/
	public void cacheResult(java.util.List<gov.va.caret.model.BgMem> bgMems);

	/**
	* Creates a new bg mem with the primary key. Does not add the bg mem to the database.
	*
	* @param bgMemId the primary key for the new bg mem
	* @return the new bg mem
	*/
	public gov.va.caret.model.BgMem create(long bgMemId);

	/**
	* Removes the bg mem with the primary key from the database. Also notifies the appropriate model listeners.
	*
	* @param bgMemId the primary key of the bg mem
	* @return the bg mem that was removed
	* @throws gov.va.caret.NoSuchBgMemException if a bg mem with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.BgMem remove(long bgMemId)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchBgMemException;

	public gov.va.caret.model.BgMem updateImpl(gov.va.caret.model.BgMem bgMem)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the bg mem with the primary key or throws a {@link gov.va.caret.NoSuchBgMemException} if it could not be found.
	*
	* @param bgMemId the primary key of the bg mem
	* @return the bg mem
	* @throws gov.va.caret.NoSuchBgMemException if a bg mem with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.BgMem findByPrimaryKey(long bgMemId)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchBgMemException;

	/**
	* Returns the bg mem with the primary key or returns <code>null</code> if it could not be found.
	*
	* @param bgMemId the primary key of the bg mem
	* @return the bg mem, or <code>null</code> if a bg mem with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.BgMem fetchByPrimaryKey(long bgMemId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns all the bg mems.
	*
	* @return the bg mems
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.BgMem> findAll()
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the bg mems.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgMemModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param start the lower bound of the range of bg mems
	* @param end the upper bound of the range of bg mems (not inclusive)
	* @return the range of bg mems
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.BgMem> findAll(int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the bg mems.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgMemModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param start the lower bound of the range of bg mems
	* @param end the upper bound of the range of bg mems (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of bg mems
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.BgMem> findAll(int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Removes all the bg mems from the database.
	*
	* @throws SystemException if a system exception occurred
	*/
	public void removeAll()
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of bg mems.
	*
	* @return the number of bg mems
	* @throws SystemException if a system exception occurred
	*/
	public int countAll()
		throws com.liferay.portal.kernel.exception.SystemException;
}