package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.BgAsn;

/**
 * The persistence interface for the bg asn service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BgAsnPersistenceImpl
 * @see BgAsnUtil
 * @generated
 */
public interface BgAsnPersistence extends BasePersistence<BgAsn> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link BgAsnUtil} to access the bg asn persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the bg asns where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @return the matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgAsn> findByBoxGroupAssociations(
        long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the bg asns where ownerId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param start the lower bound of the range of bg asns
    * @param end the upper bound of the range of bg asns (not inclusive)
    * @return the range of matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgAsn> findByBoxGroupAssociations(
        long ownerId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the bg asns where ownerId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param start the lower bound of the range of bg asns
    * @param end the upper bound of the range of bg asns (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgAsn> findByBoxGroupAssociations(
        long ownerId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first bg asn in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn findByBoxGroupAssociations_First(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException;

    /**
    * Returns the first bg asn in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg asn, or <code>null</code> if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn fetchByBoxGroupAssociations_First(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last bg asn in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn findByBoxGroupAssociations_Last(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException;

    /**
    * Returns the last bg asn in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg asn, or <code>null</code> if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn fetchByBoxGroupAssociations_Last(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bg asns before and after the current bg asn in the ordered set where ownerId = &#63;.
    *
    * @param bgAsnId the primary key of the current bg asn
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a bg asn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn[] findByBoxGroupAssociations_PrevAndNext(
        long bgAsnId, long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException;

    /**
    * Removes all the bg asns where ownerId = &#63; from the database.
    *
    * @param ownerId the owner ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByBoxGroupAssociations(long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of bg asns where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @return the number of matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public int countByBoxGroupAssociations(long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the bg asns where ownerId = &#63; and selected = &#63;.
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @return the matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgAsn> findBySelectedBoxGroupAssociations(
        long ownerId, boolean selected)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the bg asns where ownerId = &#63; and selected = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @param start the lower bound of the range of bg asns
    * @param end the upper bound of the range of bg asns (not inclusive)
    * @return the range of matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgAsn> findBySelectedBoxGroupAssociations(
        long ownerId, boolean selected, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the bg asns where ownerId = &#63; and selected = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @param start the lower bound of the range of bg asns
    * @param end the upper bound of the range of bg asns (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgAsn> findBySelectedBoxGroupAssociations(
        long ownerId, boolean selected, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first bg asn in the ordered set where ownerId = &#63; and selected = &#63;.
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn findBySelectedBoxGroupAssociations_First(
        long ownerId, boolean selected,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException;

    /**
    * Returns the first bg asn in the ordered set where ownerId = &#63; and selected = &#63;.
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg asn, or <code>null</code> if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn fetchBySelectedBoxGroupAssociations_First(
        long ownerId, boolean selected,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last bg asn in the ordered set where ownerId = &#63; and selected = &#63;.
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn findBySelectedBoxGroupAssociations_Last(
        long ownerId, boolean selected,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException;

    /**
    * Returns the last bg asn in the ordered set where ownerId = &#63; and selected = &#63;.
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg asn, or <code>null</code> if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn fetchBySelectedBoxGroupAssociations_Last(
        long ownerId, boolean selected,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bg asns before and after the current bg asn in the ordered set where ownerId = &#63; and selected = &#63;.
    *
    * @param bgAsnId the primary key of the current bg asn
    * @param ownerId the owner ID
    * @param selected the selected
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a bg asn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn[] findBySelectedBoxGroupAssociations_PrevAndNext(
        long bgAsnId, long ownerId, boolean selected,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException;

    /**
    * Removes all the bg asns where ownerId = &#63; and selected = &#63; from the database.
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @throws SystemException if a system exception occurred
    */
    public void removeBySelectedBoxGroupAssociations(long ownerId,
        boolean selected)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of bg asns where ownerId = &#63; and selected = &#63;.
    *
    * @param ownerId the owner ID
    * @param selected the selected
    * @return the number of matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public int countBySelectedBoxGroupAssociations(long ownerId,
        boolean selected)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bg asn where ownerId = &#63; and boxGpId = &#63; or throws a {@link gov.va.caret.NoSuchBgAsnException} if it could not be found.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the matching bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn findByBgAsnInst(long ownerId, long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException;

    /**
    * Returns the bg asn where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the matching bg asn, or <code>null</code> if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn fetchByBgAsnInst(long ownerId, long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bg asn where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching bg asn, or <code>null</code> if a matching bg asn could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn fetchByBgAsnInst(long ownerId,
        long boxGpId, boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes the bg asn where ownerId = &#63; and boxGpId = &#63; from the database.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the bg asn that was removed
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn removeByBgAsnInst(long ownerId, long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException;

    /**
    * Returns the number of bg asns where ownerId = &#63; and boxGpId = &#63;.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the number of matching bg asns
    * @throws SystemException if a system exception occurred
    */
    public int countByBgAsnInst(long ownerId, long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the bg asn in the entity cache if it is enabled.
    *
    * @param bgAsn the bg asn
    */
    public void cacheResult(gov.va.caret.model.BgAsn bgAsn);

    /**
    * Caches the bg asns in the entity cache if it is enabled.
    *
    * @param bgAsns the bg asns
    */
    public void cacheResult(java.util.List<gov.va.caret.model.BgAsn> bgAsns);

    /**
    * Creates a new bg asn with the primary key. Does not add the bg asn to the database.
    *
    * @param bgAsnId the primary key for the new bg asn
    * @return the new bg asn
    */
    public gov.va.caret.model.BgAsn create(long bgAsnId);

    /**
    * Removes the bg asn with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param bgAsnId the primary key of the bg asn
    * @return the bg asn that was removed
    * @throws gov.va.caret.NoSuchBgAsnException if a bg asn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn remove(long bgAsnId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException;

    public gov.va.caret.model.BgAsn updateImpl(gov.va.caret.model.BgAsn bgAsn)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bg asn with the primary key or throws a {@link gov.va.caret.NoSuchBgAsnException} if it could not be found.
    *
    * @param bgAsnId the primary key of the bg asn
    * @return the bg asn
    * @throws gov.va.caret.NoSuchBgAsnException if a bg asn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn findByPrimaryKey(long bgAsnId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgAsnException;

    /**
    * Returns the bg asn with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param bgAsnId the primary key of the bg asn
    * @return the bg asn, or <code>null</code> if a bg asn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgAsn fetchByPrimaryKey(long bgAsnId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the bg asns.
    *
    * @return the bg asns
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgAsn> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the bg asns.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bg asns
    * @param end the upper bound of the range of bg asns (not inclusive)
    * @return the range of bg asns
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgAsn> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the bg asns.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bg asns
    * @param end the upper bound of the range of bg asns (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of bg asns
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgAsn> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the bg asns from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of bg asns.
    *
    * @return the number of bg asns
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
