package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.AudLg;

import java.util.List;

/**
 * The persistence utility for the aud lg service. This utility wraps {@link AudLgPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see AudLgPersistence
 * @see AudLgPersistenceImpl
 * @generated
 */
public class AudLgUtil {
    private static AudLgPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(AudLg audLg) {
        getPersistence().clearCache(audLg);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<AudLg> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<AudLg> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<AudLg> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static AudLg update(AudLg audLg) throws SystemException {
        return getPersistence().update(audLg);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static AudLg update(AudLg audLg, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(audLg, serviceContext);
    }

    /**
    * Returns the aud lg where classId = &#63; and classPk = &#63; and attribute = &#63; or throws a {@link gov.va.caret.NoSuchAudLgException} if it could not be found.
    *
    * @param classId the class ID
    * @param classPk the class pk
    * @param attribute the attribute
    * @return the matching aud lg
    * @throws gov.va.caret.NoSuchAudLgException if a matching aud lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.AudLg findByAttribute(long classId,
        long classPk, java.lang.String attribute)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAudLgException {
        return getPersistence().findByAttribute(classId, classPk, attribute);
    }

    /**
    * Returns the aud lg where classId = &#63; and classPk = &#63; and attribute = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param classId the class ID
    * @param classPk the class pk
    * @param attribute the attribute
    * @return the matching aud lg, or <code>null</code> if a matching aud lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.AudLg fetchByAttribute(long classId,
        long classPk, java.lang.String attribute)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByAttribute(classId, classPk, attribute);
    }

    /**
    * Returns the aud lg where classId = &#63; and classPk = &#63; and attribute = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param classId the class ID
    * @param classPk the class pk
    * @param attribute the attribute
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching aud lg, or <code>null</code> if a matching aud lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.AudLg fetchByAttribute(long classId,
        long classPk, java.lang.String attribute, boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByAttribute(classId, classPk, attribute,
            retrieveFromCache);
    }

    /**
    * Removes the aud lg where classId = &#63; and classPk = &#63; and attribute = &#63; from the database.
    *
    * @param classId the class ID
    * @param classPk the class pk
    * @param attribute the attribute
    * @return the aud lg that was removed
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.AudLg removeByAttribute(long classId,
        long classPk, java.lang.String attribute)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAudLgException {
        return getPersistence().removeByAttribute(classId, classPk, attribute);
    }

    /**
    * Returns the number of aud lgs where classId = &#63; and classPk = &#63; and attribute = &#63;.
    *
    * @param classId the class ID
    * @param classPk the class pk
    * @param attribute the attribute
    * @return the number of matching aud lgs
    * @throws SystemException if a system exception occurred
    */
    public static int countByAttribute(long classId, long classPk,
        java.lang.String attribute)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByAttribute(classId, classPk, attribute);
    }

    /**
    * Caches the aud lg in the entity cache if it is enabled.
    *
    * @param audLg the aud lg
    */
    public static void cacheResult(gov.va.caret.model.AudLg audLg) {
        getPersistence().cacheResult(audLg);
    }

    /**
    * Caches the aud lgs in the entity cache if it is enabled.
    *
    * @param audLgs the aud lgs
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.AudLg> audLgs) {
        getPersistence().cacheResult(audLgs);
    }

    /**
    * Creates a new aud lg with the primary key. Does not add the aud lg to the database.
    *
    * @param audLgId the primary key for the new aud lg
    * @return the new aud lg
    */
    public static gov.va.caret.model.AudLg create(long audLgId) {
        return getPersistence().create(audLgId);
    }

    /**
    * Removes the aud lg with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param audLgId the primary key of the aud lg
    * @return the aud lg that was removed
    * @throws gov.va.caret.NoSuchAudLgException if a aud lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.AudLg remove(long audLgId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAudLgException {
        return getPersistence().remove(audLgId);
    }

    public static gov.va.caret.model.AudLg updateImpl(
        gov.va.caret.model.AudLg audLg)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(audLg);
    }

    /**
    * Returns the aud lg with the primary key or throws a {@link gov.va.caret.NoSuchAudLgException} if it could not be found.
    *
    * @param audLgId the primary key of the aud lg
    * @return the aud lg
    * @throws gov.va.caret.NoSuchAudLgException if a aud lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.AudLg findByPrimaryKey(long audLgId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAudLgException {
        return getPersistence().findByPrimaryKey(audLgId);
    }

    /**
    * Returns the aud lg with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param audLgId the primary key of the aud lg
    * @return the aud lg, or <code>null</code> if a aud lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.AudLg fetchByPrimaryKey(long audLgId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(audLgId);
    }

    /**
    * Returns all the aud lgs.
    *
    * @return the aud lgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.AudLg> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the aud lgs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AudLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of aud lgs
    * @param end the upper bound of the range of aud lgs (not inclusive)
    * @return the range of aud lgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.AudLg> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the aud lgs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AudLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of aud lgs
    * @param end the upper bound of the range of aud lgs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of aud lgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.AudLg> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the aud lgs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of aud lgs.
    *
    * @return the number of aud lgs
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static AudLgPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (AudLgPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    AudLgPersistence.class.getName());

            ReferenceRegistry.registerReference(AudLgUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(AudLgPersistence persistence) {
    }
}
