package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.AudLg;

/**
 * The persistence interface for the aud lg service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see AudLgPersistenceImpl
 * @see AudLgUtil
 * @generated
 */
public interface AudLgPersistence extends BasePersistence<AudLg> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link AudLgUtil} to access the aud lg persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns the aud lg where classId = &#63; and classPk = &#63; and attribute = &#63; or throws a {@link gov.va.caret.NoSuchAudLgException} if it could not be found.
    *
    * @param classId the class ID
    * @param classPk the class pk
    * @param attribute the attribute
    * @return the matching aud lg
    * @throws gov.va.caret.NoSuchAudLgException if a matching aud lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.AudLg findByAttribute(long classId, long classPk,
        java.lang.String attribute)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAudLgException;

    /**
    * Returns the aud lg where classId = &#63; and classPk = &#63; and attribute = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param classId the class ID
    * @param classPk the class pk
    * @param attribute the attribute
    * @return the matching aud lg, or <code>null</code> if a matching aud lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.AudLg fetchByAttribute(long classId,
        long classPk, java.lang.String attribute)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the aud lg where classId = &#63; and classPk = &#63; and attribute = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param classId the class ID
    * @param classPk the class pk
    * @param attribute the attribute
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching aud lg, or <code>null</code> if a matching aud lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.AudLg fetchByAttribute(long classId,
        long classPk, java.lang.String attribute, boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes the aud lg where classId = &#63; and classPk = &#63; and attribute = &#63; from the database.
    *
    * @param classId the class ID
    * @param classPk the class pk
    * @param attribute the attribute
    * @return the aud lg that was removed
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.AudLg removeByAttribute(long classId,
        long classPk, java.lang.String attribute)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAudLgException;

    /**
    * Returns the number of aud lgs where classId = &#63; and classPk = &#63; and attribute = &#63;.
    *
    * @param classId the class ID
    * @param classPk the class pk
    * @param attribute the attribute
    * @return the number of matching aud lgs
    * @throws SystemException if a system exception occurred
    */
    public int countByAttribute(long classId, long classPk,
        java.lang.String attribute)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the aud lg in the entity cache if it is enabled.
    *
    * @param audLg the aud lg
    */
    public void cacheResult(gov.va.caret.model.AudLg audLg);

    /**
    * Caches the aud lgs in the entity cache if it is enabled.
    *
    * @param audLgs the aud lgs
    */
    public void cacheResult(java.util.List<gov.va.caret.model.AudLg> audLgs);

    /**
    * Creates a new aud lg with the primary key. Does not add the aud lg to the database.
    *
    * @param audLgId the primary key for the new aud lg
    * @return the new aud lg
    */
    public gov.va.caret.model.AudLg create(long audLgId);

    /**
    * Removes the aud lg with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param audLgId the primary key of the aud lg
    * @return the aud lg that was removed
    * @throws gov.va.caret.NoSuchAudLgException if a aud lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.AudLg remove(long audLgId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAudLgException;

    public gov.va.caret.model.AudLg updateImpl(gov.va.caret.model.AudLg audLg)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the aud lg with the primary key or throws a {@link gov.va.caret.NoSuchAudLgException} if it could not be found.
    *
    * @param audLgId the primary key of the aud lg
    * @return the aud lg
    * @throws gov.va.caret.NoSuchAudLgException if a aud lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.AudLg findByPrimaryKey(long audLgId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAudLgException;

    /**
    * Returns the aud lg with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param audLgId the primary key of the aud lg
    * @return the aud lg, or <code>null</code> if a aud lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.AudLg fetchByPrimaryKey(long audLgId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the aud lgs.
    *
    * @return the aud lgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.AudLg> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the aud lgs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AudLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of aud lgs
    * @param end the upper bound of the range of aud lgs (not inclusive)
    * @return the range of aud lgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.AudLg> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the aud lgs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AudLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of aud lgs
    * @param end the upper bound of the range of aud lgs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of aud lgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.AudLg> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the aud lgs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of aud lgs.
    *
    * @return the number of aud lgs
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
