package gov.va.caret.service;

import com.liferay.portal.service.ServiceWrapper;

/**
 * Provides a wrapper for {@link BgAsnLocalService}.
 *
 * @author caret
 * @see BgAsnLocalService
 * @generated
 */
public class BgAsnLocalServiceWrapper implements BgAsnLocalService,
    ServiceWrapper<BgAsnLocalService> {
    private BgAsnLocalService _bgAsnLocalService;

    public BgAsnLocalServiceWrapper(BgAsnLocalService bgAsnLocalService) {
        _bgAsnLocalService = bgAsnLocalService;
    }

    /**
    * Adds the bg asn to the database. Also notifies the appropriate model listeners.
    *
    * @param bgAsn the bg asn
    * @return the bg asn that was added
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.BgAsn addBgAsn(gov.va.caret.model.BgAsn bgAsn)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgAsnLocalService.addBgAsn(bgAsn);
    }

    /**
    * Creates a new bg asn with the primary key. Does not add the bg asn to the database.
    *
    * @param bgAsnId the primary key for the new bg asn
    * @return the new bg asn
    */
    @Override
    public gov.va.caret.model.BgAsn createBgAsn(long bgAsnId) {
        return _bgAsnLocalService.createBgAsn(bgAsnId);
    }

    /**
    * Deletes the bg asn with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param bgAsnId the primary key of the bg asn
    * @return the bg asn that was removed
    * @throws PortalException if a bg asn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.BgAsn deleteBgAsn(long bgAsnId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _bgAsnLocalService.deleteBgAsn(bgAsnId);
    }

    /**
    * Deletes the bg asn from the database. Also notifies the appropriate model listeners.
    *
    * @param bgAsn the bg asn
    * @return the bg asn that was removed
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.BgAsn deleteBgAsn(gov.va.caret.model.BgAsn bgAsn)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgAsnLocalService.deleteBgAsn(bgAsn);
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
        return _bgAsnLocalService.dynamicQuery();
    }

    /**
    * Performs a dynamic query on the database and returns the matching rows.
    *
    * @param dynamicQuery the dynamic query
    * @return the matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgAsnLocalService.dynamicQuery(dynamicQuery);
    }

    /**
    * Performs a dynamic query on the database and returns a range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @return the range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return _bgAsnLocalService.dynamicQuery(dynamicQuery, start, end);
    }

    /**
    * Performs a dynamic query on the database and returns an ordered range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgAsnLocalService.dynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    @Override
    public long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgAsnLocalService.dynamicQueryCount(dynamicQuery);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @param projection the projection to apply to the query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    @Override
    public long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery,
        com.liferay.portal.kernel.dao.orm.Projection projection)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgAsnLocalService.dynamicQueryCount(dynamicQuery, projection);
    }

    @Override
    public gov.va.caret.model.BgAsn fetchBgAsn(long bgAsnId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgAsnLocalService.fetchBgAsn(bgAsnId);
    }

    /**
    * Returns the bg asn with the primary key.
    *
    * @param bgAsnId the primary key of the bg asn
    * @return the bg asn
    * @throws PortalException if a bg asn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.BgAsn getBgAsn(long bgAsnId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _bgAsnLocalService.getBgAsn(bgAsnId);
    }

    @Override
    public com.liferay.portal.model.PersistedModel getPersistedModel(
        java.io.Serializable primaryKeyObj)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _bgAsnLocalService.getPersistedModel(primaryKeyObj);
    }

    /**
    * Returns a range of all the bg asns.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bg asns
    * @param end the upper bound of the range of bg asns (not inclusive)
    * @return the range of bg asns
    * @throws SystemException if a system exception occurred
    */
    @Override
    public java.util.List<gov.va.caret.model.BgAsn> getBgAsns(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgAsnLocalService.getBgAsns(start, end);
    }

    /**
    * Returns the number of bg asns.
    *
    * @return the number of bg asns
    * @throws SystemException if a system exception occurred
    */
    @Override
    public int getBgAsnsCount()
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgAsnLocalService.getBgAsnsCount();
    }

    /**
    * Updates the bg asn in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
    *
    * @param bgAsn the bg asn
    * @return the bg asn that was updated
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.BgAsn updateBgAsn(gov.va.caret.model.BgAsn bgAsn)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _bgAsnLocalService.updateBgAsn(bgAsn);
    }

    /**
    * Returns the Spring bean ID for this bean.
    *
    * @return the Spring bean ID for this bean
    */
    @Override
    public java.lang.String getBeanIdentifier() {
        return _bgAsnLocalService.getBeanIdentifier();
    }

    /**
    * Sets the Spring bean ID for this bean.
    *
    * @param beanIdentifier the Spring bean ID for this bean
    */
    @Override
    public void setBeanIdentifier(java.lang.String beanIdentifier) {
        _bgAsnLocalService.setBeanIdentifier(beanIdentifier);
    }

    @Override
    public java.lang.Object invokeMethod(java.lang.String name,
        java.lang.String[] parameterTypes, java.lang.Object[] arguments)
        throws java.lang.Throwable {
        return _bgAsnLocalService.invokeMethod(name, parameterTypes, arguments);
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedService}
     */
    public BgAsnLocalService getWrappedBgAsnLocalService() {
        return _bgAsnLocalService;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #setWrappedService}
     */
    public void setWrappedBgAsnLocalService(BgAsnLocalService bgAsnLocalService) {
        _bgAsnLocalService = bgAsnLocalService;
    }

    @Override
    public BgAsnLocalService getWrappedService() {
        return _bgAsnLocalService;
    }

    @Override
    public void setWrappedService(BgAsnLocalService bgAsnLocalService) {
        _bgAsnLocalService = bgAsnLocalService;
    }
}
