package gov.va.caret.service;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.InvokableLocalService;

/**
 * Provides the local service utility for AudLg. This utility wraps
 * {@link gov.va.caret.service.impl.AudLgLocalServiceImpl} and is the
 * primary access point for service operations in application layer code running
 * on the local server. Methods of this service will not have security checks
 * based on the propagated JAAS credentials because this service can only be
 * accessed from within the same VM.
 *
 * @author caret
 * @see AudLgLocalService
 * @see gov.va.caret.service.base.AudLgLocalServiceBaseImpl
 * @see gov.va.caret.service.impl.AudLgLocalServiceImpl
 * @generated
 */
public class AudLgLocalServiceUtil {
    private static AudLgLocalService _service;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Add custom service methods to {@link gov.va.caret.service.impl.AudLgLocalServiceImpl} and rerun ServiceBuilder to regenerate this class.
     */

    /**
    * Adds the aud lg to the database. Also notifies the appropriate model listeners.
    *
    * @param audLg the aud lg
    * @return the aud lg that was added
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.AudLg addAudLg(
        gov.va.caret.model.AudLg audLg)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().addAudLg(audLg);
    }

    /**
    * Creates a new aud lg with the primary key. Does not add the aud lg to the database.
    *
    * @param audLgId the primary key for the new aud lg
    * @return the new aud lg
    */
    public static gov.va.caret.model.AudLg createAudLg(long audLgId) {
        return getService().createAudLg(audLgId);
    }

    /**
    * Deletes the aud lg with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param audLgId the primary key of the aud lg
    * @return the aud lg that was removed
    * @throws PortalException if a aud lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.AudLg deleteAudLg(long audLgId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return getService().deleteAudLg(audLgId);
    }

    /**
    * Deletes the aud lg from the database. Also notifies the appropriate model listeners.
    *
    * @param audLg the aud lg
    * @return the aud lg that was removed
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.AudLg deleteAudLg(
        gov.va.caret.model.AudLg audLg)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().deleteAudLg(audLg);
    }

    public static com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
        return getService().dynamicQuery();
    }

    /**
    * Performs a dynamic query on the database and returns the matching rows.
    *
    * @param dynamicQuery the dynamic query
    * @return the matching rows
    * @throws SystemException if a system exception occurred
    */
    @SuppressWarnings("rawtypes")
    public static java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().dynamicQuery(dynamicQuery);
    }

    /**
    * Performs a dynamic query on the database and returns a range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AudLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @return the range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @SuppressWarnings("rawtypes")
    public static java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getService().dynamicQuery(dynamicQuery, start, end);
    }

    /**
    * Performs a dynamic query on the database and returns an ordered range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AudLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @SuppressWarnings("rawtypes")
    public static java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService()
                   .dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    public static long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().dynamicQueryCount(dynamicQuery);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @param projection the projection to apply to the query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    public static long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery,
        com.liferay.portal.kernel.dao.orm.Projection projection)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().dynamicQueryCount(dynamicQuery, projection);
    }

    public static gov.va.caret.model.AudLg fetchAudLg(long audLgId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().fetchAudLg(audLgId);
    }

    /**
    * Returns the aud lg with the primary key.
    *
    * @param audLgId the primary key of the aud lg
    * @return the aud lg
    * @throws PortalException if a aud lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.AudLg getAudLg(long audLgId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return getService().getAudLg(audLgId);
    }

    public static com.liferay.portal.model.PersistedModel getPersistedModel(
        java.io.Serializable primaryKeyObj)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return getService().getPersistedModel(primaryKeyObj);
    }

    /**
    * Returns a range of all the aud lgs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AudLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of aud lgs
    * @param end the upper bound of the range of aud lgs (not inclusive)
    * @return the range of aud lgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.AudLg> getAudLgs(
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().getAudLgs(start, end);
    }

    /**
    * Returns the number of aud lgs.
    *
    * @return the number of aud lgs
    * @throws SystemException if a system exception occurred
    */
    public static int getAudLgsCount()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().getAudLgsCount();
    }

    /**
    * Updates the aud lg in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
    *
    * @param audLg the aud lg
    * @return the aud lg that was updated
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.AudLg updateAudLg(
        gov.va.caret.model.AudLg audLg)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getService().updateAudLg(audLg);
    }

    /**
    * Returns the Spring bean ID for this bean.
    *
    * @return the Spring bean ID for this bean
    */
    public static java.lang.String getBeanIdentifier() {
        return getService().getBeanIdentifier();
    }

    /**
    * Sets the Spring bean ID for this bean.
    *
    * @param beanIdentifier the Spring bean ID for this bean
    */
    public static void setBeanIdentifier(java.lang.String beanIdentifier) {
        getService().setBeanIdentifier(beanIdentifier);
    }

    public static java.lang.Object invokeMethod(java.lang.String name,
        java.lang.String[] parameterTypes, java.lang.Object[] arguments)
        throws java.lang.Throwable {
        return getService().invokeMethod(name, parameterTypes, arguments);
    }

    public static com.liferay.portal.model.BaseModel<?> save(
        com.liferay.portal.model.BaseModel<?> model)
        throws gov.va.caret.ApplicationWorkFlowException {
        return getService().save(model);
    }

    public static void clearService() {
        _service = null;
    }

    public static AudLgLocalService getService() {
        if (_service == null) {
            InvokableLocalService invokableLocalService = (InvokableLocalService) PortletBeanLocatorUtil.locate(ClpSerializer.getServletContextName(),
                    AudLgLocalService.class.getName());

            if (invokableLocalService instanceof AudLgLocalService) {
                _service = (AudLgLocalService) invokableLocalService;
            } else {
                _service = new AudLgLocalServiceClp(invokableLocalService);
            }

            ReferenceRegistry.registerReference(AudLgLocalServiceUtil.class,
                "_service");
        }

        return _service;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setService(AudLgLocalService service) {
    }
}
