package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class ZipFySoap implements Serializable {
    private long _zipFyId;
    private long _facilId;
    private String _facilZip;
    private double _distance;

    public ZipFySoap() {
    }

    public static ZipFySoap toSoapModel(ZipFy model) {
        ZipFySoap soapModel = new ZipFySoap();

        soapModel.setZipFyId(model.getZipFyId());
        soapModel.setFacilId(model.getFacilId());
        soapModel.setFacilZip(model.getFacilZip());
        soapModel.setDistance(model.getDistance());

        return soapModel;
    }

    public static ZipFySoap[] toSoapModels(ZipFy[] models) {
        ZipFySoap[] soapModels = new ZipFySoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static ZipFySoap[][] toSoapModels(ZipFy[][] models) {
        ZipFySoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new ZipFySoap[models.length][models[0].length];
        } else {
            soapModels = new ZipFySoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static ZipFySoap[] toSoapModels(List<ZipFy> models) {
        List<ZipFySoap> soapModels = new ArrayList<ZipFySoap>(models.size());

        for (ZipFy model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new ZipFySoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _zipFyId;
    }

    public void setPrimaryKey(long pk) {
        setZipFyId(pk);
    }

    public long getZipFyId() {
        return _zipFyId;
    }

    public void setZipFyId(long zipFyId) {
        _zipFyId = zipFyId;
    }

    public long getFacilId() {
        return _facilId;
    }

    public void setFacilId(long facilId) {
        _facilId = facilId;
    }

    public String getFacilZip() {
        return _facilZip;
    }

    public void setFacilZip(String facilZip) {
        _facilZip = facilZip;
    }

    public double getDistance() {
        return _distance;
    }

    public void setDistance(double distance) {
        _distance = distance;
    }
}
