package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.WorImLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class WorImClp extends BaseModelImpl<WorIm> implements WorIm {
    private long _worImId;
    private String _type;
    private long _classId;
    private long _classPk;
    private String _status;
    private Date _creationDate;
    private Date _dueDate;
    private Date _completionDate;
    private long _completionBy;
    private long _groupId;
    private long _userId;
    private String _userUuid;
    private long _caregiverId;
    private long _persnId;
    private long _queId;
    private long _vcgId;
    private BaseModel<?> _worImRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public WorImClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return WorIm.class;
    }

    @Override
    public String getModelClassName() {
        return WorIm.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _worImId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setWorImId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _worImId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("worImId", getWorImId());
        attributes.put("type", getType());
        attributes.put("classId", getClassId());
        attributes.put("classPk", getClassPk());
        attributes.put("status", getStatus());
        attributes.put("creationDate", getCreationDate());
        attributes.put("dueDate", getDueDate());
        attributes.put("completionDate", getCompletionDate());
        attributes.put("completionBy", getCompletionBy());
        attributes.put("groupId", getGroupId());
        attributes.put("userId", getUserId());
        attributes.put("caregiverId", getCaregiverId());
        attributes.put("persnId", getPersnId());
        attributes.put("queId", getQueId());
        attributes.put("vcgId", getVcgId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long worImId = (Long) attributes.get("worImId");

        if (worImId != null) {
            setWorImId(worImId);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }

        Long classId = (Long) attributes.get("classId");

        if (classId != null) {
            setClassId(classId);
        }

        Long classPk = (Long) attributes.get("classPk");

        if (classPk != null) {
            setClassPk(classPk);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Date dueDate = (Date) attributes.get("dueDate");

        if (dueDate != null) {
            setDueDate(dueDate);
        }

        Date completionDate = (Date) attributes.get("completionDate");

        if (completionDate != null) {
            setCompletionDate(completionDate);
        }

        Long completionBy = (Long) attributes.get("completionBy");

        if (completionBy != null) {
            setCompletionBy(completionBy);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        Long caregiverId = (Long) attributes.get("caregiverId");

        if (caregiverId != null) {
            setCaregiverId(caregiverId);
        }

        Long persnId = (Long) attributes.get("persnId");

        if (persnId != null) {
            setPersnId(persnId);
        }

        Long queId = (Long) attributes.get("queId");

        if (queId != null) {
            setQueId(queId);
        }

        Long vcgId = (Long) attributes.get("vcgId");

        if (vcgId != null) {
            setVcgId(vcgId);
        }
    }

    @Override
    public long getWorImId() {
        return _worImId;
    }

    @Override
    public void setWorImId(long worImId) {
        _worImId = worImId;

        if (_worImRemoteModel != null) {
            try {
                Class<?> clazz = _worImRemoteModel.getClass();

                Method method = clazz.getMethod("setWorImId", long.class);

                method.invoke(_worImRemoteModel, worImId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getType() {
        return _type;
    }

    @Override
    public void setType(String type) {
        _type = type;

        if (_worImRemoteModel != null) {
            try {
                Class<?> clazz = _worImRemoteModel.getClass();

                Method method = clazz.getMethod("setType", String.class);

                method.invoke(_worImRemoteModel, type);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getClassId() {
        return _classId;
    }

    @Override
    public void setClassId(long classId) {
        _classId = classId;

        if (_worImRemoteModel != null) {
            try {
                Class<?> clazz = _worImRemoteModel.getClass();

                Method method = clazz.getMethod("setClassId", long.class);

                method.invoke(_worImRemoteModel, classId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getClassPk() {
        return _classPk;
    }

    @Override
    public void setClassPk(long classPk) {
        _classPk = classPk;

        if (_worImRemoteModel != null) {
            try {
                Class<?> clazz = _worImRemoteModel.getClass();

                Method method = clazz.getMethod("setClassPk", long.class);

                method.invoke(_worImRemoteModel, classPk);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getStatus() {
        return _status;
    }

    @Override
    public void setStatus(String status) {
        _status = status;

        if (_worImRemoteModel != null) {
            try {
                Class<?> clazz = _worImRemoteModel.getClass();

                Method method = clazz.getMethod("setStatus", String.class);

                method.invoke(_worImRemoteModel, status);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;

        if (_worImRemoteModel != null) {
            try {
                Class<?> clazz = _worImRemoteModel.getClass();

                Method method = clazz.getMethod("setCreationDate", Date.class);

                method.invoke(_worImRemoteModel, creationDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getDueDate() {
        return _dueDate;
    }

    @Override
    public void setDueDate(Date dueDate) {
        _dueDate = dueDate;

        if (_worImRemoteModel != null) {
            try {
                Class<?> clazz = _worImRemoteModel.getClass();

                Method method = clazz.getMethod("setDueDate", Date.class);

                method.invoke(_worImRemoteModel, dueDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getCompletionDate() {
        return _completionDate;
    }

    @Override
    public void setCompletionDate(Date completionDate) {
        _completionDate = completionDate;

        if (_worImRemoteModel != null) {
            try {
                Class<?> clazz = _worImRemoteModel.getClass();

                Method method = clazz.getMethod("setCompletionDate", Date.class);

                method.invoke(_worImRemoteModel, completionDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getCompletionBy() {
        return _completionBy;
    }

    @Override
    public void setCompletionBy(long completionBy) {
        _completionBy = completionBy;

        if (_worImRemoteModel != null) {
            try {
                Class<?> clazz = _worImRemoteModel.getClass();

                Method method = clazz.getMethod("setCompletionBy", long.class);

                method.invoke(_worImRemoteModel, completionBy);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;

        if (_worImRemoteModel != null) {
            try {
                Class<?> clazz = _worImRemoteModel.getClass();

                Method method = clazz.getMethod("setGroupId", long.class);

                method.invoke(_worImRemoteModel, groupId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;

        if (_worImRemoteModel != null) {
            try {
                Class<?> clazz = _worImRemoteModel.getClass();

                Method method = clazz.getMethod("setUserId", long.class);

                method.invoke(_worImRemoteModel, userId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    @Override
    public long getCaregiverId() {
        return _caregiverId;
    }

    @Override
    public void setCaregiverId(long caregiverId) {
        _caregiverId = caregiverId;

        if (_worImRemoteModel != null) {
            try {
                Class<?> clazz = _worImRemoteModel.getClass();

                Method method = clazz.getMethod("setCaregiverId", long.class);

                method.invoke(_worImRemoteModel, caregiverId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getPersnId() {
        return _persnId;
    }

    @Override
    public void setPersnId(long persnId) {
        _persnId = persnId;

        if (_worImRemoteModel != null) {
            try {
                Class<?> clazz = _worImRemoteModel.getClass();

                Method method = clazz.getMethod("setPersnId", long.class);

                method.invoke(_worImRemoteModel, persnId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getQueId() {
        return _queId;
    }

    @Override
    public void setQueId(long queId) {
        _queId = queId;

        if (_worImRemoteModel != null) {
            try {
                Class<?> clazz = _worImRemoteModel.getClass();

                Method method = clazz.getMethod("setQueId", long.class);

                method.invoke(_worImRemoteModel, queId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getVcgId() {
        return _vcgId;
    }

    @Override
    public void setVcgId(long vcgId) {
        _vcgId = vcgId;

        if (_worImRemoteModel != null) {
            try {
                Class<?> clazz = _worImRemoteModel.getClass();

                Method method = clazz.getMethod("setVcgId", long.class);

                method.invoke(_worImRemoteModel, vcgId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getWorImRemoteModel() {
        return _worImRemoteModel;
    }

    public void setWorImRemoteModel(BaseModel<?> worImRemoteModel) {
        _worImRemoteModel = worImRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _worImRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_worImRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            WorImLocalServiceUtil.addWorIm(this);
        } else {
            WorImLocalServiceUtil.updateWorIm(this);
        }
    }

    @Override
    public WorIm toEscapedModel() {
        return (WorIm) ProxyUtil.newProxyInstance(WorIm.class.getClassLoader(),
            new Class[] { WorIm.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        WorImClp clone = new WorImClp();

        clone.setWorImId(getWorImId());
        clone.setType(getType());
        clone.setClassId(getClassId());
        clone.setClassPk(getClassPk());
        clone.setStatus(getStatus());
        clone.setCreationDate(getCreationDate());
        clone.setDueDate(getDueDate());
        clone.setCompletionDate(getCompletionDate());
        clone.setCompletionBy(getCompletionBy());
        clone.setGroupId(getGroupId());
        clone.setUserId(getUserId());
        clone.setCaregiverId(getCaregiverId());
        clone.setPersnId(getPersnId());
        clone.setQueId(getQueId());
        clone.setVcgId(getVcgId());

        return clone;
    }

    @Override
    public int compareTo(WorIm worIm) {
        long primaryKey = worIm.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof WorImClp)) {
            return false;
        }

        WorImClp worIm = (WorImClp) obj;

        long primaryKey = worIm.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(31);

        sb.append("{worImId=");
        sb.append(getWorImId());
        sb.append(", type=");
        sb.append(getType());
        sb.append(", classId=");
        sb.append(getClassId());
        sb.append(", classPk=");
        sb.append(getClassPk());
        sb.append(", status=");
        sb.append(getStatus());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", dueDate=");
        sb.append(getDueDate());
        sb.append(", completionDate=");
        sb.append(getCompletionDate());
        sb.append(", completionBy=");
        sb.append(getCompletionBy());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append(", caregiverId=");
        sb.append(getCaregiverId());
        sb.append(", persnId=");
        sb.append(getPersnId());
        sb.append(", queId=");
        sb.append(getQueId());
        sb.append(", vcgId=");
        sb.append(getVcgId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(49);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.WorIm");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>worImId</column-name><column-value><![CDATA[");
        sb.append(getWorImId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>type</column-name><column-value><![CDATA[");
        sb.append(getType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>classId</column-name><column-value><![CDATA[");
        sb.append(getClassId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>classPk</column-name><column-value><![CDATA[");
        sb.append(getClassPk());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>status</column-name><column-value><![CDATA[");
        sb.append(getStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>dueDate</column-name><column-value><![CDATA[");
        sb.append(getDueDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>completionDate</column-name><column-value><![CDATA[");
        sb.append(getCompletionDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>completionBy</column-name><column-value><![CDATA[");
        sb.append(getCompletionBy());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>caregiverId</column-name><column-value><![CDATA[");
        sb.append(getCaregiverId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>persnId</column-name><column-value><![CDATA[");
        sb.append(getPersnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>queId</column-name><column-value><![CDATA[");
        sb.append(getQueId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>vcgId</column-name><column-value><![CDATA[");
        sb.append(getVcgId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
