package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.VendrLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.HashMap;
import java.util.Map;


public class VendrClp extends BaseModelImpl<Vendr> implements Vendr {
    private long _vendrId;
    private String _lastName;
    private String _firstName;
    private String _middleName;
    private String _fedTaxId;
    private String _address;
    private String _address2;
    private String _city;
    private String _state;
    private String _zip;
    private String _phone;
    private String _phone2;
    private String _gracePeriod;
    private String _gracePeriodDuration;
    private String _directDepositInfo;
    private String _paymentMethod;
    private String _crypto1;
    private long _groupId;
    private BaseModel<?> _vendrRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public VendrClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return Vendr.class;
    }

    @Override
    public String getModelClassName() {
        return Vendr.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _vendrId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setVendrId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _vendrId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("vendrId", getVendrId());
        attributes.put("lastName", getLastName());
        attributes.put("firstName", getFirstName());
        attributes.put("middleName", getMiddleName());
        attributes.put("fedTaxId", getFedTaxId());
        attributes.put("address", getAddress());
        attributes.put("address2", getAddress2());
        attributes.put("city", getCity());
        attributes.put("state", getState());
        attributes.put("zip", getZip());
        attributes.put("phone", getPhone());
        attributes.put("phone2", getPhone2());
        attributes.put("gracePeriod", getGracePeriod());
        attributes.put("gracePeriodDuration", getGracePeriodDuration());
        attributes.put("directDepositInfo", getDirectDepositInfo());
        attributes.put("paymentMethod", getPaymentMethod());
        attributes.put("crypto1", getCrypto1());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long vendrId = (Long) attributes.get("vendrId");

        if (vendrId != null) {
            setVendrId(vendrId);
        }

        String lastName = (String) attributes.get("lastName");

        if (lastName != null) {
            setLastName(lastName);
        }

        String firstName = (String) attributes.get("firstName");

        if (firstName != null) {
            setFirstName(firstName);
        }

        String middleName = (String) attributes.get("middleName");

        if (middleName != null) {
            setMiddleName(middleName);
        }

        String fedTaxId = (String) attributes.get("fedTaxId");

        if (fedTaxId != null) {
            setFedTaxId(fedTaxId);
        }

        String address = (String) attributes.get("address");

        if (address != null) {
            setAddress(address);
        }

        String address2 = (String) attributes.get("address2");

        if (address2 != null) {
            setAddress2(address2);
        }

        String city = (String) attributes.get("city");

        if (city != null) {
            setCity(city);
        }

        String state = (String) attributes.get("state");

        if (state != null) {
            setState(state);
        }

        String zip = (String) attributes.get("zip");

        if (zip != null) {
            setZip(zip);
        }

        String phone = (String) attributes.get("phone");

        if (phone != null) {
            setPhone(phone);
        }

        String phone2 = (String) attributes.get("phone2");

        if (phone2 != null) {
            setPhone2(phone2);
        }

        String gracePeriod = (String) attributes.get("gracePeriod");

        if (gracePeriod != null) {
            setGracePeriod(gracePeriod);
        }

        String gracePeriodDuration = (String) attributes.get(
                "gracePeriodDuration");

        if (gracePeriodDuration != null) {
            setGracePeriodDuration(gracePeriodDuration);
        }

        String directDepositInfo = (String) attributes.get("directDepositInfo");

        if (directDepositInfo != null) {
            setDirectDepositInfo(directDepositInfo);
        }

        String paymentMethod = (String) attributes.get("paymentMethod");

        if (paymentMethod != null) {
            setPaymentMethod(paymentMethod);
        }

        String crypto1 = (String) attributes.get("crypto1");

        if (crypto1 != null) {
            setCrypto1(crypto1);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getVendrId() {
        return _vendrId;
    }

    @Override
    public void setVendrId(long vendrId) {
        _vendrId = vendrId;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setVendrId", long.class);

                method.invoke(_vendrRemoteModel, vendrId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getLastName() {
        return _lastName;
    }

    @Override
    public void setLastName(String lastName) {
        _lastName = lastName;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setLastName", String.class);

                method.invoke(_vendrRemoteModel, lastName);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getFirstName() {
        return _firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        _firstName = firstName;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setFirstName", String.class);

                method.invoke(_vendrRemoteModel, firstName);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getMiddleName() {
        return _middleName;
    }

    @Override
    public void setMiddleName(String middleName) {
        _middleName = middleName;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setMiddleName", String.class);

                method.invoke(_vendrRemoteModel, middleName);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getFedTaxId() {
        return _fedTaxId;
    }

    @Override
    public void setFedTaxId(String fedTaxId) {
        _fedTaxId = fedTaxId;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setFedTaxId", String.class);

                method.invoke(_vendrRemoteModel, fedTaxId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getAddress() {
        return _address;
    }

    @Override
    public void setAddress(String address) {
        _address = address;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setAddress", String.class);

                method.invoke(_vendrRemoteModel, address);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getAddress2() {
        return _address2;
    }

    @Override
    public void setAddress2(String address2) {
        _address2 = address2;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setAddress2", String.class);

                method.invoke(_vendrRemoteModel, address2);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCity() {
        return _city;
    }

    @Override
    public void setCity(String city) {
        _city = city;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setCity", String.class);

                method.invoke(_vendrRemoteModel, city);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getState() {
        return _state;
    }

    @Override
    public void setState(String state) {
        _state = state;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setState", String.class);

                method.invoke(_vendrRemoteModel, state);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getZip() {
        return _zip;
    }

    @Override
    public void setZip(String zip) {
        _zip = zip;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setZip", String.class);

                method.invoke(_vendrRemoteModel, zip);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getPhone() {
        return _phone;
    }

    @Override
    public void setPhone(String phone) {
        _phone = phone;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setPhone", String.class);

                method.invoke(_vendrRemoteModel, phone);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getPhone2() {
        return _phone2;
    }

    @Override
    public void setPhone2(String phone2) {
        _phone2 = phone2;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setPhone2", String.class);

                method.invoke(_vendrRemoteModel, phone2);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getGracePeriod() {
        return _gracePeriod;
    }

    @Override
    public void setGracePeriod(String gracePeriod) {
        _gracePeriod = gracePeriod;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setGracePeriod", String.class);

                method.invoke(_vendrRemoteModel, gracePeriod);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getGracePeriodDuration() {
        return _gracePeriodDuration;
    }

    @Override
    public void setGracePeriodDuration(String gracePeriodDuration) {
        _gracePeriodDuration = gracePeriodDuration;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setGracePeriodDuration",
                        String.class);

                method.invoke(_vendrRemoteModel, gracePeriodDuration);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getDirectDepositInfo() {
        return _directDepositInfo;
    }

    @Override
    public void setDirectDepositInfo(String directDepositInfo) {
        _directDepositInfo = directDepositInfo;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setDirectDepositInfo",
                        String.class);

                method.invoke(_vendrRemoteModel, directDepositInfo);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getPaymentMethod() {
        return _paymentMethod;
    }

    @Override
    public void setPaymentMethod(String paymentMethod) {
        _paymentMethod = paymentMethod;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setPaymentMethod", String.class);

                method.invoke(_vendrRemoteModel, paymentMethod);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCrypto1() {
        return _crypto1;
    }

    @Override
    public void setCrypto1(String crypto1) {
        _crypto1 = crypto1;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setCrypto1", String.class);

                method.invoke(_vendrRemoteModel, crypto1);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;

        if (_vendrRemoteModel != null) {
            try {
                Class<?> clazz = _vendrRemoteModel.getClass();

                Method method = clazz.getMethod("setGroupId", long.class);

                method.invoke(_vendrRemoteModel, groupId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getVendrRemoteModel() {
        return _vendrRemoteModel;
    }

    public void setVendrRemoteModel(BaseModel<?> vendrRemoteModel) {
        _vendrRemoteModel = vendrRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _vendrRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_vendrRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            VendrLocalServiceUtil.addVendr(this);
        } else {
            VendrLocalServiceUtil.updateVendr(this);
        }
    }

    @Override
    public Vendr toEscapedModel() {
        return (Vendr) ProxyUtil.newProxyInstance(Vendr.class.getClassLoader(),
            new Class[] { Vendr.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        VendrClp clone = new VendrClp();

        clone.setVendrId(getVendrId());
        clone.setLastName(getLastName());
        clone.setFirstName(getFirstName());
        clone.setMiddleName(getMiddleName());
        clone.setFedTaxId(getFedTaxId());
        clone.setAddress(getAddress());
        clone.setAddress2(getAddress2());
        clone.setCity(getCity());
        clone.setState(getState());
        clone.setZip(getZip());
        clone.setPhone(getPhone());
        clone.setPhone2(getPhone2());
        clone.setGracePeriod(getGracePeriod());
        clone.setGracePeriodDuration(getGracePeriodDuration());
        clone.setDirectDepositInfo(getDirectDepositInfo());
        clone.setPaymentMethod(getPaymentMethod());
        clone.setCrypto1(getCrypto1());
        clone.setGroupId(getGroupId());

        return clone;
    }

    @Override
    public int compareTo(Vendr vendr) {
        long primaryKey = vendr.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof VendrClp)) {
            return false;
        }

        VendrClp vendr = (VendrClp) obj;

        long primaryKey = vendr.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(37);

        sb.append("{vendrId=");
        sb.append(getVendrId());
        sb.append(", lastName=");
        sb.append(getLastName());
        sb.append(", firstName=");
        sb.append(getFirstName());
        sb.append(", middleName=");
        sb.append(getMiddleName());
        sb.append(", fedTaxId=");
        sb.append(getFedTaxId());
        sb.append(", address=");
        sb.append(getAddress());
        sb.append(", address2=");
        sb.append(getAddress2());
        sb.append(", city=");
        sb.append(getCity());
        sb.append(", state=");
        sb.append(getState());
        sb.append(", zip=");
        sb.append(getZip());
        sb.append(", phone=");
        sb.append(getPhone());
        sb.append(", phone2=");
        sb.append(getPhone2());
        sb.append(", gracePeriod=");
        sb.append(getGracePeriod());
        sb.append(", gracePeriodDuration=");
        sb.append(getGracePeriodDuration());
        sb.append(", directDepositInfo=");
        sb.append(getDirectDepositInfo());
        sb.append(", paymentMethod=");
        sb.append(getPaymentMethod());
        sb.append(", crypto1=");
        sb.append(getCrypto1());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(58);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Vendr");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>vendrId</column-name><column-value><![CDATA[");
        sb.append(getVendrId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>lastName</column-name><column-value><![CDATA[");
        sb.append(getLastName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>firstName</column-name><column-value><![CDATA[");
        sb.append(getFirstName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>middleName</column-name><column-value><![CDATA[");
        sb.append(getMiddleName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>fedTaxId</column-name><column-value><![CDATA[");
        sb.append(getFedTaxId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>address</column-name><column-value><![CDATA[");
        sb.append(getAddress());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>address2</column-name><column-value><![CDATA[");
        sb.append(getAddress2());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>city</column-name><column-value><![CDATA[");
        sb.append(getCity());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>state</column-name><column-value><![CDATA[");
        sb.append(getState());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>zip</column-name><column-value><![CDATA[");
        sb.append(getZip());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>phone</column-name><column-value><![CDATA[");
        sb.append(getPhone());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>phone2</column-name><column-value><![CDATA[");
        sb.append(getPhone2());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>gracePeriod</column-name><column-value><![CDATA[");
        sb.append(getGracePeriod());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>gracePeriodDuration</column-name><column-value><![CDATA[");
        sb.append(getGracePeriodDuration());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>directDepositInfo</column-name><column-value><![CDATA[");
        sb.append(getDirectDepositInfo());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>paymentMethod</column-name><column-value><![CDATA[");
        sb.append(getPaymentMethod());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>crypto1</column-name><column-value><![CDATA[");
        sb.append(getCrypto1());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
