package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link StiPt}.
 * </p>
 *
 * @author caret
 * @see StiPt
 * @generated
 */
public class StiPtWrapper implements StiPt, ModelWrapper<StiPt> {
    private StiPt _stiPt;

    public StiPtWrapper(StiPt stiPt) {
        _stiPt = stiPt;
    }

    @Override
    public Class<?> getModelClass() {
        return StiPt.class;
    }

    @Override
    public String getModelClassName() {
        return StiPt.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("stiPtId", getStiPtId());
        attributes.put("stiRdId", getStiRdId());
        attributes.put("vendrId", getVendrId());
        attributes.put("tier", getTier());
        attributes.put("tierHours", getTierHours());
        attributes.put("blsRateHourly", getBlsRateHourly());
        attributes.put("dailyRate", getDailyRate());
        attributes.put("monthlyPayment", getMonthlyPayment());
        attributes.put("stipendStatus", getStipendStatus());
        attributes.put("stipendApprovedDate", getStipendApprovedDate());
        attributes.put("stipendStartDate", getStipendStartDate());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long stiPtId = (Long) attributes.get("stiPtId");

        if (stiPtId != null) {
            setStiPtId(stiPtId);
        }

        Long stiRdId = (Long) attributes.get("stiRdId");

        if (stiRdId != null) {
            setStiRdId(stiRdId);
        }

        Long vendrId = (Long) attributes.get("vendrId");

        if (vendrId != null) {
            setVendrId(vendrId);
        }

        String tier = (String) attributes.get("tier");

        if (tier != null) {
            setTier(tier);
        }

        String tierHours = (String) attributes.get("tierHours");

        if (tierHours != null) {
            setTierHours(tierHours);
        }

        String blsRateHourly = (String) attributes.get("blsRateHourly");

        if (blsRateHourly != null) {
            setBlsRateHourly(blsRateHourly);
        }

        String dailyRate = (String) attributes.get("dailyRate");

        if (dailyRate != null) {
            setDailyRate(dailyRate);
        }

        String monthlyPayment = (String) attributes.get("monthlyPayment");

        if (monthlyPayment != null) {
            setMonthlyPayment(monthlyPayment);
        }

        String stipendStatus = (String) attributes.get("stipendStatus");

        if (stipendStatus != null) {
            setStipendStatus(stipendStatus);
        }

        Date stipendApprovedDate = (Date) attributes.get("stipendApprovedDate");

        if (stipendApprovedDate != null) {
            setStipendApprovedDate(stipendApprovedDate);
        }

        Date stipendStartDate = (Date) attributes.get("stipendStartDate");

        if (stipendStartDate != null) {
            setStipendStartDate(stipendStartDate);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    /**
    * Returns the primary key of this sti pt.
    *
    * @return the primary key of this sti pt
    */
    @Override
    public long getPrimaryKey() {
        return _stiPt.getPrimaryKey();
    }

    /**
    * Sets the primary key of this sti pt.
    *
    * @param primaryKey the primary key of this sti pt
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _stiPt.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the sti pt ID of this sti pt.
    *
    * @return the sti pt ID of this sti pt
    */
    @Override
    public long getStiPtId() {
        return _stiPt.getStiPtId();
    }

    /**
    * Sets the sti pt ID of this sti pt.
    *
    * @param stiPtId the sti pt ID of this sti pt
    */
    @Override
    public void setStiPtId(long stiPtId) {
        _stiPt.setStiPtId(stiPtId);
    }

    /**
    * Returns the sti rd ID of this sti pt.
    *
    * @return the sti rd ID of this sti pt
    */
    @Override
    public long getStiRdId() {
        return _stiPt.getStiRdId();
    }

    /**
    * Sets the sti rd ID of this sti pt.
    *
    * @param stiRdId the sti rd ID of this sti pt
    */
    @Override
    public void setStiRdId(long stiRdId) {
        _stiPt.setStiRdId(stiRdId);
    }

    /**
    * Returns the vendr ID of this sti pt.
    *
    * @return the vendr ID of this sti pt
    */
    @Override
    public long getVendrId() {
        return _stiPt.getVendrId();
    }

    /**
    * Sets the vendr ID of this sti pt.
    *
    * @param vendrId the vendr ID of this sti pt
    */
    @Override
    public void setVendrId(long vendrId) {
        _stiPt.setVendrId(vendrId);
    }

    /**
    * Returns the tier of this sti pt.
    *
    * @return the tier of this sti pt
    */
    @Override
    public java.lang.String getTier() {
        return _stiPt.getTier();
    }

    /**
    * Sets the tier of this sti pt.
    *
    * @param tier the tier of this sti pt
    */
    @Override
    public void setTier(java.lang.String tier) {
        _stiPt.setTier(tier);
    }

    /**
    * Returns the tier hours of this sti pt.
    *
    * @return the tier hours of this sti pt
    */
    @Override
    public java.lang.String getTierHours() {
        return _stiPt.getTierHours();
    }

    /**
    * Sets the tier hours of this sti pt.
    *
    * @param tierHours the tier hours of this sti pt
    */
    @Override
    public void setTierHours(java.lang.String tierHours) {
        _stiPt.setTierHours(tierHours);
    }

    /**
    * Returns the bls rate hourly of this sti pt.
    *
    * @return the bls rate hourly of this sti pt
    */
    @Override
    public java.lang.String getBlsRateHourly() {
        return _stiPt.getBlsRateHourly();
    }

    /**
    * Sets the bls rate hourly of this sti pt.
    *
    * @param blsRateHourly the bls rate hourly of this sti pt
    */
    @Override
    public void setBlsRateHourly(java.lang.String blsRateHourly) {
        _stiPt.setBlsRateHourly(blsRateHourly);
    }

    /**
    * Returns the daily rate of this sti pt.
    *
    * @return the daily rate of this sti pt
    */
    @Override
    public java.lang.String getDailyRate() {
        return _stiPt.getDailyRate();
    }

    /**
    * Sets the daily rate of this sti pt.
    *
    * @param dailyRate the daily rate of this sti pt
    */
    @Override
    public void setDailyRate(java.lang.String dailyRate) {
        _stiPt.setDailyRate(dailyRate);
    }

    /**
    * Returns the monthly payment of this sti pt.
    *
    * @return the monthly payment of this sti pt
    */
    @Override
    public java.lang.String getMonthlyPayment() {
        return _stiPt.getMonthlyPayment();
    }

    /**
    * Sets the monthly payment of this sti pt.
    *
    * @param monthlyPayment the monthly payment of this sti pt
    */
    @Override
    public void setMonthlyPayment(java.lang.String monthlyPayment) {
        _stiPt.setMonthlyPayment(monthlyPayment);
    }

    /**
    * Returns the stipend status of this sti pt.
    *
    * @return the stipend status of this sti pt
    */
    @Override
    public java.lang.String getStipendStatus() {
        return _stiPt.getStipendStatus();
    }

    /**
    * Sets the stipend status of this sti pt.
    *
    * @param stipendStatus the stipend status of this sti pt
    */
    @Override
    public void setStipendStatus(java.lang.String stipendStatus) {
        _stiPt.setStipendStatus(stipendStatus);
    }

    /**
    * Returns the stipend approved date of this sti pt.
    *
    * @return the stipend approved date of this sti pt
    */
    @Override
    public java.util.Date getStipendApprovedDate() {
        return _stiPt.getStipendApprovedDate();
    }

    /**
    * Sets the stipend approved date of this sti pt.
    *
    * @param stipendApprovedDate the stipend approved date of this sti pt
    */
    @Override
    public void setStipendApprovedDate(java.util.Date stipendApprovedDate) {
        _stiPt.setStipendApprovedDate(stipendApprovedDate);
    }

    /**
    * Returns the stipend start date of this sti pt.
    *
    * @return the stipend start date of this sti pt
    */
    @Override
    public java.util.Date getStipendStartDate() {
        return _stiPt.getStipendStartDate();
    }

    /**
    * Sets the stipend start date of this sti pt.
    *
    * @param stipendStartDate the stipend start date of this sti pt
    */
    @Override
    public void setStipendStartDate(java.util.Date stipendStartDate) {
        _stiPt.setStipendStartDate(stipendStartDate);
    }

    /**
    * Returns the group ID of this sti pt.
    *
    * @return the group ID of this sti pt
    */
    @Override
    public long getGroupId() {
        return _stiPt.getGroupId();
    }

    /**
    * Sets the group ID of this sti pt.
    *
    * @param groupId the group ID of this sti pt
    */
    @Override
    public void setGroupId(long groupId) {
        _stiPt.setGroupId(groupId);
    }

    @Override
    public boolean isNew() {
        return _stiPt.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _stiPt.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _stiPt.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _stiPt.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _stiPt.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _stiPt.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _stiPt.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _stiPt.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _stiPt.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _stiPt.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _stiPt.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new StiPtWrapper((StiPt) _stiPt.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.StiPt stiPt) {
        return _stiPt.compareTo(stiPt);
    }

    @Override
    public int hashCode() {
        return _stiPt.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.StiPt> toCacheModel() {
        return _stiPt.toCacheModel();
    }

    @Override
    public gov.va.caret.model.StiPt toEscapedModel() {
        return new StiPtWrapper(_stiPt.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.StiPt toUnescapedModel() {
        return new StiPtWrapper(_stiPt.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _stiPt.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _stiPt.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _stiPt.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof StiPtWrapper)) {
            return false;
        }

        StiPtWrapper stiPtWrapper = (StiPtWrapper) obj;

        if (Validator.equals(_stiPt, stiPtWrapper._stiPt)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public StiPt getWrappedStiPt() {
        return _stiPt;
    }

    @Override
    public StiPt getWrappedModel() {
        return _stiPt;
    }

    @Override
    public void resetOriginalValues() {
        _stiPt.resetOriginalValues();
    }
}
