package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class StiPtSoap implements Serializable {
    private long _stiPtId;
    private long _stiRdId;
    private long _vendrId;
    private String _tier;
    private String _tierHours;
    private String _blsRateHourly;
    private String _dailyRate;
    private String _monthlyPayment;
    private String _stipendStatus;
    private Date _stipendApprovedDate;
    private Date _stipendStartDate;
    private long _groupId;

    public StiPtSoap() {
    }

    public static StiPtSoap toSoapModel(StiPt model) {
        StiPtSoap soapModel = new StiPtSoap();

        soapModel.setStiPtId(model.getStiPtId());
        soapModel.setStiRdId(model.getStiRdId());
        soapModel.setVendrId(model.getVendrId());
        soapModel.setTier(model.getTier());
        soapModel.setTierHours(model.getTierHours());
        soapModel.setBlsRateHourly(model.getBlsRateHourly());
        soapModel.setDailyRate(model.getDailyRate());
        soapModel.setMonthlyPayment(model.getMonthlyPayment());
        soapModel.setStipendStatus(model.getStipendStatus());
        soapModel.setStipendApprovedDate(model.getStipendApprovedDate());
        soapModel.setStipendStartDate(model.getStipendStartDate());
        soapModel.setGroupId(model.getGroupId());

        return soapModel;
    }

    public static StiPtSoap[] toSoapModels(StiPt[] models) {
        StiPtSoap[] soapModels = new StiPtSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static StiPtSoap[][] toSoapModels(StiPt[][] models) {
        StiPtSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new StiPtSoap[models.length][models[0].length];
        } else {
            soapModels = new StiPtSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static StiPtSoap[] toSoapModels(List<StiPt> models) {
        List<StiPtSoap> soapModels = new ArrayList<StiPtSoap>(models.size());

        for (StiPt model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new StiPtSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _stiPtId;
    }

    public void setPrimaryKey(long pk) {
        setStiPtId(pk);
    }

    public long getStiPtId() {
        return _stiPtId;
    }

    public void setStiPtId(long stiPtId) {
        _stiPtId = stiPtId;
    }

    public long getStiRdId() {
        return _stiRdId;
    }

    public void setStiRdId(long stiRdId) {
        _stiRdId = stiRdId;
    }

    public long getVendrId() {
        return _vendrId;
    }

    public void setVendrId(long vendrId) {
        _vendrId = vendrId;
    }

    public String getTier() {
        return _tier;
    }

    public void setTier(String tier) {
        _tier = tier;
    }

    public String getTierHours() {
        return _tierHours;
    }

    public void setTierHours(String tierHours) {
        _tierHours = tierHours;
    }

    public String getBlsRateHourly() {
        return _blsRateHourly;
    }

    public void setBlsRateHourly(String blsRateHourly) {
        _blsRateHourly = blsRateHourly;
    }

    public String getDailyRate() {
        return _dailyRate;
    }

    public void setDailyRate(String dailyRate) {
        _dailyRate = dailyRate;
    }

    public String getMonthlyPayment() {
        return _monthlyPayment;
    }

    public void setMonthlyPayment(String monthlyPayment) {
        _monthlyPayment = monthlyPayment;
    }

    public String getStipendStatus() {
        return _stipendStatus;
    }

    public void setStipendStatus(String stipendStatus) {
        _stipendStatus = stipendStatus;
    }

    public Date getStipendApprovedDate() {
        return _stipendApprovedDate;
    }

    public void setStipendApprovedDate(Date stipendApprovedDate) {
        _stipendApprovedDate = stipendApprovedDate;
    }

    public Date getStipendStartDate() {
        return _stipendStartDate;
    }

    public void setStipendStartDate(Date stipendStartDate) {
        _stipendStartDate = stipendStartDate;
    }

    public long getGroupId() {
        return _groupId;
    }

    public void setGroupId(long groupId) {
        _groupId = groupId;
    }
}
