package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the StiPt service. Represents a row in the &quot;CARET_PAYMENT_CONFIG&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.StiPtModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.StiPtImpl}.
 * </p>
 *
 * @author caret
 * @see StiPt
 * @see gov.va.caret.model.impl.StiPtImpl
 * @see gov.va.caret.model.impl.StiPtModelImpl
 * @generated
 */
public interface StiPtModel extends BaseModel<StiPt> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a sti pt model instance should use the {@link StiPt} interface instead.
     */

    /**
     * Returns the primary key of this sti pt.
     *
     * @return the primary key of this sti pt
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this sti pt.
     *
     * @param primaryKey the primary key of this sti pt
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the sti pt ID of this sti pt.
     *
     * @return the sti pt ID of this sti pt
     */
    public long getStiPtId();

    /**
     * Sets the sti pt ID of this sti pt.
     *
     * @param stiPtId the sti pt ID of this sti pt
     */
    public void setStiPtId(long stiPtId);

    /**
     * Returns the sti rd ID of this sti pt.
     *
     * @return the sti rd ID of this sti pt
     */
    public long getStiRdId();

    /**
     * Sets the sti rd ID of this sti pt.
     *
     * @param stiRdId the sti rd ID of this sti pt
     */
    public void setStiRdId(long stiRdId);

    /**
     * Returns the vendr ID of this sti pt.
     *
     * @return the vendr ID of this sti pt
     */
    public long getVendrId();

    /**
     * Sets the vendr ID of this sti pt.
     *
     * @param vendrId the vendr ID of this sti pt
     */
    public void setVendrId(long vendrId);

    /**
     * Returns the tier of this sti pt.
     *
     * @return the tier of this sti pt
     */
    @AutoEscape
    public String getTier();

    /**
     * Sets the tier of this sti pt.
     *
     * @param tier the tier of this sti pt
     */
    public void setTier(String tier);

    /**
     * Returns the tier hours of this sti pt.
     *
     * @return the tier hours of this sti pt
     */
    @AutoEscape
    public String getTierHours();

    /**
     * Sets the tier hours of this sti pt.
     *
     * @param tierHours the tier hours of this sti pt
     */
    public void setTierHours(String tierHours);

    /**
     * Returns the bls rate hourly of this sti pt.
     *
     * @return the bls rate hourly of this sti pt
     */
    @AutoEscape
    public String getBlsRateHourly();

    /**
     * Sets the bls rate hourly of this sti pt.
     *
     * @param blsRateHourly the bls rate hourly of this sti pt
     */
    public void setBlsRateHourly(String blsRateHourly);

    /**
     * Returns the daily rate of this sti pt.
     *
     * @return the daily rate of this sti pt
     */
    @AutoEscape
    public String getDailyRate();

    /**
     * Sets the daily rate of this sti pt.
     *
     * @param dailyRate the daily rate of this sti pt
     */
    public void setDailyRate(String dailyRate);

    /**
     * Returns the monthly payment of this sti pt.
     *
     * @return the monthly payment of this sti pt
     */
    @AutoEscape
    public String getMonthlyPayment();

    /**
     * Sets the monthly payment of this sti pt.
     *
     * @param monthlyPayment the monthly payment of this sti pt
     */
    public void setMonthlyPayment(String monthlyPayment);

    /**
     * Returns the stipend status of this sti pt.
     *
     * @return the stipend status of this sti pt
     */
    @AutoEscape
    public String getStipendStatus();

    /**
     * Sets the stipend status of this sti pt.
     *
     * @param stipendStatus the stipend status of this sti pt
     */
    public void setStipendStatus(String stipendStatus);

    /**
     * Returns the stipend approved date of this sti pt.
     *
     * @return the stipend approved date of this sti pt
     */
    public Date getStipendApprovedDate();

    /**
     * Sets the stipend approved date of this sti pt.
     *
     * @param stipendApprovedDate the stipend approved date of this sti pt
     */
    public void setStipendApprovedDate(Date stipendApprovedDate);

    /**
     * Returns the stipend start date of this sti pt.
     *
     * @return the stipend start date of this sti pt
     */
    public Date getStipendStartDate();

    /**
     * Sets the stipend start date of this sti pt.
     *
     * @param stipendStartDate the stipend start date of this sti pt
     */
    public void setStipendStartDate(Date stipendStartDate);

    /**
     * Returns the group ID of this sti pt.
     *
     * @return the group ID of this sti pt
     */
    public long getGroupId();

    /**
     * Sets the group ID of this sti pt.
     *
     * @param groupId the group ID of this sti pt
     */
    public void setGroupId(long groupId);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.StiPt stiPt);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.StiPt> toCacheModel();

    @Override
    public gov.va.caret.model.StiPt toEscapedModel();

    @Override
    public gov.va.caret.model.StiPt toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
