package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the Persn service. Represents a row in the &quot;CARET_PERSON&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.PersnModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.PersnImpl}.
 * </p>
 *
 * @author caret
 * @see Persn
 * @see gov.va.caret.model.impl.PersnImpl
 * @see gov.va.caret.model.impl.PersnModelImpl
 * @generated
 */
public interface PersnModel extends BaseModel<Persn> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a persn model instance should use the {@link Persn} interface instead.
     */

    /**
     * Returns the primary key of this persn.
     *
     * @return the primary key of this persn
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this persn.
     *
     * @param primaryKey the primary key of this persn
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the persn ID of this persn.
     *
     * @return the persn ID of this persn
     */
    public long getPersnId();

    /**
     * Sets the persn ID of this persn.
     *
     * @param persnId the persn ID of this persn
     */
    public void setPersnId(long persnId);

    /**
     * Returns the persn user ID of this persn.
     *
     * @return the persn user ID of this persn
     */
    public long getPersnUserId();

    /**
     * Sets the persn user ID of this persn.
     *
     * @param persnUserId the persn user ID of this persn
     */
    public void setPersnUserId(long persnUserId);

    /**
     * Returns the persn user uuid of this persn.
     *
     * @return the persn user uuid of this persn
     * @throws SystemException if a system exception occurred
     */
    public String getPersnUserUuid() throws SystemException;

    /**
     * Sets the persn user uuid of this persn.
     *
     * @param persnUserUuid the persn user uuid of this persn
     */
    public void setPersnUserUuid(String persnUserUuid);

    /**
     * Returns the last name of this persn.
     *
     * @return the last name of this persn
     */
    @AutoEscape
    public String getLastName();

    /**
     * Sets the last name of this persn.
     *
     * @param lastName the last name of this persn
     */
    public void setLastName(String lastName);

    /**
     * Returns the first name of this persn.
     *
     * @return the first name of this persn
     */
    @AutoEscape
    public String getFirstName();

    /**
     * Sets the first name of this persn.
     *
     * @param firstName the first name of this persn
     */
    public void setFirstName(String firstName);

    /**
     * Returns the middle name of this persn.
     *
     * @return the middle name of this persn
     */
    @AutoEscape
    public String getMiddleName();

    /**
     * Sets the middle name of this persn.
     *
     * @param middleName the middle name of this persn
     */
    public void setMiddleName(String middleName);

    /**
     * Returns the prefix of this persn.
     *
     * @return the prefix of this persn
     */
    @AutoEscape
    public String getPrefix();

    /**
     * Sets the prefix of this persn.
     *
     * @param prefix the prefix of this persn
     */
    public void setPrefix(String prefix);

    /**
     * Returns the suffix of this persn.
     *
     * @return the suffix of this persn
     */
    @AutoEscape
    public String getSuffix();

    /**
     * Sets the suffix of this persn.
     *
     * @param suffix the suffix of this persn
     */
    public void setSuffix(String suffix);

    /**
     * Returns the birth date of this persn.
     *
     * @return the birth date of this persn
     */
    public Date getBirthDate();

    /**
     * Sets the birth date of this persn.
     *
     * @param birthDate the birth date of this persn
     */
    public void setBirthDate(Date birthDate);

    /**
     * Returns the deceased date of this persn.
     *
     * @return the deceased date of this persn
     */
    public Date getDeceasedDate();

    /**
     * Sets the deceased date of this persn.
     *
     * @param deceasedDate the deceased date of this persn
     */
    public void setDeceasedDate(Date deceasedDate);

    /**
     * Returns the gender of this persn.
     *
     * @return the gender of this persn
     */
    @AutoEscape
    public String getGender();

    /**
     * Sets the gender of this persn.
     *
     * @param gender the gender of this persn
     */
    public void setGender(String gender);

    /**
     * Returns the address of this persn.
     *
     * @return the address of this persn
     */
    @AutoEscape
    public String getAddress();

    /**
     * Sets the address of this persn.
     *
     * @param address the address of this persn
     */
    public void setAddress(String address);

    /**
     * Returns the address2 of this persn.
     *
     * @return the address2 of this persn
     */
    @AutoEscape
    public String getAddress2();

    /**
     * Sets the address2 of this persn.
     *
     * @param address2 the address2 of this persn
     */
    public void setAddress2(String address2);

    /**
     * Returns the city of this persn.
     *
     * @return the city of this persn
     */
    @AutoEscape
    public String getCity();

    /**
     * Sets the city of this persn.
     *
     * @param city the city of this persn
     */
    public void setCity(String city);

    /**
     * Returns the state of this persn.
     *
     * @return the state of this persn
     */
    @AutoEscape
    public String getState();

    /**
     * Sets the state of this persn.
     *
     * @param state the state of this persn
     */
    public void setState(String state);

    /**
     * Returns the country of this persn.
     *
     * @return the country of this persn
     */
    @AutoEscape
    public String getCountry();

    /**
     * Sets the country of this persn.
     *
     * @param country the country of this persn
     */
    public void setCountry(String country);

    /**
     * Returns the zip of this persn.
     *
     * @return the zip of this persn
     */
    @AutoEscape
    public String getZip();

    /**
     * Sets the zip of this persn.
     *
     * @param zip the zip of this persn
     */
    public void setZip(String zip);

    /**
     * Returns the phone of this persn.
     *
     * @return the phone of this persn
     */
    @AutoEscape
    public String getPhone();

    /**
     * Sets the phone of this persn.
     *
     * @param phone the phone of this persn
     */
    public void setPhone(String phone);

    /**
     * Returns the phone2 of this persn.
     *
     * @return the phone2 of this persn
     */
    @AutoEscape
    public String getPhone2();

    /**
     * Sets the phone2 of this persn.
     *
     * @param phone2 the phone2 of this persn
     */
    public void setPhone2(String phone2);

    /**
     * Returns the email of this persn.
     *
     * @return the email of this persn
     */
    @AutoEscape
    public String getEmail();

    /**
     * Sets the email of this persn.
     *
     * @param email the email of this persn
     */
    public void setEmail(String email);

    /**
     * Returns the email2 of this persn.
     *
     * @return the email2 of this persn
     */
    @AutoEscape
    public String getEmail2();

    /**
     * Sets the email2 of this persn.
     *
     * @param email2 the email2 of this persn
     */
    public void setEmail2(String email2);

    /**
     * Returns the status of this persn.
     *
     * @return the status of this persn
     */
    @AutoEscape
    public String getStatus();

    /**
     * Sets the status of this persn.
     *
     * @param status the status of this persn
     */
    public void setStatus(String status);

    /**
     * Returns the source of this persn.
     *
     * @return the source of this persn
     */
    @AutoEscape
    public String getSource();

    /**
     * Sets the source of this persn.
     *
     * @param source the source of this persn
     */
    public void setSource(String source);

    /**
     * Returns the external ID of this persn.
     *
     * @return the external ID of this persn
     */
    @AutoEscape
    public String getExternalId();

    /**
     * Sets the external ID of this persn.
     *
     * @param externalId the external ID of this persn
     */
    public void setExternalId(String externalId);

    /**
     * Returns the other health insurance of this persn.
     *
     * @return the other health insurance of this persn
     */
    @AutoEscape
    public String getOtherHealthInsurance();

    /**
     * Sets the other health insurance of this persn.
     *
     * @param otherHealthInsurance the other health insurance of this persn
     */
    public void setOtherHealthInsurance(String otherHealthInsurance);

    /**
     * Returns the user ID of this persn.
     *
     * @return the user ID of this persn
     */
    public long getUserId();

    /**
     * Sets the user ID of this persn.
     *
     * @param userId the user ID of this persn
     */
    public void setUserId(long userId);

    /**
     * Returns the user uuid of this persn.
     *
     * @return the user uuid of this persn
     * @throws SystemException if a system exception occurred
     */
    public String getUserUuid() throws SystemException;

    /**
     * Sets the user uuid of this persn.
     *
     * @param userUuid the user uuid of this persn
     */
    public void setUserUuid(String userUuid);

    /**
     * Returns the group ID of this persn.
     *
     * @return the group ID of this persn
     */
    public long getGroupId();

    /**
     * Sets the group ID of this persn.
     *
     * @param groupId the group ID of this persn
     */
    public void setGroupId(long groupId);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.Persn persn);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.Persn> toCacheModel();

    @Override
    public gov.va.caret.model.Persn toEscapedModel();

    @Override
    public gov.va.caret.model.Persn toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
