package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class NoteSoap implements Serializable {
    private String _uuid;
    private long _noteId;
    private String _value;
    private long _userId;
    private Date _creationDate;
    private long _groupId;
    private long _chainId;

    public NoteSoap() {
    }

    public static NoteSoap toSoapModel(Note model) {
        NoteSoap soapModel = new NoteSoap();

        soapModel.setUuid(model.getUuid());
        soapModel.setNoteId(model.getNoteId());
        soapModel.setValue(model.getValue());
        soapModel.setUserId(model.getUserId());
        soapModel.setCreationDate(model.getCreationDate());
        soapModel.setGroupId(model.getGroupId());
        soapModel.setChainId(model.getChainId());

        return soapModel;
    }

    public static NoteSoap[] toSoapModels(Note[] models) {
        NoteSoap[] soapModels = new NoteSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static NoteSoap[][] toSoapModels(Note[][] models) {
        NoteSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new NoteSoap[models.length][models[0].length];
        } else {
            soapModels = new NoteSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static NoteSoap[] toSoapModels(List<Note> models) {
        List<NoteSoap> soapModels = new ArrayList<NoteSoap>(models.size());

        for (Note model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new NoteSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _noteId;
    }

    public void setPrimaryKey(long pk) {
        setNoteId(pk);
    }

    public String getUuid() {
        return _uuid;
    }

    public void setUuid(String uuid) {
        _uuid = uuid;
    }

    public long getNoteId() {
        return _noteId;
    }

    public void setNoteId(long noteId) {
        _noteId = noteId;
    }

    public String getValue() {
        return _value;
    }

    public void setValue(String value) {
        _value = value;
    }

    public long getUserId() {
        return _userId;
    }

    public void setUserId(long userId) {
        _userId = userId;
    }

    public Date getCreationDate() {
        return _creationDate;
    }

    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    public long getGroupId() {
        return _groupId;
    }

    public void setGroupId(long groupId) {
        _groupId = groupId;
    }

    public long getChainId() {
        return _chainId;
    }

    public void setChainId(long chainId) {
        _chainId = chainId;
    }
}
