package gov.va.caret.model;

import java.io.Serializable;

import java.sql.Blob;

import java.util.ArrayList;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class DocumSoap implements Serializable {
    private long _documId;
    private Blob _document;
    private long _classId;
    private long _classPk;
    private String _name;
    private String _type;

    public DocumSoap() {
    }

    public static DocumSoap toSoapModel(Docum model) {
        DocumSoap soapModel = new DocumSoap();

        soapModel.setDocumId(model.getDocumId());
        soapModel.setDocument(model.getDocument());
        soapModel.setClassId(model.getClassId());
        soapModel.setClassPk(model.getClassPk());
        soapModel.setName(model.getName());
        soapModel.setType(model.getType());

        return soapModel;
    }

    public static DocumSoap[] toSoapModels(Docum[] models) {
        DocumSoap[] soapModels = new DocumSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static DocumSoap[][] toSoapModels(Docum[][] models) {
        DocumSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new DocumSoap[models.length][models[0].length];
        } else {
            soapModels = new DocumSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static DocumSoap[] toSoapModels(List<Docum> models) {
        List<DocumSoap> soapModels = new ArrayList<DocumSoap>(models.size());

        for (Docum model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new DocumSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _documId;
    }

    public void setPrimaryKey(long pk) {
        setDocumId(pk);
    }

    public long getDocumId() {
        return _documId;
    }

    public void setDocumId(long documId) {
        _documId = documId;
    }

    public Blob getDocument() {
        return _document;
    }

    public void setDocument(Blob document) {
        _document = document;
    }

    public long getClassId() {
        return _classId;
    }

    public void setClassId(long classId) {
        _classId = classId;
    }

    public long getClassPk() {
        return _classPk;
    }

    public void setClassPk(long classPk) {
        _classPk = classPk;
    }

    public String getName() {
        return _name;
    }

    public void setName(String name) {
        _name = name;
    }

    public String getType() {
        return _type;
    }

    public void setType(String type) {
        _type = type;
    }
}
