package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.sql.Blob;

/**
 * The base model interface for the Docum service. Represents a row in the &quot;CARET_DOCUMENT&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.DocumModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.DocumImpl}.
 * </p>
 *
 * @author caret
 * @see Docum
 * @see gov.va.caret.model.impl.DocumImpl
 * @see gov.va.caret.model.impl.DocumModelImpl
 * @generated
 */
public interface DocumModel extends BaseModel<Docum> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a docum model instance should use the {@link Docum} interface instead.
     */

    /**
     * Returns the primary key of this docum.
     *
     * @return the primary key of this docum
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this docum.
     *
     * @param primaryKey the primary key of this docum
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the docum ID of this docum.
     *
     * @return the docum ID of this docum
     */
    public long getDocumId();

    /**
     * Sets the docum ID of this docum.
     *
     * @param documId the docum ID of this docum
     */
    public void setDocumId(long documId);

    /**
     * Returns the document of this docum.
     *
     * @return the document of this docum
     */
    public Blob getDocument();

    /**
     * Sets the document of this docum.
     *
     * @param document the document of this docum
     */
    public void setDocument(Blob document);

    /**
     * Returns the class ID of this docum.
     *
     * @return the class ID of this docum
     */
    public long getClassId();

    /**
     * Sets the class ID of this docum.
     *
     * @param classId the class ID of this docum
     */
    public void setClassId(long classId);

    /**
     * Returns the class pk of this docum.
     *
     * @return the class pk of this docum
     */
    public long getClassPk();

    /**
     * Sets the class pk of this docum.
     *
     * @param classPk the class pk of this docum
     */
    public void setClassPk(long classPk);

    /**
     * Returns the name of this docum.
     *
     * @return the name of this docum
     */
    @AutoEscape
    public String getName();

    /**
     * Sets the name of this docum.
     *
     * @param name the name of this docum
     */
    public void setName(String name);

    /**
     * Returns the type of this docum.
     *
     * @return the type of this docum
     */
    @AutoEscape
    public String getType();

    /**
     * Sets the type of this docum.
     *
     * @param type the type of this docum
     */
    public void setType(String type);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.Docum docum);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.Docum> toCacheModel();

    @Override
    public gov.va.caret.model.Docum toEscapedModel();

    @Override
    public gov.va.caret.model.Docum toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
