package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.DocumLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.sql.Blob;

import java.util.HashMap;
import java.util.Map;


public class DocumClp extends BaseModelImpl<Docum> implements Docum {
    private long _documId;
    private Blob _document;
    private long _classId;
    private long _classPk;
    private String _name;
    private String _type;
    private BaseModel<?> _documRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public DocumClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return Docum.class;
    }

    @Override
    public String getModelClassName() {
        return Docum.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _documId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setDocumId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _documId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("documId", getDocumId());
        attributes.put("document", getDocument());
        attributes.put("classId", getClassId());
        attributes.put("classPk", getClassPk());
        attributes.put("name", getName());
        attributes.put("type", getType());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long documId = (Long) attributes.get("documId");

        if (documId != null) {
            setDocumId(documId);
        }

        Blob document = (Blob) attributes.get("document");

        if (document != null) {
            setDocument(document);
        }

        Long classId = (Long) attributes.get("classId");

        if (classId != null) {
            setClassId(classId);
        }

        Long classPk = (Long) attributes.get("classPk");

        if (classPk != null) {
            setClassPk(classPk);
        }

        String name = (String) attributes.get("name");

        if (name != null) {
            setName(name);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }
    }

    @Override
    public long getDocumId() {
        return _documId;
    }

    @Override
    public void setDocumId(long documId) {
        _documId = documId;

        if (_documRemoteModel != null) {
            try {
                Class<?> clazz = _documRemoteModel.getClass();

                Method method = clazz.getMethod("setDocumId", long.class);

                method.invoke(_documRemoteModel, documId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Blob getDocument() {
        return _document;
    }

    @Override
    public void setDocument(Blob document) {
        _document = document;

        if (_documRemoteModel != null) {
            try {
                Class<?> clazz = _documRemoteModel.getClass();

                Method method = clazz.getMethod("setDocument", Blob.class);

                method.invoke(_documRemoteModel, document);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getClassId() {
        return _classId;
    }

    @Override
    public void setClassId(long classId) {
        _classId = classId;

        if (_documRemoteModel != null) {
            try {
                Class<?> clazz = _documRemoteModel.getClass();

                Method method = clazz.getMethod("setClassId", long.class);

                method.invoke(_documRemoteModel, classId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getClassPk() {
        return _classPk;
    }

    @Override
    public void setClassPk(long classPk) {
        _classPk = classPk;

        if (_documRemoteModel != null) {
            try {
                Class<?> clazz = _documRemoteModel.getClass();

                Method method = clazz.getMethod("setClassPk", long.class);

                method.invoke(_documRemoteModel, classPk);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getName() {
        return _name;
    }

    @Override
    public void setName(String name) {
        _name = name;

        if (_documRemoteModel != null) {
            try {
                Class<?> clazz = _documRemoteModel.getClass();

                Method method = clazz.getMethod("setName", String.class);

                method.invoke(_documRemoteModel, name);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getType() {
        return _type;
    }

    @Override
    public void setType(String type) {
        _type = type;

        if (_documRemoteModel != null) {
            try {
                Class<?> clazz = _documRemoteModel.getClass();

                Method method = clazz.getMethod("setType", String.class);

                method.invoke(_documRemoteModel, type);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getDocumRemoteModel() {
        return _documRemoteModel;
    }

    public void setDocumRemoteModel(BaseModel<?> documRemoteModel) {
        _documRemoteModel = documRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _documRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_documRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            DocumLocalServiceUtil.addDocum(this);
        } else {
            DocumLocalServiceUtil.updateDocum(this);
        }
    }

    @Override
    public Docum toEscapedModel() {
        return (Docum) ProxyUtil.newProxyInstance(Docum.class.getClassLoader(),
            new Class[] { Docum.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        DocumClp clone = new DocumClp();

        clone.setDocumId(getDocumId());
        clone.setDocument(getDocument());
        clone.setClassId(getClassId());
        clone.setClassPk(getClassPk());
        clone.setName(getName());
        clone.setType(getType());

        return clone;
    }

    @Override
    public int compareTo(Docum docum) {
        long primaryKey = docum.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof DocumClp)) {
            return false;
        }

        DocumClp docum = (DocumClp) obj;

        long primaryKey = docum.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(13);

        sb.append("{documId=");
        sb.append(getDocumId());
        sb.append(", document=");
        sb.append(getDocument());
        sb.append(", classId=");
        sb.append(getClassId());
        sb.append(", classPk=");
        sb.append(getClassPk());
        sb.append(", name=");
        sb.append(getName());
        sb.append(", type=");
        sb.append(getType());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(22);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Docum");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>documId</column-name><column-value><![CDATA[");
        sb.append(getDocumId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>document</column-name><column-value><![CDATA[");
        sb.append(getDocument());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>classId</column-name><column-value><![CDATA[");
        sb.append(getClassId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>classPk</column-name><column-value><![CDATA[");
        sb.append(getClassPk());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>name</column-name><column-value><![CDATA[");
        sb.append(getName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>type</column-name><column-value><![CDATA[");
        sb.append(getType());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
