package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link Crypto}.
 * </p>
 *
 * @author caret
 * @see Crypto
 * @generated
 */
public class CryptoWrapper implements Crypto, ModelWrapper<Crypto> {
    private Crypto _crypto;

    public CryptoWrapper(Crypto crypto) {
        _crypto = crypto;
    }

    @Override
    public Class<?> getModelClass() {
        return Crypto.class;
    }

    @Override
    public String getModelClassName() {
        return Crypto.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("cryptoId", getCryptoId());
        attributes.put("ownerId", getOwnerId());
        attributes.put("type", getType());
        attributes.put("value", getValue());
        attributes.put("hcode", getHcode());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long cryptoId = (Long) attributes.get("cryptoId");

        if (cryptoId != null) {
            setCryptoId(cryptoId);
        }

        Long ownerId = (Long) attributes.get("ownerId");

        if (ownerId != null) {
            setOwnerId(ownerId);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }

        String value = (String) attributes.get("value");

        if (value != null) {
            setValue(value);
        }

        Integer hcode = (Integer) attributes.get("hcode");

        if (hcode != null) {
            setHcode(hcode);
        }
    }

    /**
    * Returns the primary key of this crypto.
    *
    * @return the primary key of this crypto
    */
    @Override
    public long getPrimaryKey() {
        return _crypto.getPrimaryKey();
    }

    /**
    * Sets the primary key of this crypto.
    *
    * @param primaryKey the primary key of this crypto
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _crypto.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the crypto ID of this crypto.
    *
    * @return the crypto ID of this crypto
    */
    @Override
    public long getCryptoId() {
        return _crypto.getCryptoId();
    }

    /**
    * Sets the crypto ID of this crypto.
    *
    * @param cryptoId the crypto ID of this crypto
    */
    @Override
    public void setCryptoId(long cryptoId) {
        _crypto.setCryptoId(cryptoId);
    }

    /**
    * Returns the owner ID of this crypto.
    *
    * @return the owner ID of this crypto
    */
    @Override
    public long getOwnerId() {
        return _crypto.getOwnerId();
    }

    /**
    * Sets the owner ID of this crypto.
    *
    * @param ownerId the owner ID of this crypto
    */
    @Override
    public void setOwnerId(long ownerId) {
        _crypto.setOwnerId(ownerId);
    }

    /**
    * Returns the type of this crypto.
    *
    * @return the type of this crypto
    */
    @Override
    public java.lang.String getType() {
        return _crypto.getType();
    }

    /**
    * Sets the type of this crypto.
    *
    * @param type the type of this crypto
    */
    @Override
    public void setType(java.lang.String type) {
        _crypto.setType(type);
    }

    /**
    * Returns the value of this crypto.
    *
    * @return the value of this crypto
    */
    @Override
    public java.lang.String getValue() {
        return _crypto.getValue();
    }

    /**
    * Sets the value of this crypto.
    *
    * @param value the value of this crypto
    */
    @Override
    public void setValue(java.lang.String value) {
        _crypto.setValue(value);
    }

    /**
    * Returns the hcode of this crypto.
    *
    * @return the hcode of this crypto
    */
    @Override
    public int getHcode() {
        return _crypto.getHcode();
    }

    /**
    * Sets the hcode of this crypto.
    *
    * @param hcode the hcode of this crypto
    */
    @Override
    public void setHcode(int hcode) {
        _crypto.setHcode(hcode);
    }

    @Override
    public boolean isNew() {
        return _crypto.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _crypto.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _crypto.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _crypto.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _crypto.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _crypto.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _crypto.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _crypto.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _crypto.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _crypto.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _crypto.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new CryptoWrapper((Crypto) _crypto.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.Crypto crypto) {
        return _crypto.compareTo(crypto);
    }

    @Override
    public int hashCode() {
        return _crypto.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.Crypto> toCacheModel() {
        return _crypto.toCacheModel();
    }

    @Override
    public gov.va.caret.model.Crypto toEscapedModel() {
        return new CryptoWrapper(_crypto.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.Crypto toUnescapedModel() {
        return new CryptoWrapper(_crypto.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _crypto.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _crypto.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _crypto.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof CryptoWrapper)) {
            return false;
        }

        CryptoWrapper cryptoWrapper = (CryptoWrapper) obj;

        if (Validator.equals(_crypto, cryptoWrapper._crypto)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public Crypto getWrappedCrypto() {
        return _crypto;
    }

    @Override
    public Crypto getWrappedModel() {
        return _crypto;
    }

    @Override
    public void resetOriginalValues() {
        _crypto.resetOriginalValues();
    }
}
