package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the ClSoc service. Represents a row in the &quot;CARET_SOC&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.ClSocModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.ClSocImpl}.
 * </p>
 *
 * @author caret
 * @see ClSoc
 * @see gov.va.caret.model.impl.ClSocImpl
 * @see gov.va.caret.model.impl.ClSocModelImpl
 * @generated
 */
public interface ClSocModel extends BaseModel<ClSoc> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a cl soc model instance should use the {@link ClSoc} interface instead.
     */

    /**
     * Returns the primary key of this cl soc.
     *
     * @return the primary key of this cl soc
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this cl soc.
     *
     * @param primaryKey the primary key of this cl soc
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the cl soc ID of this cl soc.
     *
     * @return the cl soc ID of this cl soc
     */
    public long getClSocId();

    /**
     * Sets the cl soc ID of this cl soc.
     *
     * @param clSocId the cl soc ID of this cl soc
     */
    public void setClSocId(long clSocId);

    /**
     * Returns the call ID of this cl soc.
     *
     * @return the call ID of this cl soc
     */
    public long getCallId();

    /**
     * Sets the call ID of this cl soc.
     *
     * @param callId the call ID of this cl soc
     */
    public void setCallId(long callId);

    /**
     * Returns the persn ID of this cl soc.
     *
     * @return the persn ID of this cl soc
     */
    public long getPersnId();

    /**
     * Sets the persn ID of this cl soc.
     *
     * @param persnId the persn ID of this cl soc
     */
    public void setPersnId(long persnId);

    /**
     * Returns the survey status of this cl soc.
     *
     * @return the survey status of this cl soc
     */
    @AutoEscape
    public String getSurveyStatus();

    /**
     * Sets the survey status of this cl soc.
     *
     * @param surveyStatus the survey status of this cl soc
     */
    public void setSurveyStatus(String surveyStatus);

    /**
     * Returns the survey comment of this cl soc.
     *
     * @return the survey comment of this cl soc
     */
    @AutoEscape
    public String getSurveyComment();

    /**
     * Sets the survey comment of this cl soc.
     *
     * @param surveyComment the survey comment of this cl soc
     */
    public void setSurveyComment(String surveyComment);

    /**
     * Returns the creation date of this cl soc.
     *
     * @return the creation date of this cl soc
     */
    public Date getCreationDate();

    /**
     * Sets the creation date of this cl soc.
     *
     * @param creationDate the creation date of this cl soc
     */
    public void setCreationDate(Date creationDate);

    /**
     * Returns the attempt num of this cl soc.
     *
     * @return the attempt num of this cl soc
     */
    @AutoEscape
    public String getAttemptNum();

    /**
     * Sets the attempt num of this cl soc.
     *
     * @param attemptNum the attempt num of this cl soc
     */
    public void setAttemptNum(String attemptNum);

    /**
     * Returns the caller available of this cl soc.
     *
     * @return the caller available of this cl soc
     */
    @AutoEscape
    public String getCallerAvailable();

    /**
     * Sets the caller available of this cl soc.
     *
     * @param callerAvailable the caller available of this cl soc
     */
    public void setCallerAvailable(String callerAvailable);

    /**
     * Returns the requested callback time of this cl soc.
     *
     * @return the requested callback time of this cl soc
     */
    @AutoEscape
    public String getRequestedCallbackTime();

    /**
     * Sets the requested callback time of this cl soc.
     *
     * @param requestedCallbackTime the requested callback time of this cl soc
     */
    public void setRequestedCallbackTime(String requestedCallbackTime);

    /**
     * Returns the willing to ans ques of this cl soc.
     *
     * @return the willing to ans ques of this cl soc
     */
    @AutoEscape
    public String getWillingToAnsQues();

    /**
     * Sets the willing to ans ques of this cl soc.
     *
     * @param willingToAnsQues the willing to ans ques of this cl soc
     */
    public void setWillingToAnsQues(String willingToAnsQues);

    /**
     * Returns the called csl of this cl soc.
     *
     * @return the called csl of this cl soc
     */
    @AutoEscape
    public String getCalledCsl();

    /**
     * Sets the called csl of this cl soc.
     *
     * @param calledCsl the called csl of this cl soc
     */
    public void setCalledCsl(String calledCsl);

    /**
     * Returns the csl knowledgable of this cl soc.
     *
     * @return the csl knowledgable of this cl soc
     */
    @AutoEscape
    public String getCslKnowledgable();

    /**
     * Sets the csl knowledgable of this cl soc.
     *
     * @param cslKnowledgable the csl knowledgable of this cl soc
     */
    public void setCslKnowledgable(String cslKnowledgable);

    /**
     * Returns the csl supportive of this cl soc.
     *
     * @return the csl supportive of this cl soc
     */
    @AutoEscape
    public String getCslSupportive();

    /**
     * Sets the csl supportive of this cl soc.
     *
     * @param cslSupportive the csl supportive of this cl soc
     */
    public void setCslSupportive(String cslSupportive);

    /**
     * Returns the local res suggested of this cl soc.
     *
     * @return the local res suggested of this cl soc
     */
    @AutoEscape
    public String getLocalResSuggested();

    /**
     * Sets the local res suggested of this cl soc.
     *
     * @param localResSuggested the local res suggested of this cl soc
     */
    public void setLocalResSuggested(String localResSuggested);

    /**
     * Returns the local res contacted of this cl soc.
     *
     * @return the local res contacted of this cl soc
     */
    @AutoEscape
    public String getLocalResContacted();

    /**
     * Sets the local res contacted of this cl soc.
     *
     * @param localResContacted the local res contacted of this cl soc
     */
    public void setLocalResContacted(String localResContacted);

    /**
     * Returns the rsn local res not contacted of this cl soc.
     *
     * @return the rsn local res not contacted of this cl soc
     */
    @AutoEscape
    public String getRsnLocalResNotContacted();

    /**
     * Sets the rsn local res not contacted of this cl soc.
     *
     * @param rsnLocalResNotContacted the rsn local res not contacted of this cl soc
     */
    public void setRsnLocalResNotContacted(String rsnLocalResNotContacted);

    /**
     * Returns the local res helpful of this cl soc.
     *
     * @return the local res helpful of this cl soc
     */
    @AutoEscape
    public String getLocalResHelpful();

    /**
     * Sets the local res helpful of this cl soc.
     *
     * @param localResHelpful the local res helpful of this cl soc
     */
    public void setLocalResHelpful(String localResHelpful);

    /**
     * Returns the concerns answered of this cl soc.
     *
     * @return the concerns answered of this cl soc
     */
    @AutoEscape
    public String getConcernsAnswered();

    /**
     * Sets the concerns answered of this cl soc.
     *
     * @param concernsAnswered the concerns answered of this cl soc
     */
    public void setConcernsAnswered(String concernsAnswered);

    /**
     * Returns the understand next steps of this cl soc.
     *
     * @return the understand next steps of this cl soc
     */
    @AutoEscape
    public String getUnderstandNextSteps();

    /**
     * Sets the understand next steps of this cl soc.
     *
     * @param understandNextSteps the understand next steps of this cl soc
     */
    public void setUnderstandNextSteps(String understandNextSteps);

    /**
     * Returns the call csl again of this cl soc.
     *
     * @return the call csl again of this cl soc
     */
    @AutoEscape
    public String getCallCslAgain();

    /**
     * Sets the call csl again of this cl soc.
     *
     * @param callCslAgain the call csl again of this cl soc
     */
    public void setCallCslAgain(String callCslAgain);

    /**
     * Returns the recommend csl of this cl soc.
     *
     * @return the recommend csl of this cl soc
     */
    @AutoEscape
    public String getRecommendCsl();

    /**
     * Sets the recommend csl of this cl soc.
     *
     * @param recommendCsl the recommend csl of this cl soc
     */
    public void setRecommendCsl(String recommendCsl);

    /**
     * Returns the suggestions of this cl soc.
     *
     * @return the suggestions of this cl soc
     */
    @AutoEscape
    public String getSuggestions();

    /**
     * Sets the suggestions of this cl soc.
     *
     * @param suggestions the suggestions of this cl soc
     */
    public void setSuggestions(String suggestions);

    /**
     * Returns the followup call of this cl soc.
     *
     * @return the followup call of this cl soc
     */
    @AutoEscape
    public String getFollowupCall();

    /**
     * Sets the followup call of this cl soc.
     *
     * @param followupCall the followup call of this cl soc
     */
    public void setFollowupCall(String followupCall);

    /**
     * Returns the followup call time of this cl soc.
     *
     * @return the followup call time of this cl soc
     */
    @AutoEscape
    public String getFollowupCallTime();

    /**
     * Sets the followup call time of this cl soc.
     *
     * @param followupCallTime the followup call time of this cl soc
     */
    public void setFollowupCallTime(String followupCallTime);

    /**
     * Returns the treshold met of this cl soc.
     *
     * @return the treshold met of this cl soc
     */
    @AutoEscape
    public String getTresholdMet();

    /**
     * Sets the treshold met of this cl soc.
     *
     * @param tresholdMet the treshold met of this cl soc
     */
    public void setTresholdMet(String tresholdMet);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.ClSoc clSoc);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.ClSoc> toCacheModel();

    @Override
    public gov.va.caret.model.ClSoc toEscapedModel();

    @Override
    public gov.va.caret.model.ClSoc toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
