package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the Cesp service. Represents a row in the &quot;CARET_CESP&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.CespModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.CespImpl}.
 * </p>
 *
 * @author caret
 * @see Cesp
 * @see gov.va.caret.model.impl.CespImpl
 * @see gov.va.caret.model.impl.CespModelImpl
 * @generated
 */
public interface CespModel extends BaseModel<Cesp> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a cesp model instance should use the {@link Cesp} interface instead.
     */

    /**
     * Returns the primary key of this cesp.
     *
     * @return the primary key of this cesp
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this cesp.
     *
     * @param primaryKey the primary key of this cesp
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the cesp ID of this cesp.
     *
     * @return the cesp ID of this cesp
     */
    public long getCespId();

    /**
     * Sets the cesp ID of this cesp.
     *
     * @param cespId the cesp ID of this cesp
     */
    public void setCespId(long cespId);

    /**
     * Returns the call ID of this cesp.
     *
     * @return the call ID of this cesp
     */
    public long getCallId();

    /**
     * Sets the call ID of this cesp.
     *
     * @param callId the call ID of this cesp
     */
    public void setCallId(long callId);

    /**
     * Returns the created by persn ID of this cesp.
     *
     * @return the created by persn ID of this cesp
     */
    public long getCreatedByPersnId();

    /**
     * Sets the created by persn ID of this cesp.
     *
     * @param createdByPersnId the created by persn ID of this cesp
     */
    public void setCreatedByPersnId(long createdByPersnId);

    /**
     * Returns the creation date of this cesp.
     *
     * @return the creation date of this cesp
     */
    public Date getCreationDate();

    /**
     * Sets the creation date of this cesp.
     *
     * @param creationDate the creation date of this cesp
     */
    public void setCreationDate(Date creationDate);

    /**
     * Returns the step of this cesp.
     *
     * @return the step of this cesp
     */
    @AutoEscape
    public String getStep();

    /**
     * Sets the step of this cesp.
     *
     * @param step the step of this cesp
     */
    public void setStep(String step);

    /**
     * Returns the status of this cesp.
     *
     * @return the status of this cesp
     */
    @AutoEscape
    public String getStatus();

    /**
     * Sets the status of this cesp.
     *
     * @param status the status of this cesp
     */
    public void setStatus(String status);

    /**
     * Returns the referred by of this cesp.
     *
     * @return the referred by of this cesp
     */
    @AutoEscape
    public String getReferredBy();

    /**
     * Sets the referred by of this cesp.
     *
     * @param referredBy the referred by of this cesp
     */
    public void setReferredBy(String referredBy);

    /**
     * Returns the assigned csl persn ID of this cesp.
     *
     * @return the assigned csl persn ID of this cesp
     */
    @AutoEscape
    public String getAssignedCslPersnId();

    /**
     * Sets the assigned csl persn ID of this cesp.
     *
     * @param assignedCslPersnId the assigned csl persn ID of this cesp
     */
    public void setAssignedCslPersnId(String assignedCslPersnId);

    /**
     * Returns the goals of this cesp.
     *
     * @return the goals of this cesp
     */
    @AutoEscape
    public String getGoals();

    /**
     * Sets the goals of this cesp.
     *
     * @param goals the goals of this cesp
     */
    public void setGoals(String goals);

    /**
     * Returns the plan progress barrier of this cesp.
     *
     * @return the plan progress barrier of this cesp
     */
    @AutoEscape
    public String getPlanProgressBarrier();

    /**
     * Sets the plan progress barrier of this cesp.
     *
     * @param planProgressBarrier the plan progress barrier of this cesp
     */
    public void setPlanProgressBarrier(String planProgressBarrier);

    /**
     * Returns the cesp closed of this cesp.
     *
     * @return the cesp closed of this cesp
     */
    @AutoEscape
    public String getCespClosed();

    /**
     * Sets the cesp closed of this cesp.
     *
     * @param cespClosed the cesp closed of this cesp
     */
    public void setCespClosed(String cespClosed);

    /**
     * Returns the cesp closed reason of this cesp.
     *
     * @return the cesp closed reason of this cesp
     */
    @AutoEscape
    public String getCespClosedReason();

    /**
     * Sets the cesp closed reason of this cesp.
     *
     * @param cespClosedReason the cesp closed reason of this cesp
     */
    public void setCespClosedReason(String cespClosedReason);

    /**
     * Returns the goals reached of this cesp.
     *
     * @return the goals reached of this cesp
     */
    @AutoEscape
    public String getGoalsReached();

    /**
     * Sets the goals reached of this cesp.
     *
     * @param goalsReached the goals reached of this cesp
     */
    public void setGoalsReached(String goalsReached);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.Cesp cesp);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.Cesp> toCacheModel();

    @Override
    public gov.va.caret.model.Cesp toEscapedModel();

    @Override
    public gov.va.caret.model.Cesp toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
