package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the Call service. Represents a row in the &quot;CARET_CALL&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.CallModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.CallImpl}.
 * </p>
 *
 * @author caret
 * @see Call
 * @see gov.va.caret.model.impl.CallImpl
 * @see gov.va.caret.model.impl.CallModelImpl
 * @generated
 */
public interface CallModel extends BaseModel<Call> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a call model instance should use the {@link Call} interface instead.
     */

    /**
     * Returns the primary key of this call.
     *
     * @return the primary key of this call
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this call.
     *
     * @param primaryKey the primary key of this call
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the call ID of this call.
     *
     * @return the call ID of this call
     */
    public long getCallId();

    /**
     * Sets the call ID of this call.
     *
     * @param callId the call ID of this call
     */
    public void setCallId(long callId);

    /**
     * Returns the call type of this call.
     *
     * @return the call type of this call
     */
    @AutoEscape
    public String getCallType();

    /**
     * Sets the call type of this call.
     *
     * @param callType the call type of this call
     */
    public void setCallType(String callType);

    /**
     * Returns the caller relationship of this call.
     *
     * @return the caller relationship of this call
     */
    @AutoEscape
    public String getCallerRelationship();

    /**
     * Sets the caller relationship of this call.
     *
     * @param callerRelationship the caller relationship of this call
     */
    public void setCallerRelationship(String callerRelationship);

    /**
     * Returns the work primary key of this call.
     *
     * @return the work primary key of this call
     */
    public long getWorkPrimaryKey();

    /**
     * Sets the work primary key of this call.
     *
     * @param workPrimaryKey the work primary key of this call
     */
    public void setWorkPrimaryKey(long workPrimaryKey);

    /**
     * Returns the call state of this call.
     *
     * @return the call state of this call
     */
    @AutoEscape
    public String getCallState();

    /**
     * Sets the call state of this call.
     *
     * @param callState the call state of this call
     */
    public void setCallState(String callState);

    /**
     * Returns the caller persn ID of this call.
     *
     * @return the caller persn ID of this call
     */
    public long getCallerPersnId();

    /**
     * Sets the caller persn ID of this call.
     *
     * @param callerPersnId the caller persn ID of this call
     */
    public void setCallerPersnId(long callerPersnId);

    /**
     * Returns the caller title of this call.
     *
     * @return the caller title of this call
     */
    @AutoEscape
    public String getCallerTitle();

    /**
     * Sets the caller title of this call.
     *
     * @param callerTitle the caller title of this call
     */
    public void setCallerTitle(String callerTitle);

    /**
     * Returns the caller learn about of this call.
     *
     * @return the caller learn about of this call
     */
    @AutoEscape
    public String getCallerLearnAbout();

    /**
     * Sets the caller learn about of this call.
     *
     * @param callerLearnAbout the caller learn about of this call
     */
    public void setCallerLearnAbout(String callerLearnAbout);

    /**
     * Returns the veteran persn ID of this call.
     *
     * @return the veteran persn ID of this call
     */
    public long getVeteranPersnId();

    /**
     * Sets the veteran persn ID of this call.
     *
     * @param veteranPersnId the veteran persn ID of this call
     */
    public void setVeteranPersnId(long veteranPersnId);

    /**
     * Returns the message of this call.
     *
     * @return the message of this call
     */
    @AutoEscape
    public String getMessage();

    /**
     * Sets the message of this call.
     *
     * @param message the message of this call
     */
    public void setMessage(String message);

    /**
     * Returns the summary of this call.
     *
     * @return the summary of this call
     */
    @AutoEscape
    public String getSummary();

    /**
     * Sets the summary of this call.
     *
     * @param summary the summary of this call
     */
    public void setSummary(String summary);

    /**
     * Returns the transfer remarks of this call.
     *
     * @return the transfer remarks of this call
     */
    @AutoEscape
    public String getTransferRemarks();

    /**
     * Sets the transfer remarks of this call.
     *
     * @param transferRemarks the transfer remarks of this call
     */
    public void setTransferRemarks(String transferRemarks);

    /**
     * Returns the cesp goal of this call.
     *
     * @return the cesp goal of this call
     */
    @AutoEscape
    public String getCespGoal();

    /**
     * Sets the cesp goal of this call.
     *
     * @param cespGoal the cesp goal of this call
     */
    public void setCespGoal(String cespGoal);

    /**
     * Returns the cesp outcome of this call.
     *
     * @return the cesp outcome of this call
     */
    @AutoEscape
    public String getCespOutcome();

    /**
     * Sets the cesp outcome of this call.
     *
     * @param cespOutcome the cesp outcome of this call
     */
    public void setCespOutcome(String cespOutcome);

    /**
     * Returns the transferred to of this call.
     *
     * @return the transferred to of this call
     */
    @AutoEscape
    public String getTransferredTo();

    /**
     * Sets the transferred to of this call.
     *
     * @param transferredTo the transferred to of this call
     */
    public void setTransferredTo(String transferredTo);

    /**
     * Returns the other benefits of this call.
     *
     * @return the other benefits of this call
     */
    @AutoEscape
    public String getOtherBenefits();

    /**
     * Sets the other benefits of this call.
     *
     * @param otherBenefits the other benefits of this call
     */
    public void setOtherBenefits(String otherBenefits);

    /**
     * Returns the contact info of this call.
     *
     * @return the contact info of this call
     */
    @AutoEscape
    public String getContactInfo();

    /**
     * Sets the contact info of this call.
     *
     * @param contactInfo the contact info of this call
     */
    public void setContactInfo(String contactInfo);

    /**
     * Returns the era service of this call.
     *
     * @return the era service of this call
     */
    @AutoEscape
    public String getEraService();

    /**
     * Sets the era service of this call.
     *
     * @param eraService the era service of this call
     */
    public void setEraService(String eraService);

    /**
     * Returns the service branch of this call.
     *
     * @return the service branch of this call
     */
    @AutoEscape
    public String getServiceBranch();

    /**
     * Sets the service branch of this call.
     *
     * @param serviceBranch the service branch of this call
     */
    public void setServiceBranch(String serviceBranch);

    /**
     * Returns the service status of this call.
     *
     * @return the service status of this call
     */
    @AutoEscape
    public String getServiceStatus();

    /**
     * Sets the service status of this call.
     *
     * @param serviceStatus the service status of this call
     */
    public void setServiceStatus(String serviceStatus);

    /**
     * Returns the contact info provided of this call.
     *
     * @return the contact info provided of this call
     */
    public boolean getContactInfoProvided();

    /**
     * Returns <code>true</code> if this call is contact info provided.
     *
     * @return <code>true</code> if this call is contact info provided; <code>false</code> otherwise
     */
    public boolean isContactInfoProvided();

    /**
     * Sets whether this call is contact info provided.
     *
     * @param contactInfoProvided the contact info provided of this call
     */
    public void setContactInfoProvided(boolean contactInfoProvided);

    /**
     * Returns the referral agreeable of this call.
     *
     * @return the referral agreeable of this call
     */
    public boolean getReferralAgreeable();

    /**
     * Returns <code>true</code> if this call is referral agreeable.
     *
     * @return <code>true</code> if this call is referral agreeable; <code>false</code> otherwise
     */
    public boolean isReferralAgreeable();

    /**
     * Sets whether this call is referral agreeable.
     *
     * @param referralAgreeable the referral agreeable of this call
     */
    public void setReferralAgreeable(boolean referralAgreeable);

    /**
     * Returns the without contact of this call.
     *
     * @return the without contact of this call
     */
    public boolean getWithoutContact();

    /**
     * Returns <code>true</code> if this call is without contact.
     *
     * @return <code>true</code> if this call is without contact; <code>false</code> otherwise
     */
    public boolean isWithoutContact();

    /**
     * Sets whether this call is without contact.
     *
     * @param withoutContact the without contact of this call
     */
    public void setWithoutContact(boolean withoutContact);

    /**
     * Returns the hang up of this call.
     *
     * @return the hang up of this call
     */
    public boolean getHangUp();

    /**
     * Returns <code>true</code> if this call is hang up.
     *
     * @return <code>true</code> if this call is hang up; <code>false</code> otherwise
     */
    public boolean isHangUp();

    /**
     * Sets whether this call is hang up.
     *
     * @param hangUp the hang up of this call
     */
    public void setHangUp(boolean hangUp);

    /**
     * Returns the wrong number of this call.
     *
     * @return the wrong number of this call
     */
    public boolean getWrongNumber();

    /**
     * Returns <code>true</code> if this call is wrong number.
     *
     * @return <code>true</code> if this call is wrong number; <code>false</code> otherwise
     */
    public boolean isWrongNumber();

    /**
     * Sets whether this call is wrong number.
     *
     * @param wrongNumber the wrong number of this call
     */
    public void setWrongNumber(boolean wrongNumber);

    /**
     * Returns the same address of this call.
     *
     * @return the same address of this call
     */
    public boolean getSameAddress();

    /**
     * Returns <code>true</code> if this call is same address.
     *
     * @return <code>true</code> if this call is same address; <code>false</code> otherwise
     */
    public boolean isSameAddress();

    /**
     * Sets whether this call is same address.
     *
     * @param sameAddress the same address of this call
     */
    public void setSameAddress(boolean sameAddress);

    /**
     * Returns the enrolled of this call.
     *
     * @return the enrolled of this call
     */
    public boolean getEnrolled();

    /**
     * Returns <code>true</code> if this call is enrolled.
     *
     * @return <code>true</code> if this call is enrolled; <code>false</code> otherwise
     */
    public boolean isEnrolled();

    /**
     * Sets whether this call is enrolled.
     *
     * @param enrolled the enrolled of this call
     */
    public void setEnrolled(boolean enrolled);

    /**
     * Returns the duty discharge after911 of this call.
     *
     * @return the duty discharge after911 of this call
     */
    public boolean getDutyDischargeAfter911();

    /**
     * Returns <code>true</code> if this call is duty discharge after911.
     *
     * @return <code>true</code> if this call is duty discharge after911; <code>false</code> otherwise
     */
    public boolean isDutyDischargeAfter911();

    /**
     * Sets whether this call is duty discharge after911.
     *
     * @param dutyDischargeAfter911 the duty discharge after911 of this call
     */
    public void setDutyDischargeAfter911(boolean dutyDischargeAfter911);

    /**
     * Returns the sc condition of this call.
     *
     * @return the sc condition of this call
     */
    public boolean getScCondition();

    /**
     * Returns <code>true</code> if this call is sc condition.
     *
     * @return <code>true</code> if this call is sc condition; <code>false</code> otherwise
     */
    public boolean isScCondition();

    /**
     * Sets whether this call is sc condition.
     *
     * @param scCondition the sc condition of this call
     */
    public void setScCondition(boolean scCondition);

    /**
     * Returns the pcafc qaulified of this call.
     *
     * @return the pcafc qaulified of this call
     */
    public boolean getPcafcQaulified();

    /**
     * Returns <code>true</code> if this call is pcafc qaulified.
     *
     * @return <code>true</code> if this call is pcafc qaulified; <code>false</code> otherwise
     */
    public boolean isPcafcQaulified();

    /**
     * Sets whether this call is pcafc qaulified.
     *
     * @param pcafcQaulified the pcafc qaulified of this call
     */
    public void setPcafcQaulified(boolean pcafcQaulified);

    /**
     * Returns the verified of this call.
     *
     * @return the verified of this call
     */
    public boolean getVerified();

    /**
     * Returns <code>true</code> if this call is verified.
     *
     * @return <code>true</code> if this call is verified; <code>false</code> otherwise
     */
    public boolean isVerified();

    /**
     * Sets whether this call is verified.
     *
     * @param verified the verified of this call
     */
    public void setVerified(boolean verified);

    /**
     * Returns the anonymous of this call.
     *
     * @return the anonymous of this call
     */
    public boolean getAnonymous();

    /**
     * Returns <code>true</code> if this call is anonymous.
     *
     * @return <code>true</code> if this call is anonymous; <code>false</code> otherwise
     */
    public boolean isAnonymous();

    /**
     * Sets whether this call is anonymous.
     *
     * @param anonymous the anonymous of this call
     */
    public void setAnonymous(boolean anonymous);

    /**
     * Returns the create group ID of this call.
     *
     * @return the create group ID of this call
     */
    public long getCreateGroupId();

    /**
     * Sets the create group ID of this call.
     *
     * @param createGroupId the create group ID of this call
     */
    public void setCreateGroupId(long createGroupId);

    /**
     * Returns the user ID of this call.
     *
     * @return the user ID of this call
     */
    public long getUserId();

    /**
     * Sets the user ID of this call.
     *
     * @param userId the user ID of this call
     */
    public void setUserId(long userId);

    /**
     * Returns the user uuid of this call.
     *
     * @return the user uuid of this call
     * @throws SystemException if a system exception occurred
     */
    public String getUserUuid() throws SystemException;

    /**
     * Sets the user uuid of this call.
     *
     * @param userUuid the user uuid of this call
     */
    public void setUserUuid(String userUuid);

    /**
     * Returns the creation date of this call.
     *
     * @return the creation date of this call
     */
    public Date getCreationDate();

    /**
     * Sets the creation date of this call.
     *
     * @param creationDate the creation date of this call
     */
    public void setCreationDate(Date creationDate);

    /**
     * Returns the callback pref of this call.
     *
     * @return the callback pref of this call
     */
    @AutoEscape
    public String getCallbackPref();

    /**
     * Sets the callback pref of this call.
     *
     * @param callbackPref the callback pref of this call
     */
    public void setCallbackPref(String callbackPref);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.Call call);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.Call> toCacheModel();

    @Override
    public gov.va.caret.model.Call toEscapedModel();

    @Override
    public gov.va.caret.model.Call toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
