package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.service.CallLocalServiceUtil;
import gov.va.caret.service.ClpSerializer;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class CallClp extends BaseModelImpl<Call> implements Call {
    private long _callId;
    private String _callType;
    private String _callerRelationship;
    private long _workPrimaryKey;
    private String _callState;
    private long _callerPersnId;
    private String _callerTitle;
    private String _callerLearnAbout;
    private long _veteranPersnId;
    private String _message;
    private String _summary;
    private String _transferRemarks;
    private String _cespGoal;
    private String _cespOutcome;
    private String _transferredTo;
    private String _otherBenefits;
    private String _contactInfo;
    private String _eraService;
    private String _serviceBranch;
    private String _serviceStatus;
    private boolean _contactInfoProvided;
    private boolean _referralAgreeable;
    private boolean _withoutContact;
    private boolean _hangUp;
    private boolean _wrongNumber;
    private boolean _sameAddress;
    private boolean _enrolled;
    private boolean _dutyDischargeAfter911;
    private boolean _scCondition;
    private boolean _pcafcQaulified;
    private boolean _verified;
    private boolean _anonymous;
    private long _createGroupId;
    private long _userId;
    private String _userUuid;
    private Date _creationDate;
    private String _callbackPref;
    private BaseModel<?> _callRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public CallClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return Call.class;
    }

    @Override
    public String getModelClassName() {
        return Call.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _callId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setCallId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _callId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("callId", getCallId());
        attributes.put("callType", getCallType());
        attributes.put("callerRelationship", getCallerRelationship());
        attributes.put("workPrimaryKey", getWorkPrimaryKey());
        attributes.put("callState", getCallState());
        attributes.put("callerPersnId", getCallerPersnId());
        attributes.put("callerTitle", getCallerTitle());
        attributes.put("callerLearnAbout", getCallerLearnAbout());
        attributes.put("veteranPersnId", getVeteranPersnId());
        attributes.put("message", getMessage());
        attributes.put("summary", getSummary());
        attributes.put("transferRemarks", getTransferRemarks());
        attributes.put("cespGoal", getCespGoal());
        attributes.put("cespOutcome", getCespOutcome());
        attributes.put("transferredTo", getTransferredTo());
        attributes.put("otherBenefits", getOtherBenefits());
        attributes.put("contactInfo", getContactInfo());
        attributes.put("eraService", getEraService());
        attributes.put("serviceBranch", getServiceBranch());
        attributes.put("serviceStatus", getServiceStatus());
        attributes.put("contactInfoProvided", getContactInfoProvided());
        attributes.put("referralAgreeable", getReferralAgreeable());
        attributes.put("withoutContact", getWithoutContact());
        attributes.put("hangUp", getHangUp());
        attributes.put("wrongNumber", getWrongNumber());
        attributes.put("sameAddress", getSameAddress());
        attributes.put("enrolled", getEnrolled());
        attributes.put("dutyDischargeAfter911", getDutyDischargeAfter911());
        attributes.put("scCondition", getScCondition());
        attributes.put("pcafcQaulified", getPcafcQaulified());
        attributes.put("verified", getVerified());
        attributes.put("anonymous", getAnonymous());
        attributes.put("createGroupId", getCreateGroupId());
        attributes.put("userId", getUserId());
        attributes.put("creationDate", getCreationDate());
        attributes.put("callbackPref", getCallbackPref());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long callId = (Long) attributes.get("callId");

        if (callId != null) {
            setCallId(callId);
        }

        String callType = (String) attributes.get("callType");

        if (callType != null) {
            setCallType(callType);
        }

        String callerRelationship = (String) attributes.get(
                "callerRelationship");

        if (callerRelationship != null) {
            setCallerRelationship(callerRelationship);
        }

        Long workPrimaryKey = (Long) attributes.get("workPrimaryKey");

        if (workPrimaryKey != null) {
            setWorkPrimaryKey(workPrimaryKey);
        }

        String callState = (String) attributes.get("callState");

        if (callState != null) {
            setCallState(callState);
        }

        Long callerPersnId = (Long) attributes.get("callerPersnId");

        if (callerPersnId != null) {
            setCallerPersnId(callerPersnId);
        }

        String callerTitle = (String) attributes.get("callerTitle");

        if (callerTitle != null) {
            setCallerTitle(callerTitle);
        }

        String callerLearnAbout = (String) attributes.get("callerLearnAbout");

        if (callerLearnAbout != null) {
            setCallerLearnAbout(callerLearnAbout);
        }

        Long veteranPersnId = (Long) attributes.get("veteranPersnId");

        if (veteranPersnId != null) {
            setVeteranPersnId(veteranPersnId);
        }

        String message = (String) attributes.get("message");

        if (message != null) {
            setMessage(message);
        }

        String summary = (String) attributes.get("summary");

        if (summary != null) {
            setSummary(summary);
        }

        String transferRemarks = (String) attributes.get("transferRemarks");

        if (transferRemarks != null) {
            setTransferRemarks(transferRemarks);
        }

        String cespGoal = (String) attributes.get("cespGoal");

        if (cespGoal != null) {
            setCespGoal(cespGoal);
        }

        String cespOutcome = (String) attributes.get("cespOutcome");

        if (cespOutcome != null) {
            setCespOutcome(cespOutcome);
        }

        String transferredTo = (String) attributes.get("transferredTo");

        if (transferredTo != null) {
            setTransferredTo(transferredTo);
        }

        String otherBenefits = (String) attributes.get("otherBenefits");

        if (otherBenefits != null) {
            setOtherBenefits(otherBenefits);
        }

        String contactInfo = (String) attributes.get("contactInfo");

        if (contactInfo != null) {
            setContactInfo(contactInfo);
        }

        String eraService = (String) attributes.get("eraService");

        if (eraService != null) {
            setEraService(eraService);
        }

        String serviceBranch = (String) attributes.get("serviceBranch");

        if (serviceBranch != null) {
            setServiceBranch(serviceBranch);
        }

        String serviceStatus = (String) attributes.get("serviceStatus");

        if (serviceStatus != null) {
            setServiceStatus(serviceStatus);
        }

        Boolean contactInfoProvided = (Boolean) attributes.get(
                "contactInfoProvided");

        if (contactInfoProvided != null) {
            setContactInfoProvided(contactInfoProvided);
        }

        Boolean referralAgreeable = (Boolean) attributes.get(
                "referralAgreeable");

        if (referralAgreeable != null) {
            setReferralAgreeable(referralAgreeable);
        }

        Boolean withoutContact = (Boolean) attributes.get("withoutContact");

        if (withoutContact != null) {
            setWithoutContact(withoutContact);
        }

        Boolean hangUp = (Boolean) attributes.get("hangUp");

        if (hangUp != null) {
            setHangUp(hangUp);
        }

        Boolean wrongNumber = (Boolean) attributes.get("wrongNumber");

        if (wrongNumber != null) {
            setWrongNumber(wrongNumber);
        }

        Boolean sameAddress = (Boolean) attributes.get("sameAddress");

        if (sameAddress != null) {
            setSameAddress(sameAddress);
        }

        Boolean enrolled = (Boolean) attributes.get("enrolled");

        if (enrolled != null) {
            setEnrolled(enrolled);
        }

        Boolean dutyDischargeAfter911 = (Boolean) attributes.get(
                "dutyDischargeAfter911");

        if (dutyDischargeAfter911 != null) {
            setDutyDischargeAfter911(dutyDischargeAfter911);
        }

        Boolean scCondition = (Boolean) attributes.get("scCondition");

        if (scCondition != null) {
            setScCondition(scCondition);
        }

        Boolean pcafcQaulified = (Boolean) attributes.get("pcafcQaulified");

        if (pcafcQaulified != null) {
            setPcafcQaulified(pcafcQaulified);
        }

        Boolean verified = (Boolean) attributes.get("verified");

        if (verified != null) {
            setVerified(verified);
        }

        Boolean anonymous = (Boolean) attributes.get("anonymous");

        if (anonymous != null) {
            setAnonymous(anonymous);
        }

        Long createGroupId = (Long) attributes.get("createGroupId");

        if (createGroupId != null) {
            setCreateGroupId(createGroupId);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        String callbackPref = (String) attributes.get("callbackPref");

        if (callbackPref != null) {
            setCallbackPref(callbackPref);
        }
    }

    @Override
    public long getCallId() {
        return _callId;
    }

    @Override
    public void setCallId(long callId) {
        _callId = callId;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setCallId", long.class);

                method.invoke(_callRemoteModel, callId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCallType() {
        return _callType;
    }

    @Override
    public void setCallType(String callType) {
        _callType = callType;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setCallType", String.class);

                method.invoke(_callRemoteModel, callType);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCallerRelationship() {
        return _callerRelationship;
    }

    @Override
    public void setCallerRelationship(String callerRelationship) {
        _callerRelationship = callerRelationship;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setCallerRelationship",
                        String.class);

                method.invoke(_callRemoteModel, callerRelationship);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getWorkPrimaryKey() {
        return _workPrimaryKey;
    }

    @Override
    public void setWorkPrimaryKey(long workPrimaryKey) {
        _workPrimaryKey = workPrimaryKey;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setWorkPrimaryKey", long.class);

                method.invoke(_callRemoteModel, workPrimaryKey);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCallState() {
        return _callState;
    }

    @Override
    public void setCallState(String callState) {
        _callState = callState;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setCallState", String.class);

                method.invoke(_callRemoteModel, callState);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getCallerPersnId() {
        return _callerPersnId;
    }

    @Override
    public void setCallerPersnId(long callerPersnId) {
        _callerPersnId = callerPersnId;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setCallerPersnId", long.class);

                method.invoke(_callRemoteModel, callerPersnId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCallerTitle() {
        return _callerTitle;
    }

    @Override
    public void setCallerTitle(String callerTitle) {
        _callerTitle = callerTitle;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setCallerTitle", String.class);

                method.invoke(_callRemoteModel, callerTitle);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCallerLearnAbout() {
        return _callerLearnAbout;
    }

    @Override
    public void setCallerLearnAbout(String callerLearnAbout) {
        _callerLearnAbout = callerLearnAbout;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setCallerLearnAbout",
                        String.class);

                method.invoke(_callRemoteModel, callerLearnAbout);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getVeteranPersnId() {
        return _veteranPersnId;
    }

    @Override
    public void setVeteranPersnId(long veteranPersnId) {
        _veteranPersnId = veteranPersnId;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setVeteranPersnId", long.class);

                method.invoke(_callRemoteModel, veteranPersnId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getMessage() {
        return _message;
    }

    @Override
    public void setMessage(String message) {
        _message = message;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setMessage", String.class);

                method.invoke(_callRemoteModel, message);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getSummary() {
        return _summary;
    }

    @Override
    public void setSummary(String summary) {
        _summary = summary;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setSummary", String.class);

                method.invoke(_callRemoteModel, summary);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getTransferRemarks() {
        return _transferRemarks;
    }

    @Override
    public void setTransferRemarks(String transferRemarks) {
        _transferRemarks = transferRemarks;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setTransferRemarks",
                        String.class);

                method.invoke(_callRemoteModel, transferRemarks);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCespGoal() {
        return _cespGoal;
    }

    @Override
    public void setCespGoal(String cespGoal) {
        _cespGoal = cespGoal;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setCespGoal", String.class);

                method.invoke(_callRemoteModel, cespGoal);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCespOutcome() {
        return _cespOutcome;
    }

    @Override
    public void setCespOutcome(String cespOutcome) {
        _cespOutcome = cespOutcome;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setCespOutcome", String.class);

                method.invoke(_callRemoteModel, cespOutcome);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getTransferredTo() {
        return _transferredTo;
    }

    @Override
    public void setTransferredTo(String transferredTo) {
        _transferredTo = transferredTo;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setTransferredTo", String.class);

                method.invoke(_callRemoteModel, transferredTo);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getOtherBenefits() {
        return _otherBenefits;
    }

    @Override
    public void setOtherBenefits(String otherBenefits) {
        _otherBenefits = otherBenefits;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setOtherBenefits", String.class);

                method.invoke(_callRemoteModel, otherBenefits);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getContactInfo() {
        return _contactInfo;
    }

    @Override
    public void setContactInfo(String contactInfo) {
        _contactInfo = contactInfo;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setContactInfo", String.class);

                method.invoke(_callRemoteModel, contactInfo);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getEraService() {
        return _eraService;
    }

    @Override
    public void setEraService(String eraService) {
        _eraService = eraService;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setEraService", String.class);

                method.invoke(_callRemoteModel, eraService);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getServiceBranch() {
        return _serviceBranch;
    }

    @Override
    public void setServiceBranch(String serviceBranch) {
        _serviceBranch = serviceBranch;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setServiceBranch", String.class);

                method.invoke(_callRemoteModel, serviceBranch);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getServiceStatus() {
        return _serviceStatus;
    }

    @Override
    public void setServiceStatus(String serviceStatus) {
        _serviceStatus = serviceStatus;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setServiceStatus", String.class);

                method.invoke(_callRemoteModel, serviceStatus);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getContactInfoProvided() {
        return _contactInfoProvided;
    }

    @Override
    public boolean isContactInfoProvided() {
        return _contactInfoProvided;
    }

    @Override
    public void setContactInfoProvided(boolean contactInfoProvided) {
        _contactInfoProvided = contactInfoProvided;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setContactInfoProvided",
                        boolean.class);

                method.invoke(_callRemoteModel, contactInfoProvided);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getReferralAgreeable() {
        return _referralAgreeable;
    }

    @Override
    public boolean isReferralAgreeable() {
        return _referralAgreeable;
    }

    @Override
    public void setReferralAgreeable(boolean referralAgreeable) {
        _referralAgreeable = referralAgreeable;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setReferralAgreeable",
                        boolean.class);

                method.invoke(_callRemoteModel, referralAgreeable);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getWithoutContact() {
        return _withoutContact;
    }

    @Override
    public boolean isWithoutContact() {
        return _withoutContact;
    }

    @Override
    public void setWithoutContact(boolean withoutContact) {
        _withoutContact = withoutContact;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setWithoutContact",
                        boolean.class);

                method.invoke(_callRemoteModel, withoutContact);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getHangUp() {
        return _hangUp;
    }

    @Override
    public boolean isHangUp() {
        return _hangUp;
    }

    @Override
    public void setHangUp(boolean hangUp) {
        _hangUp = hangUp;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setHangUp", boolean.class);

                method.invoke(_callRemoteModel, hangUp);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getWrongNumber() {
        return _wrongNumber;
    }

    @Override
    public boolean isWrongNumber() {
        return _wrongNumber;
    }

    @Override
    public void setWrongNumber(boolean wrongNumber) {
        _wrongNumber = wrongNumber;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setWrongNumber", boolean.class);

                method.invoke(_callRemoteModel, wrongNumber);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getSameAddress() {
        return _sameAddress;
    }

    @Override
    public boolean isSameAddress() {
        return _sameAddress;
    }

    @Override
    public void setSameAddress(boolean sameAddress) {
        _sameAddress = sameAddress;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setSameAddress", boolean.class);

                method.invoke(_callRemoteModel, sameAddress);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getEnrolled() {
        return _enrolled;
    }

    @Override
    public boolean isEnrolled() {
        return _enrolled;
    }

    @Override
    public void setEnrolled(boolean enrolled) {
        _enrolled = enrolled;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setEnrolled", boolean.class);

                method.invoke(_callRemoteModel, enrolled);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getDutyDischargeAfter911() {
        return _dutyDischargeAfter911;
    }

    @Override
    public boolean isDutyDischargeAfter911() {
        return _dutyDischargeAfter911;
    }

    @Override
    public void setDutyDischargeAfter911(boolean dutyDischargeAfter911) {
        _dutyDischargeAfter911 = dutyDischargeAfter911;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setDutyDischargeAfter911",
                        boolean.class);

                method.invoke(_callRemoteModel, dutyDischargeAfter911);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getScCondition() {
        return _scCondition;
    }

    @Override
    public boolean isScCondition() {
        return _scCondition;
    }

    @Override
    public void setScCondition(boolean scCondition) {
        _scCondition = scCondition;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setScCondition", boolean.class);

                method.invoke(_callRemoteModel, scCondition);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getPcafcQaulified() {
        return _pcafcQaulified;
    }

    @Override
    public boolean isPcafcQaulified() {
        return _pcafcQaulified;
    }

    @Override
    public void setPcafcQaulified(boolean pcafcQaulified) {
        _pcafcQaulified = pcafcQaulified;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setPcafcQaulified",
                        boolean.class);

                method.invoke(_callRemoteModel, pcafcQaulified);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getVerified() {
        return _verified;
    }

    @Override
    public boolean isVerified() {
        return _verified;
    }

    @Override
    public void setVerified(boolean verified) {
        _verified = verified;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setVerified", boolean.class);

                method.invoke(_callRemoteModel, verified);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getAnonymous() {
        return _anonymous;
    }

    @Override
    public boolean isAnonymous() {
        return _anonymous;
    }

    @Override
    public void setAnonymous(boolean anonymous) {
        _anonymous = anonymous;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setAnonymous", boolean.class);

                method.invoke(_callRemoteModel, anonymous);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getCreateGroupId() {
        return _createGroupId;
    }

    @Override
    public void setCreateGroupId(long createGroupId) {
        _createGroupId = createGroupId;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setCreateGroupId", long.class);

                method.invoke(_callRemoteModel, createGroupId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setUserId", long.class);

                method.invoke(_callRemoteModel, userId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setCreationDate", Date.class);

                method.invoke(_callRemoteModel, creationDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCallbackPref() {
        return _callbackPref;
    }

    @Override
    public void setCallbackPref(String callbackPref) {
        _callbackPref = callbackPref;

        if (_callRemoteModel != null) {
            try {
                Class<?> clazz = _callRemoteModel.getClass();

                Method method = clazz.getMethod("setCallbackPref", String.class);

                method.invoke(_callRemoteModel, callbackPref);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getCallRemoteModel() {
        return _callRemoteModel;
    }

    public void setCallRemoteModel(BaseModel<?> callRemoteModel) {
        _callRemoteModel = callRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _callRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_callRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            CallLocalServiceUtil.addCall(this);
        } else {
            CallLocalServiceUtil.updateCall(this);
        }
    }

    @Override
    public Call toEscapedModel() {
        return (Call) ProxyUtil.newProxyInstance(Call.class.getClassLoader(),
            new Class[] { Call.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        CallClp clone = new CallClp();

        clone.setCallId(getCallId());
        clone.setCallType(getCallType());
        clone.setCallerRelationship(getCallerRelationship());
        clone.setWorkPrimaryKey(getWorkPrimaryKey());
        clone.setCallState(getCallState());
        clone.setCallerPersnId(getCallerPersnId());
        clone.setCallerTitle(getCallerTitle());
        clone.setCallerLearnAbout(getCallerLearnAbout());
        clone.setVeteranPersnId(getVeteranPersnId());
        clone.setMessage(getMessage());
        clone.setSummary(getSummary());
        clone.setTransferRemarks(getTransferRemarks());
        clone.setCespGoal(getCespGoal());
        clone.setCespOutcome(getCespOutcome());
        clone.setTransferredTo(getTransferredTo());
        clone.setOtherBenefits(getOtherBenefits());
        clone.setContactInfo(getContactInfo());
        clone.setEraService(getEraService());
        clone.setServiceBranch(getServiceBranch());
        clone.setServiceStatus(getServiceStatus());
        clone.setContactInfoProvided(getContactInfoProvided());
        clone.setReferralAgreeable(getReferralAgreeable());
        clone.setWithoutContact(getWithoutContact());
        clone.setHangUp(getHangUp());
        clone.setWrongNumber(getWrongNumber());
        clone.setSameAddress(getSameAddress());
        clone.setEnrolled(getEnrolled());
        clone.setDutyDischargeAfter911(getDutyDischargeAfter911());
        clone.setScCondition(getScCondition());
        clone.setPcafcQaulified(getPcafcQaulified());
        clone.setVerified(getVerified());
        clone.setAnonymous(getAnonymous());
        clone.setCreateGroupId(getCreateGroupId());
        clone.setUserId(getUserId());
        clone.setCreationDate(getCreationDate());
        clone.setCallbackPref(getCallbackPref());

        return clone;
    }

    @Override
    public int compareTo(Call call) {
        int value = 0;

        value = DateUtil.compareTo(getCreationDate(), call.getCreationDate());

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof CallClp)) {
            return false;
        }

        CallClp call = (CallClp) obj;

        long primaryKey = call.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(73);

        sb.append("{callId=");
        sb.append(getCallId());
        sb.append(", callType=");
        sb.append(getCallType());
        sb.append(", callerRelationship=");
        sb.append(getCallerRelationship());
        sb.append(", workPrimaryKey=");
        sb.append(getWorkPrimaryKey());
        sb.append(", callState=");
        sb.append(getCallState());
        sb.append(", callerPersnId=");
        sb.append(getCallerPersnId());
        sb.append(", callerTitle=");
        sb.append(getCallerTitle());
        sb.append(", callerLearnAbout=");
        sb.append(getCallerLearnAbout());
        sb.append(", veteranPersnId=");
        sb.append(getVeteranPersnId());
        sb.append(", message=");
        sb.append(getMessage());
        sb.append(", summary=");
        sb.append(getSummary());
        sb.append(", transferRemarks=");
        sb.append(getTransferRemarks());
        sb.append(", cespGoal=");
        sb.append(getCespGoal());
        sb.append(", cespOutcome=");
        sb.append(getCespOutcome());
        sb.append(", transferredTo=");
        sb.append(getTransferredTo());
        sb.append(", otherBenefits=");
        sb.append(getOtherBenefits());
        sb.append(", contactInfo=");
        sb.append(getContactInfo());
        sb.append(", eraService=");
        sb.append(getEraService());
        sb.append(", serviceBranch=");
        sb.append(getServiceBranch());
        sb.append(", serviceStatus=");
        sb.append(getServiceStatus());
        sb.append(", contactInfoProvided=");
        sb.append(getContactInfoProvided());
        sb.append(", referralAgreeable=");
        sb.append(getReferralAgreeable());
        sb.append(", withoutContact=");
        sb.append(getWithoutContact());
        sb.append(", hangUp=");
        sb.append(getHangUp());
        sb.append(", wrongNumber=");
        sb.append(getWrongNumber());
        sb.append(", sameAddress=");
        sb.append(getSameAddress());
        sb.append(", enrolled=");
        sb.append(getEnrolled());
        sb.append(", dutyDischargeAfter911=");
        sb.append(getDutyDischargeAfter911());
        sb.append(", scCondition=");
        sb.append(getScCondition());
        sb.append(", pcafcQaulified=");
        sb.append(getPcafcQaulified());
        sb.append(", verified=");
        sb.append(getVerified());
        sb.append(", anonymous=");
        sb.append(getAnonymous());
        sb.append(", createGroupId=");
        sb.append(getCreateGroupId());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", callbackPref=");
        sb.append(getCallbackPref());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(112);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Call");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>callId</column-name><column-value><![CDATA[");
        sb.append(getCallId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callType</column-name><column-value><![CDATA[");
        sb.append(getCallType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callerRelationship</column-name><column-value><![CDATA[");
        sb.append(getCallerRelationship());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>workPrimaryKey</column-name><column-value><![CDATA[");
        sb.append(getWorkPrimaryKey());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callState</column-name><column-value><![CDATA[");
        sb.append(getCallState());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callerPersnId</column-name><column-value><![CDATA[");
        sb.append(getCallerPersnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callerTitle</column-name><column-value><![CDATA[");
        sb.append(getCallerTitle());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callerLearnAbout</column-name><column-value><![CDATA[");
        sb.append(getCallerLearnAbout());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>veteranPersnId</column-name><column-value><![CDATA[");
        sb.append(getVeteranPersnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>message</column-name><column-value><![CDATA[");
        sb.append(getMessage());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>summary</column-name><column-value><![CDATA[");
        sb.append(getSummary());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>transferRemarks</column-name><column-value><![CDATA[");
        sb.append(getTransferRemarks());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cespGoal</column-name><column-value><![CDATA[");
        sb.append(getCespGoal());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cespOutcome</column-name><column-value><![CDATA[");
        sb.append(getCespOutcome());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>transferredTo</column-name><column-value><![CDATA[");
        sb.append(getTransferredTo());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>otherBenefits</column-name><column-value><![CDATA[");
        sb.append(getOtherBenefits());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>contactInfo</column-name><column-value><![CDATA[");
        sb.append(getContactInfo());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>eraService</column-name><column-value><![CDATA[");
        sb.append(getEraService());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>serviceBranch</column-name><column-value><![CDATA[");
        sb.append(getServiceBranch());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>serviceStatus</column-name><column-value><![CDATA[");
        sb.append(getServiceStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>contactInfoProvided</column-name><column-value><![CDATA[");
        sb.append(getContactInfoProvided());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>referralAgreeable</column-name><column-value><![CDATA[");
        sb.append(getReferralAgreeable());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>withoutContact</column-name><column-value><![CDATA[");
        sb.append(getWithoutContact());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>hangUp</column-name><column-value><![CDATA[");
        sb.append(getHangUp());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>wrongNumber</column-name><column-value><![CDATA[");
        sb.append(getWrongNumber());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>sameAddress</column-name><column-value><![CDATA[");
        sb.append(getSameAddress());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>enrolled</column-name><column-value><![CDATA[");
        sb.append(getEnrolled());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>dutyDischargeAfter911</column-name><column-value><![CDATA[");
        sb.append(getDutyDischargeAfter911());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>scCondition</column-name><column-value><![CDATA[");
        sb.append(getScCondition());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>pcafcQaulified</column-name><column-value><![CDATA[");
        sb.append(getPcafcQaulified());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>verified</column-name><column-value><![CDATA[");
        sb.append(getVerified());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>anonymous</column-name><column-value><![CDATA[");
        sb.append(getAnonymous());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>createGroupId</column-name><column-value><![CDATA[");
        sb.append(getCreateGroupId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callbackPref</column-name><column-value><![CDATA[");
        sb.append(getCallbackPref());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
