package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the BoxGp service. Represents a row in the &quot;CARET_BOXED_GROUP&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.BoxGpModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.BoxGpImpl}.
 * </p>
 *
 * @author caret
 * @see BoxGp
 * @see gov.va.caret.model.impl.BoxGpImpl
 * @see gov.va.caret.model.impl.BoxGpModelImpl
 * @generated
 */
public interface BoxGpModel extends BaseModel<BoxGp> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a box gp model instance should use the {@link BoxGp} interface instead.
     */

    /**
     * Returns the primary key of this box gp.
     *
     * @return the primary key of this box gp
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this box gp.
     *
     * @param primaryKey the primary key of this box gp
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the box gp ID of this box gp.
     *
     * @return the box gp ID of this box gp
     */
    public long getBoxGpId();

    /**
     * Sets the box gp ID of this box gp.
     *
     * @param boxGpId the box gp ID of this box gp
     */
    public void setBoxGpId(long boxGpId);

    /**
     * Returns the box group of this box gp.
     *
     * @return the box group of this box gp
     */
    @AutoEscape
    public String getBoxGroup();

    /**
     * Sets the box group of this box gp.
     *
     * @param boxGroup the box group of this box gp
     */
    public void setBoxGroup(String boxGroup);

    /**
     * Returns the box sub group of this box gp.
     *
     * @return the box sub group of this box gp
     */
    @AutoEscape
    public String getBoxSubGroup();

    /**
     * Sets the box sub group of this box gp.
     *
     * @param boxSubGroup the box sub group of this box gp
     */
    public void setBoxSubGroup(String boxSubGroup);

    /**
     * Returns the label of this box gp.
     *
     * @return the label of this box gp
     */
    @AutoEscape
    public String getLabel();

    /**
     * Sets the label of this box gp.
     *
     * @param label the label of this box gp
     */
    public void setLabel(String label);

    /**
     * Returns the view sequence of this box gp.
     *
     * @return the view sequence of this box gp
     */
    public int getViewSequence();

    /**
     * Sets the view sequence of this box gp.
     *
     * @param viewSequence the view sequence of this box gp
     */
    public void setViewSequence(int viewSequence);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.BoxGp boxGp);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.BoxGp> toCacheModel();

    @Override
    public gov.va.caret.model.BoxGp toEscapedModel();

    @Override
    public gov.va.caret.model.BoxGp toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
