package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.BlsReLocalServiceUtil;
import gov.va.caret.service.ClpSerializer;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.HashMap;
import java.util.Map;


public class BlsReClp extends BaseModelImpl<BlsRe> implements BlsRe {
    private long _blsReId;
    private long _blsAeId;
    private int _year;
    private Double _h75;
    private String _city;
    private String _zip;
    private String _state;
    private String _county;
    private BaseModel<?> _blsReRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public BlsReClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return BlsRe.class;
    }

    @Override
    public String getModelClassName() {
        return BlsRe.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _blsReId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setBlsReId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _blsReId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("blsReId", getBlsReId());
        attributes.put("blsAeId", getBlsAeId());
        attributes.put("year", getYear());
        attributes.put("h75", getH75());
        attributes.put("city", getCity());
        attributes.put("zip", getZip());
        attributes.put("state", getState());
        attributes.put("county", getCounty());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long blsReId = (Long) attributes.get("blsReId");

        if (blsReId != null) {
            setBlsReId(blsReId);
        }

        Long blsAeId = (Long) attributes.get("blsAeId");

        if (blsAeId != null) {
            setBlsAeId(blsAeId);
        }

        Integer year = (Integer) attributes.get("year");

        if (year != null) {
            setYear(year);
        }

        Double h75 = (Double) attributes.get("h75");

        if (h75 != null) {
            setH75(h75);
        }

        String city = (String) attributes.get("city");

        if (city != null) {
            setCity(city);
        }

        String zip = (String) attributes.get("zip");

        if (zip != null) {
            setZip(zip);
        }

        String state = (String) attributes.get("state");

        if (state != null) {
            setState(state);
        }

        String county = (String) attributes.get("county");

        if (county != null) {
            setCounty(county);
        }
    }

    @Override
    public long getBlsReId() {
        return _blsReId;
    }

    @Override
    public void setBlsReId(long blsReId) {
        _blsReId = blsReId;

        if (_blsReRemoteModel != null) {
            try {
                Class<?> clazz = _blsReRemoteModel.getClass();

                Method method = clazz.getMethod("setBlsReId", long.class);

                method.invoke(_blsReRemoteModel, blsReId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getBlsAeId() {
        return _blsAeId;
    }

    @Override
    public void setBlsAeId(long blsAeId) {
        _blsAeId = blsAeId;

        if (_blsReRemoteModel != null) {
            try {
                Class<?> clazz = _blsReRemoteModel.getClass();

                Method method = clazz.getMethod("setBlsAeId", long.class);

                method.invoke(_blsReRemoteModel, blsAeId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public int getYear() {
        return _year;
    }

    @Override
    public void setYear(int year) {
        _year = year;

        if (_blsReRemoteModel != null) {
            try {
                Class<?> clazz = _blsReRemoteModel.getClass();

                Method method = clazz.getMethod("setYear", int.class);

                method.invoke(_blsReRemoteModel, year);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Double getH75() {
        return _h75;
    }

    @Override
    public void setH75(Double h75) {
        _h75 = h75;

        if (_blsReRemoteModel != null) {
            try {
                Class<?> clazz = _blsReRemoteModel.getClass();

                Method method = clazz.getMethod("setH75", Double.class);

                method.invoke(_blsReRemoteModel, h75);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCity() {
        return _city;
    }

    @Override
    public void setCity(String city) {
        _city = city;

        if (_blsReRemoteModel != null) {
            try {
                Class<?> clazz = _blsReRemoteModel.getClass();

                Method method = clazz.getMethod("setCity", String.class);

                method.invoke(_blsReRemoteModel, city);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getZip() {
        return _zip;
    }

    @Override
    public void setZip(String zip) {
        _zip = zip;

        if (_blsReRemoteModel != null) {
            try {
                Class<?> clazz = _blsReRemoteModel.getClass();

                Method method = clazz.getMethod("setZip", String.class);

                method.invoke(_blsReRemoteModel, zip);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getState() {
        return _state;
    }

    @Override
    public void setState(String state) {
        _state = state;

        if (_blsReRemoteModel != null) {
            try {
                Class<?> clazz = _blsReRemoteModel.getClass();

                Method method = clazz.getMethod("setState", String.class);

                method.invoke(_blsReRemoteModel, state);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCounty() {
        return _county;
    }

    @Override
    public void setCounty(String county) {
        _county = county;

        if (_blsReRemoteModel != null) {
            try {
                Class<?> clazz = _blsReRemoteModel.getClass();

                Method method = clazz.getMethod("setCounty", String.class);

                method.invoke(_blsReRemoteModel, county);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getBlsReRemoteModel() {
        return _blsReRemoteModel;
    }

    public void setBlsReRemoteModel(BaseModel<?> blsReRemoteModel) {
        _blsReRemoteModel = blsReRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _blsReRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_blsReRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            BlsReLocalServiceUtil.addBlsRe(this);
        } else {
            BlsReLocalServiceUtil.updateBlsRe(this);
        }
    }

    @Override
    public BlsRe toEscapedModel() {
        return (BlsRe) ProxyUtil.newProxyInstance(BlsRe.class.getClassLoader(),
            new Class[] { BlsRe.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        BlsReClp clone = new BlsReClp();

        clone.setBlsReId(getBlsReId());
        clone.setBlsAeId(getBlsAeId());
        clone.setYear(getYear());
        clone.setH75(getH75());
        clone.setCity(getCity());
        clone.setZip(getZip());
        clone.setState(getState());
        clone.setCounty(getCounty());

        return clone;
    }

    @Override
    public int compareTo(BlsRe blsRe) {
        int value = 0;

        value = getState().compareTo(blsRe.getState());

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof BlsReClp)) {
            return false;
        }

        BlsReClp blsRe = (BlsReClp) obj;

        long primaryKey = blsRe.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(17);

        sb.append("{blsReId=");
        sb.append(getBlsReId());
        sb.append(", blsAeId=");
        sb.append(getBlsAeId());
        sb.append(", year=");
        sb.append(getYear());
        sb.append(", h75=");
        sb.append(getH75());
        sb.append(", city=");
        sb.append(getCity());
        sb.append(", zip=");
        sb.append(getZip());
        sb.append(", state=");
        sb.append(getState());
        sb.append(", county=");
        sb.append(getCounty());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(28);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.BlsRe");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>blsReId</column-name><column-value><![CDATA[");
        sb.append(getBlsReId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>blsAeId</column-name><column-value><![CDATA[");
        sb.append(getBlsAeId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>year</column-name><column-value><![CDATA[");
        sb.append(getYear());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>h75</column-name><column-value><![CDATA[");
        sb.append(getH75());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>city</column-name><column-value><![CDATA[");
        sb.append(getCity());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>zip</column-name><column-value><![CDATA[");
        sb.append(getZip());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>state</column-name><column-value><![CDATA[");
        sb.append(getState());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>county</column-name><column-value><![CDATA[");
        sb.append(getCounty());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
