/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link BgMem}.
 * </p>
 *
 * @author caret
 * @see BgMem
 * @generated
 */
public class BgMemWrapper implements BgMem, ModelWrapper<BgMem> {
	public BgMemWrapper(BgMem bgMem) {
		_bgMem = bgMem;
	}

	@Override
	public Class<?> getModelClass() {
		return BgMem.class;
	}

	@Override
	public String getModelClassName() {
		return BgMem.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("bgMemId", getBgMemId());
		attributes.put("ownerId", getOwnerId());
		attributes.put("boxGpId", getBoxGpId());
		attributes.put("mediumText", getMediumText());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long bgMemId = (Long)attributes.get("bgMemId");

		if (bgMemId != null) {
			setBgMemId(bgMemId);
		}

		Long ownerId = (Long)attributes.get("ownerId");

		if (ownerId != null) {
			setOwnerId(ownerId);
		}

		Long boxGpId = (Long)attributes.get("boxGpId");

		if (boxGpId != null) {
			setBoxGpId(boxGpId);
		}

		String mediumText = (String)attributes.get("mediumText");

		if (mediumText != null) {
			setMediumText(mediumText);
		}
	}

	/**
	* Returns the primary key of this bg mem.
	*
	* @return the primary key of this bg mem
	*/
	@Override
	public long getPrimaryKey() {
		return _bgMem.getPrimaryKey();
	}

	/**
	* Sets the primary key of this bg mem.
	*
	* @param primaryKey the primary key of this bg mem
	*/
	@Override
	public void setPrimaryKey(long primaryKey) {
		_bgMem.setPrimaryKey(primaryKey);
	}

	/**
	* Returns the bg mem ID of this bg mem.
	*
	* @return the bg mem ID of this bg mem
	*/
	@Override
	public long getBgMemId() {
		return _bgMem.getBgMemId();
	}

	/**
	* Sets the bg mem ID of this bg mem.
	*
	* @param bgMemId the bg mem ID of this bg mem
	*/
	@Override
	public void setBgMemId(long bgMemId) {
		_bgMem.setBgMemId(bgMemId);
	}

	/**
	* Returns the owner ID of this bg mem.
	*
	* @return the owner ID of this bg mem
	*/
	@Override
	public long getOwnerId() {
		return _bgMem.getOwnerId();
	}

	/**
	* Sets the owner ID of this bg mem.
	*
	* @param ownerId the owner ID of this bg mem
	*/
	@Override
	public void setOwnerId(long ownerId) {
		_bgMem.setOwnerId(ownerId);
	}

	/**
	* Returns the box gp ID of this bg mem.
	*
	* @return the box gp ID of this bg mem
	*/
	@Override
	public long getBoxGpId() {
		return _bgMem.getBoxGpId();
	}

	/**
	* Sets the box gp ID of this bg mem.
	*
	* @param boxGpId the box gp ID of this bg mem
	*/
	@Override
	public void setBoxGpId(long boxGpId) {
		_bgMem.setBoxGpId(boxGpId);
	}

	/**
	* Returns the medium text of this bg mem.
	*
	* @return the medium text of this bg mem
	*/
	@Override
	public java.lang.String getMediumText() {
		return _bgMem.getMediumText();
	}

	/**
	* Sets the medium text of this bg mem.
	*
	* @param mediumText the medium text of this bg mem
	*/
	@Override
	public void setMediumText(java.lang.String mediumText) {
		_bgMem.setMediumText(mediumText);
	}

	@Override
	public boolean isNew() {
		return _bgMem.isNew();
	}

	@Override
	public void setNew(boolean n) {
		_bgMem.setNew(n);
	}

	@Override
	public boolean isCachedModel() {
		return _bgMem.isCachedModel();
	}

	@Override
	public void setCachedModel(boolean cachedModel) {
		_bgMem.setCachedModel(cachedModel);
	}

	@Override
	public boolean isEscapedModel() {
		return _bgMem.isEscapedModel();
	}

	@Override
	public java.io.Serializable getPrimaryKeyObj() {
		return _bgMem.getPrimaryKeyObj();
	}

	@Override
	public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
		_bgMem.setPrimaryKeyObj(primaryKeyObj);
	}

	@Override
	public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
		return _bgMem.getExpandoBridge();
	}

	@Override
	public void setExpandoBridgeAttributes(
		com.liferay.portal.model.BaseModel<?> baseModel) {
		_bgMem.setExpandoBridgeAttributes(baseModel);
	}

	@Override
	public void setExpandoBridgeAttributes(
		com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
		_bgMem.setExpandoBridgeAttributes(expandoBridge);
	}

	@Override
	public void setExpandoBridgeAttributes(
		com.liferay.portal.service.ServiceContext serviceContext) {
		_bgMem.setExpandoBridgeAttributes(serviceContext);
	}

	@Override
	public java.lang.Object clone() {
		return new BgMemWrapper((BgMem)_bgMem.clone());
	}

	@Override
	public int compareTo(gov.va.caret.model.BgMem bgMem) {
		return _bgMem.compareTo(bgMem);
	}

	@Override
	public int hashCode() {
		return _bgMem.hashCode();
	}

	@Override
	public com.liferay.portal.model.CacheModel<gov.va.caret.model.BgMem> toCacheModel() {
		return _bgMem.toCacheModel();
	}

	@Override
	public gov.va.caret.model.BgMem toEscapedModel() {
		return new BgMemWrapper(_bgMem.toEscapedModel());
	}

	@Override
	public gov.va.caret.model.BgMem toUnescapedModel() {
		return new BgMemWrapper(_bgMem.toUnescapedModel());
	}

	@Override
	public java.lang.String toString() {
		return _bgMem.toString();
	}

	@Override
	public java.lang.String toXmlString() {
		return _bgMem.toXmlString();
	}

	@Override
	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		_bgMem.persist();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof BgMemWrapper)) {
			return false;
		}

		BgMemWrapper bgMemWrapper = (BgMemWrapper)obj;

		if (Validator.equals(_bgMem, bgMemWrapper._bgMem)) {
			return true;
		}

		return false;
	}

	/**
	 * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
	 */
	public BgMem getWrappedBgMem() {
		return _bgMem;
	}

	@Override
	public BgMem getWrappedModel() {
		return _bgMem;
	}

	@Override
	public void resetOriginalValues() {
		_bgMem.resetOriginalValues();
	}

	private BgMem _bgMem;
}