/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class BgMemSoap implements Serializable {
	public static BgMemSoap toSoapModel(BgMem model) {
		BgMemSoap soapModel = new BgMemSoap();

		soapModel.setBgMemId(model.getBgMemId());
		soapModel.setOwnerId(model.getOwnerId());
		soapModel.setBoxGpId(model.getBoxGpId());
		soapModel.setMediumText(model.getMediumText());

		return soapModel;
	}

	public static BgMemSoap[] toSoapModels(BgMem[] models) {
		BgMemSoap[] soapModels = new BgMemSoap[models.length];

		for (int i = 0; i < models.length; i++) {
			soapModels[i] = toSoapModel(models[i]);
		}

		return soapModels;
	}

	public static BgMemSoap[][] toSoapModels(BgMem[][] models) {
		BgMemSoap[][] soapModels = null;

		if (models.length > 0) {
			soapModels = new BgMemSoap[models.length][models[0].length];
		}
		else {
			soapModels = new BgMemSoap[0][0];
		}

		for (int i = 0; i < models.length; i++) {
			soapModels[i] = toSoapModels(models[i]);
		}

		return soapModels;
	}

	public static BgMemSoap[] toSoapModels(List<BgMem> models) {
		List<BgMemSoap> soapModels = new ArrayList<BgMemSoap>(models.size());

		for (BgMem model : models) {
			soapModels.add(toSoapModel(model));
		}

		return soapModels.toArray(new BgMemSoap[soapModels.size()]);
	}

	public BgMemSoap() {
	}

	public long getPrimaryKey() {
		return _bgMemId;
	}

	public void setPrimaryKey(long pk) {
		setBgMemId(pk);
	}

	public long getBgMemId() {
		return _bgMemId;
	}

	public void setBgMemId(long bgMemId) {
		_bgMemId = bgMemId;
	}

	public long getOwnerId() {
		return _ownerId;
	}

	public void setOwnerId(long ownerId) {
		_ownerId = ownerId;
	}

	public long getBoxGpId() {
		return _boxGpId;
	}

	public void setBoxGpId(long boxGpId) {
		_boxGpId = boxGpId;
	}

	public String getMediumText() {
		return _mediumText;
	}

	public void setMediumText(String mediumText) {
		_mediumText = mediumText;
	}

	private long _bgMemId;
	private long _ownerId;
	private long _boxGpId;
	private String _mediumText;
}