/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the BgMem service. Represents a row in the &quot;CARET_MEDIUM_STR_ASSOCIATION&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.BgMemModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.BgMemImpl}.
 * </p>
 *
 * @author caret
 * @see BgMem
 * @see gov.va.caret.model.impl.BgMemImpl
 * @see gov.va.caret.model.impl.BgMemModelImpl
 * @generated
 */
public interface BgMemModel extends BaseModel<BgMem> {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a bg mem model instance should use the {@link BgMem} interface instead.
	 */

	/**
	 * Returns the primary key of this bg mem.
	 *
	 * @return the primary key of this bg mem
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this bg mem.
	 *
	 * @param primaryKey the primary key of this bg mem
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the bg mem ID of this bg mem.
	 *
	 * @return the bg mem ID of this bg mem
	 */
	public long getBgMemId();

	/**
	 * Sets the bg mem ID of this bg mem.
	 *
	 * @param bgMemId the bg mem ID of this bg mem
	 */
	public void setBgMemId(long bgMemId);

	/**
	 * Returns the owner ID of this bg mem.
	 *
	 * @return the owner ID of this bg mem
	 */
	public long getOwnerId();

	/**
	 * Sets the owner ID of this bg mem.
	 *
	 * @param ownerId the owner ID of this bg mem
	 */
	public void setOwnerId(long ownerId);

	/**
	 * Returns the box gp ID of this bg mem.
	 *
	 * @return the box gp ID of this bg mem
	 */
	public long getBoxGpId();

	/**
	 * Sets the box gp ID of this bg mem.
	 *
	 * @param boxGpId the box gp ID of this bg mem
	 */
	public void setBoxGpId(long boxGpId);

	/**
	 * Returns the medium text of this bg mem.
	 *
	 * @return the medium text of this bg mem
	 */
	@AutoEscape
	public String getMediumText();

	/**
	 * Sets the medium text of this bg mem.
	 *
	 * @param mediumText the medium text of this bg mem
	 */
	public void setMediumText(String mediumText);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(gov.va.caret.model.BgMem bgMem);

	@Override
	public int hashCode();

	@Override
	public CacheModel<gov.va.caret.model.BgMem> toCacheModel();

	@Override
	public gov.va.caret.model.BgMem toEscapedModel();

	@Override
	public gov.va.caret.model.BgMem toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();
}