package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.ClpSerializer;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.HashMap;
import java.util.Map;


public class BgLaeClp extends BaseModelImpl<BgLae> implements BgLae {
    private long _bgLaeId;
    private long _ownerId;
    private long _boxGpId;
    private String _largeText;
    private BaseModel<?> _bgLaeRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public BgLaeClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return BgLae.class;
    }

    @Override
    public String getModelClassName() {
        return BgLae.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _bgLaeId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setBgLaeId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _bgLaeId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("bgLaeId", getBgLaeId());
        attributes.put("ownerId", getOwnerId());
        attributes.put("boxGpId", getBoxGpId());
        attributes.put("largeText", getLargeText());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long bgLaeId = (Long) attributes.get("bgLaeId");

        if (bgLaeId != null) {
            setBgLaeId(bgLaeId);
        }

        Long ownerId = (Long) attributes.get("ownerId");

        if (ownerId != null) {
            setOwnerId(ownerId);
        }

        Long boxGpId = (Long) attributes.get("boxGpId");

        if (boxGpId != null) {
            setBoxGpId(boxGpId);
        }

        String largeText = (String) attributes.get("largeText");

        if (largeText != null) {
            setLargeText(largeText);
        }
    }

    @Override
    public long getBgLaeId() {
        return _bgLaeId;
    }

    @Override
    public void setBgLaeId(long bgLaeId) {
        _bgLaeId = bgLaeId;

        if (_bgLaeRemoteModel != null) {
            try {
                Class<?> clazz = _bgLaeRemoteModel.getClass();

                Method method = clazz.getMethod("setBgLaeId", long.class);

                method.invoke(_bgLaeRemoteModel, bgLaeId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getOwnerId() {
        return _ownerId;
    }

    @Override
    public void setOwnerId(long ownerId) {
        _ownerId = ownerId;

        if (_bgLaeRemoteModel != null) {
            try {
                Class<?> clazz = _bgLaeRemoteModel.getClass();

                Method method = clazz.getMethod("setOwnerId", long.class);

                method.invoke(_bgLaeRemoteModel, ownerId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getBoxGpId() {
        return _boxGpId;
    }

    @Override
    public void setBoxGpId(long boxGpId) {
        _boxGpId = boxGpId;

        if (_bgLaeRemoteModel != null) {
            try {
                Class<?> clazz = _bgLaeRemoteModel.getClass();

                Method method = clazz.getMethod("setBoxGpId", long.class);

                method.invoke(_bgLaeRemoteModel, boxGpId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getLargeText() {
        return _largeText;
    }

    @Override
    public void setLargeText(String largeText) {
        _largeText = largeText;

        if (_bgLaeRemoteModel != null) {
            try {
                Class<?> clazz = _bgLaeRemoteModel.getClass();

                Method method = clazz.getMethod("setLargeText", String.class);

                method.invoke(_bgLaeRemoteModel, largeText);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getBgLaeRemoteModel() {
        return _bgLaeRemoteModel;
    }

    public void setBgLaeRemoteModel(BaseModel<?> bgLaeRemoteModel) {
        _bgLaeRemoteModel = bgLaeRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _bgLaeRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_bgLaeRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            BgLaeLocalServiceUtil.addBgLae(this);
        } else {
            BgLaeLocalServiceUtil.updateBgLae(this);
        }
    }

    @Override
    public BgLae toEscapedModel() {
        return (BgLae) ProxyUtil.newProxyInstance(BgLae.class.getClassLoader(),
            new Class[] { BgLae.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        BgLaeClp clone = new BgLaeClp();

        clone.setBgLaeId(getBgLaeId());
        clone.setOwnerId(getOwnerId());
        clone.setBoxGpId(getBoxGpId());
        clone.setLargeText(getLargeText());

        return clone;
    }

    @Override
    public int compareTo(BgLae bgLae) {
        long primaryKey = bgLae.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof BgLaeClp)) {
            return false;
        }

        BgLaeClp bgLae = (BgLaeClp) obj;

        long primaryKey = bgLae.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{bgLaeId=");
        sb.append(getBgLaeId());
        sb.append(", ownerId=");
        sb.append(getOwnerId());
        sb.append(", boxGpId=");
        sb.append(getBoxGpId());
        sb.append(", largeText=");
        sb.append(getLargeText());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(16);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.BgLae");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>bgLaeId</column-name><column-value><![CDATA[");
        sb.append(getBgLaeId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>ownerId</column-name><column-value><![CDATA[");
        sb.append(getOwnerId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>boxGpId</column-name><column-value><![CDATA[");
        sb.append(getBoxGpId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>largeText</column-name><column-value><![CDATA[");
        sb.append(getLargeText());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
