package gov.va.caret.model;

import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the BgAsn service. Represents a row in the &quot;CARET_BOXED_GROUP_BOOL&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.BgAsnModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.BgAsnImpl}.
 * </p>
 *
 * @author caret
 * @see BgAsn
 * @see gov.va.caret.model.impl.BgAsnImpl
 * @see gov.va.caret.model.impl.BgAsnModelImpl
 * @generated
 */
public interface BgAsnModel extends BaseModel<BgAsn> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a bg asn model instance should use the {@link BgAsn} interface instead.
     */

    /**
     * Returns the primary key of this bg asn.
     *
     * @return the primary key of this bg asn
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this bg asn.
     *
     * @param primaryKey the primary key of this bg asn
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the bg asn ID of this bg asn.
     *
     * @return the bg asn ID of this bg asn
     */
    public long getBgAsnId();

    /**
     * Sets the bg asn ID of this bg asn.
     *
     * @param bgAsnId the bg asn ID of this bg asn
     */
    public void setBgAsnId(long bgAsnId);

    /**
     * Returns the owner ID of this bg asn.
     *
     * @return the owner ID of this bg asn
     */
    public long getOwnerId();

    /**
     * Sets the owner ID of this bg asn.
     *
     * @param ownerId the owner ID of this bg asn
     */
    public void setOwnerId(long ownerId);

    /**
     * Returns the box gp ID of this bg asn.
     *
     * @return the box gp ID of this bg asn
     */
    public long getBoxGpId();

    /**
     * Sets the box gp ID of this bg asn.
     *
     * @param boxGpId the box gp ID of this bg asn
     */
    public void setBoxGpId(long boxGpId);

    /**
     * Returns the selected of this bg asn.
     *
     * @return the selected of this bg asn
     */
    public boolean getSelected();

    /**
     * Returns <code>true</code> if this bg asn is selected.
     *
     * @return <code>true</code> if this bg asn is selected; <code>false</code> otherwise
     */
    public boolean isSelected();

    /**
     * Sets whether this bg asn is selected.
     *
     * @param selected the selected of this bg asn
     */
    public void setSelected(boolean selected);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.BgAsn bgAsn);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.BgAsn> toCacheModel();

    @Override
    public gov.va.caret.model.BgAsn toEscapedModel();

    @Override
    public gov.va.caret.model.BgAsn toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
