package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.BgAsnLocalServiceUtil;
import gov.va.caret.service.ClpSerializer;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.HashMap;
import java.util.Map;


public class BgAsnClp extends BaseModelImpl<BgAsn> implements BgAsn {
    private long _bgAsnId;
    private long _ownerId;
    private long _boxGpId;
    private boolean _selected;
    private BaseModel<?> _bgAsnRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public BgAsnClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return BgAsn.class;
    }

    @Override
    public String getModelClassName() {
        return BgAsn.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _bgAsnId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setBgAsnId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _bgAsnId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("bgAsnId", getBgAsnId());
        attributes.put("ownerId", getOwnerId());
        attributes.put("boxGpId", getBoxGpId());
        attributes.put("selected", getSelected());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long bgAsnId = (Long) attributes.get("bgAsnId");

        if (bgAsnId != null) {
            setBgAsnId(bgAsnId);
        }

        Long ownerId = (Long) attributes.get("ownerId");

        if (ownerId != null) {
            setOwnerId(ownerId);
        }

        Long boxGpId = (Long) attributes.get("boxGpId");

        if (boxGpId != null) {
            setBoxGpId(boxGpId);
        }

        Boolean selected = (Boolean) attributes.get("selected");

        if (selected != null) {
            setSelected(selected);
        }
    }

    @Override
    public long getBgAsnId() {
        return _bgAsnId;
    }

    @Override
    public void setBgAsnId(long bgAsnId) {
        _bgAsnId = bgAsnId;

        if (_bgAsnRemoteModel != null) {
            try {
                Class<?> clazz = _bgAsnRemoteModel.getClass();

                Method method = clazz.getMethod("setBgAsnId", long.class);

                method.invoke(_bgAsnRemoteModel, bgAsnId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getOwnerId() {
        return _ownerId;
    }

    @Override
    public void setOwnerId(long ownerId) {
        _ownerId = ownerId;

        if (_bgAsnRemoteModel != null) {
            try {
                Class<?> clazz = _bgAsnRemoteModel.getClass();

                Method method = clazz.getMethod("setOwnerId", long.class);

                method.invoke(_bgAsnRemoteModel, ownerId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getBoxGpId() {
        return _boxGpId;
    }

    @Override
    public void setBoxGpId(long boxGpId) {
        _boxGpId = boxGpId;

        if (_bgAsnRemoteModel != null) {
            try {
                Class<?> clazz = _bgAsnRemoteModel.getClass();

                Method method = clazz.getMethod("setBoxGpId", long.class);

                method.invoke(_bgAsnRemoteModel, boxGpId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getSelected() {
        return _selected;
    }

    @Override
    public boolean isSelected() {
        return _selected;
    }

    @Override
    public void setSelected(boolean selected) {
        _selected = selected;

        if (_bgAsnRemoteModel != null) {
            try {
                Class<?> clazz = _bgAsnRemoteModel.getClass();

                Method method = clazz.getMethod("setSelected", boolean.class);

                method.invoke(_bgAsnRemoteModel, selected);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getBgAsnRemoteModel() {
        return _bgAsnRemoteModel;
    }

    public void setBgAsnRemoteModel(BaseModel<?> bgAsnRemoteModel) {
        _bgAsnRemoteModel = bgAsnRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _bgAsnRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_bgAsnRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            BgAsnLocalServiceUtil.addBgAsn(this);
        } else {
            BgAsnLocalServiceUtil.updateBgAsn(this);
        }
    }

    @Override
    public BgAsn toEscapedModel() {
        return (BgAsn) ProxyUtil.newProxyInstance(BgAsn.class.getClassLoader(),
            new Class[] { BgAsn.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        BgAsnClp clone = new BgAsnClp();

        clone.setBgAsnId(getBgAsnId());
        clone.setOwnerId(getOwnerId());
        clone.setBoxGpId(getBoxGpId());
        clone.setSelected(getSelected());

        return clone;
    }

    @Override
    public int compareTo(BgAsn bgAsn) {
        long primaryKey = bgAsn.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof BgAsnClp)) {
            return false;
        }

        BgAsnClp bgAsn = (BgAsnClp) obj;

        long primaryKey = bgAsn.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{bgAsnId=");
        sb.append(getBgAsnId());
        sb.append(", ownerId=");
        sb.append(getOwnerId());
        sb.append(", boxGpId=");
        sb.append(getBoxGpId());
        sb.append(", selected=");
        sb.append(getSelected());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(16);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.BgAsn");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>bgAsnId</column-name><column-value><![CDATA[");
        sb.append(getBgAsnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>ownerId</column-name><column-value><![CDATA[");
        sb.append(getOwnerId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>boxGpId</column-name><column-value><![CDATA[");
        sb.append(getBoxGpId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>selected</column-name><column-value><![CDATA[");
        sb.append(getSelected());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
