unit fPtSelDemog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ORCtrls, fBase508Form, VA508AccessibilityManager;

type
  TfrmPtSelDemog = class(TfrmBase508Form)
    stxSSN: TStaticText;
    lblPtSSN: TStaticText;
    stxDOB: TStaticText;
    lblPtDOB: TStaticText;
    lblPtSex: TStaticText;
    lblPtVet: TStaticText;
    lblPtSC: TStaticText;
    stxLocation: TStaticText;
    lblPtRoomBed: TStaticText;
    lblPtLocation: TStaticText;
    stxRoomBed: TStaticText;
    lblPtName: TStaticText;
    Memo: TCaptionMemo;
    lblCombatVet: TStaticText;
    pnlMain: TPanel;
    pnlMainMiddle: TPanel;
    stxVeteran: TStaticText;
    stxSexAge: TStaticText;
    stxSC: TStaticText;
    stxSIGI: TStaticText;
    lblPtSigi: TStaticText;
    gPanel: TGridPanel;
    lblVeteran: TStaticText;
    stxPrimaryProvider: TStaticText;
    stxPtPrimaryProvider: TStaticText;
    stxInpatientProvider: TStaticText;
    stxPtInpatientProvider: TStaticText;
    stxLastVisitLocation: TStaticText;
    stxPtLastVisitLocation: TStaticText;
    stxLastVisitDate: TStaticText;
    stxPtLastVisitDate: TStaticText;
    procedure FormShow(Sender: TObject);
    procedure MemoEnter(Sender: TObject);
    procedure MemoKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
  private
    FLastDFN: string;
  public
    procedure ClearIDInfo;
    procedure ShowDemog(ItemID: string);
    procedure ToggleMemo;
  end;

var
  frmPtSelDemog: TfrmPtSelDemog;

implementation

uses rCore, VA508AccessibilityRouter, uCombatVet, ORFn;

{$R *.DFM}

const
{ constants referencing the value of the tag property in components }
  UNKNOWN      = 'unknown'; // ...?';

procedure TfrmPtSelDemog.ClearIDInfo;
begin
  FLastDFN := '';
  Memo.Clear;
  lblCombatVet.Caption := '';
  lblPtName.Caption := 'No patient selected';

  lblPtSSN.Caption := '';
  lblPtDOB.Caption := '';
  lblPtSex.Caption := '';
  lblPtSigi.Caption := '';
  lblPtVet.Caption := '';
  lblPtSC.Caption := '';
  lblPtLocation.Caption := '';
  lblPtRoomBed.Caption := '';
  stxPtPrimaryProvider.Caption:= '';
  stxPtInpatientProvider.Caption:= '';
  stxPtLastVisitLocation.Caption:= '';
  stxPtLastVisitDate.Caption:= '';

end;

procedure TfrmPtSelDemog.ShowDemog(ItemID: string);
{ gets a record of patient indentifying information from the server and displays it }
var
  PtRec: TPtIDInfo;
  CV : TCombatVet;

  function rowByControl(aControl:TControl):Integer;
  var
    cc: TCollectionItem;
  begin
    Result := -1;
    for cc in gPanel.ControlCollection do
      if TControlItem(cc).Control = aControl then
        begin
          Result := TControlItem(cc).Row;
          break;
        end;
  end;

  procedure setLabels(aName,aValue:TStaticText;aText:String;aHide:Boolean = false);
  var
    i: integer;
  begin
    if aText = '' then
      aValue.Caption := UNKNOWN
    else
      aValue.Caption := aText;

    if aHide then
      begin
        aName.Visible := aText <> '';
        aValue.Visible := aText <> '';
      end;

    i := rowByControl(aName);

    if aName.Visible then
      begin
        Memo.Lines.Add(aName.Caption + '  ' + aValue.Caption + '.');
        if i > -1 then
          gPanel.RowCollection[i].Value := 21;
      end
    else
      begin
        if i > -1 then
          gPanel.RowCollection[i].Value := 0;
      end;
  end;

begin
  if ItemID = FLastDFN then Exit;

  Memo.Clear;

  gPanel.Visible := false;

  FLastDFN := ItemID;
  PtRec := GetPtIDInfo(ItemID);
  with PtRec do
  begin
    Memo.Lines.Add(PtRec.Name);
    lblPtName.Caption     := Name;

    setLabels(stxSSN,lblPtSSN,SSN);
    setLabels(stxDOB,lblPtDOB,DOB);
    setLabels(stxSexAge,lblPtSex,Sex);
    setLabels(stxSIGI,lblPtSigi,piece(SIGI,'/',1),true); // AA NSR#20130305
    setLabels(stxSC,lblPtSC,SCSts, true);
    setLabels(stxLocation,lblPtLocation,Location,true);
    setLabels(stxRoomBed,lblPtRoomBed,RoomBed,true);
    SetLabels(stxPrimaryProvider, stxPtPrimaryProvider, PrimaryCareProvider, true);
    SetLabels(stxInpatientProvider, stxPtInpatientProvider, PrimaryInpatientProvider, true);
    SetLabels(stxLastVisitLocation, stxPtLastVisitLocation, LastVisitLocation, true);
    SetLabels(stxLastVisitDate, stxPtLastVisitDate, LastVisitDate, true);

    if Vet = 'Veteran' then
      setLabels(stxVeteran,lblPtVet,'Yes')
    else
      setLabels(stxVeteran,lblPtVet,'',true);
  end;

  CV := TCombatVet.Create(ItemID);
  if CV.IsEligible then begin
    lblCombatVet.Caption := CV.ExpirationDate + ' ' + CV.OEF_OIF;
  end else
    lblCombatVet.Caption := '';
  CV.Free;

  SetLabels(lblVeteran,lblCombatVet,lblCombatVet.Caption,true);

  gPanel.Visible := True;

//  Memo.SelectAll;

  if ScreenReaderSystemActive then
  begin
    Memo.SelStart := 0;
    GetScreenReader.Speak('Selected Patient Demographics');
    GetScreenReader.Speak(Memo.Text);
  end;
end;

procedure TfrmPtSelDemog.ToggleMemo;
{ toggle Memo visibility }
begin
  if Memo.Visible then
  begin
    Memo.Hide;
  end
  else
  begin
    Memo.Show;
    Memo.BringToFront;
  end;
end;

procedure TfrmPtSelDemog.FormCreate(Sender: TObject);
begin
  inherited;
  Hide;
end;

procedure TfrmPtSelDemog.FormShow(Sender: TObject);
var
  i: Integer;
begin
  inherited;
  lblCombatVet.Caption := '';
  i := self.Canvas.TextWidth('Combat Vet:')+16;
  gPanel.ColumnCollection[0].Value := i
end;

procedure TfrmPtSelDemog.MemoEnter(Sender: TObject);
/// reads the Memo contents if the Screenreader is active
///
begin
  inherited;
  if ScreenReaderSystemActive then
  begin
    Memo.SelStart := 0;
    GetScreenReader.Speak('Selected Patient Demographics');
    GetScreenReader.Speak(Memo.Text);
  end;
end;

procedure TfrmPtSelDemog.MemoKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
/// notifies on position in the Memo if the Screenreader is active
begin
  inherited;
  if ScreenReaderSystemActive then
  begin
    if Memo.SelStart = Memo.GetTextLen then
      if ((Key = VK_DOWN) or (Key = VK_RIGHT)) then GetScreenReader.Speak('End of Data');
    if Memo.SelStart = 0 then
      if ((Key = VK_UP) or (Key = VK_LEFT)) then GetScreenReader.Speak('Start of Data')
  end;
end;

initialization
  SpecifyFormIsNotADialog(TfrmPtSelDemog);

end.
