unit fODAnatPathPreview;

// Developer: Theodore Fontana
// 02/24/17

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Forms, Vcl.Controls, Vcl.StdCtrls, Vcl.ComCtrls,
  Vcl.ExtCtrls, Vcl.Graphics, Vcl.Menus, Vcl.CheckLst, Vcl.Buttons, ORCtrls,
  fODBase, VA508AccessibilityManager;

type
  TfrmAnatPathPreview = class(TForm)
    VA508AccessibilityManager: TVA508AccessibilityManager;
    lvwSpecimen: TListView;
    memText: TCaptionMemo;
    pnlBottom: TPanel;
    btnAccept: TBitBtn;
    btnBack: TBitBtn;
    pnlSummary: TPanel;
    procedure FormCreate(Sender: TObject);
    procedure btnBackClick(Sender: TObject);
  private
  public
  end;

var
  frmAnatPathPreview: TfrmAnatPathPreview;

implementation

{$R *.dfm}

uses
  fODAnatPath, mODAnatPathBuilder, mODAnatpathSpecimen;

procedure TfrmAnatPathPreview.FormCreate(Sender: TObject);
var
  I: Integer;
  LabSpecimen: TLabSpecimen;
  lvwItem: TListItem;
  sOrderComment: string;
  sl,hl: TStringList;
begin
  pnlSummary.Caption := frmODAnatPath.GetSummary;

  if ALabTest <> nil then
    for I := 0 to ALabTest.LabSpecimenList.Count - 1 do
    begin
      LabSpecimen := ALabTest.LabSpecimenList.Items[I];
      lvwItem := lvwSpecimen.Items.Add;
      lvwItem.Caption := IntToStr(I + 1);
      lvwItem.SubItems.Add(LabSpecimen.SpecimenExternal);
      lvwItem.SubItems.Add(LabSpecimen.SpecimenDescription);
      lvwItem.SubItems.Add(LabSpecimen.CollectionSampleExternal);
    end;

  sOrderComment := frmODAnatPath.GetOrderComment;
  if sOrderComment <> '' then
  begin
    memText.Lines.Add('Order Comment');
    memText.Lines.Add('--------------------------------------------------------------------------');
    memText.Lines.Add(sOrderComment);
    memText.Lines.Add('');
  end;

  sl := TStringList.Create;
  try
    hl := TStringList.Create;
    try
      if ALabTest <> nil then
        for I := 0 to ALabTest.LabTextList.Count - 1 do
        begin
          ALabTest.LabTextList.Items[I].GetText(sl);
          if sl.Count > 0 then
          begin
            ALabTest.LabTextList.Items[I].GetHeader(hl);
            memText.Lines.AddStrings(hl);
            memText.Lines.AddStrings(sl);
            memText.Lines.Add('');
          end;
        end;
    finally
      hl.Free;
    end;
  finally
    sl.Free;
  end;
end;

procedure TfrmAnatPathPreview.btnBackClick(Sender: TObject);
begin
  Close;
end;

end.
