﻿//*********************************************************************************************************************
// ParseParameter - Helper Class Code
// Created By: Allen Barge - MCS Enterprise Services CRM (SL5)
// Date: 10/7/2011
// Version: 1.0.0
// Organization: Microsoft Corporation
//
// This class will help parse common parameters passed to it. As I create or adopted varios formats I will
// add thier support to this class.
// 
// Add this library to your project as a reference
// Wnen creating an instance of the class Arguments pass in the string[] argument object captured
// in the main program. If you pass in null it will return null.
// Your parameter needs to be in the format of /<Key>:<Value>
// No spaces in the <key> are allowed
// If you have spaces in the <value> you must enclose them in either "" or ''
// To get your parameters and values that were parsed you should access the <public StringDictionary Parameters> object
//
// Source code is provided as unsupported and resricted to use by employees of Microsoft Corporation
//*********************************************************************************************************************
using System.Collections.Specialized;
using System.Text.RegularExpressions;

namespace Microsoft.MCS.ParseParameter
{
    public class Arguments
    {
        // Valid parameters forms:
        // {-,/,--}param{ ,=,:}((",')value(",'))
        // Examples: 
        // -param value --param /param:"Test-:-work" 
        //  /param=happy -param '--=nice=--'

        // Class Variables
        public StringDictionary Parameters;

        // Constructor
        public Arguments(string[] Args)
        {
            Parameters = new StringDictionary();
            Regex Spliter = new Regex(@"^-{1,2}|^/|=|:",
                RegexOptions.IgnoreCase | RegexOptions.Compiled);

            Regex Remover = new Regex(@"^['""]?(.*?)['""]?$",
                RegexOptions.IgnoreCase | RegexOptions.Compiled);

            string Parameter = null;
            string[] Parts;


            foreach (string Txt in Args)
            {
                // Look for new parameters (-,/ or --) and a
                // possible enclosed value (=,:)
                Parts = Spliter.Split(Txt, 3);

                switch (Parts.Length)
                {
                    // Parameter exists so process it
                    case 1:
                        if (Parameter != null)
                        {
                            if (!Parameters.ContainsKey(Parameter))
                            {
                                Parts[0] =
                                    Remover.Replace(Parts[0], "$1");

                                Parameters.Add(Parameter, Parts[0]);
                            }
                            Parameter = null;
                        }
                        // else Error: no parameter waiting for a value (skipped)
                        break;

                    // Added support for a parameter that does not use a valu
                    case 2:
                         // Set the parameter value key pari to true as it does exist.
                        if (Parameter != null)
                        {
                            if (!Parameters.ContainsKey(Parameter))
                                Parameters.Add(Parameter, "true");
                        }
                        Parameter = Parts[1];
                        break;

                    // Suport for a Parameter with an enclosed value
                    case 3:
                        if (Parameter != null)
                        {
                            if (!Parameters.ContainsKey(Parameter))
                                Parameters.Add(Parameter, "true");
                        }

                        Parameter = Parts[1];

                        // Remove possible enclosing characters (",')

                        if (!Parameters.ContainsKey(Parameter))
                        {
                            Parts[2] = Remover.Replace(Parts[2], "$1");
                            Parameters.Add(Parameter, Parts[2]);
                        }

                        //Parameter = null;
                        break;
                }
            }

            // In case a space or eol character parameter is still waiting
            if (Parameter != null)
            {
                if (!Parameters.ContainsKey(Parameter))
                    Parameters.Add(Parameter, "true");
            }
        }

        // Retrieve a parameter value if it exists 
        // (overriding C# indexer property)
        public string this[string Param]
        {
            get
            {
                return (Parameters[Param]);
            }
        }
    }
}
