﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.ServiceModel;
using System.ServiceModel.Description;
using System.Diagnostics;

using Microsoft.Crm.Sdk;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Client;
using Microsoft.Xrm.Sdk.Discovery;
using Microsoft.Xrm.Sdk.Messages;
using Microsoft.Xrm.Sdk.Metadata;

using Microsoft.MCS.Logging;

namespace MCS.CRM.SchemaCompare
{
    class SchemaCompareProcessor
    {

        #region Entity
        /// <summary>
        /// 
        /// </summary>
        /// <param name="SourceOrganizationUri"></param>
        /// <param name="TargetOrganizationUri"></param>
        /// <returns></returns>
        public Boolean ValidateEntityDetails(OrganizationServiceProxy sourceServerConn, OrganizationServiceProxy targetServerConn, Logger LoggingConfig)
        {
            LoggingConfig.WriteLine("Validating Entity Detail Settings Information..........");
            LoggingConfig.BlankLine();

            // Set up the working return
            Boolean isValidateEntityDetails = true;

            // Create an entity validations object and preload the connection info
            Processors.EntityHelpers SourceEntity = new Processors.EntityHelpers(sourceServerConn, LoggingConfig);
            Processors.EntityHelpers TargetEntity = new Processors.EntityHelpers(targetServerConn, LoggingConfig);

            //// Get the entities list from the source and targets that will be used in the validation
            //LoggingConfig.WriteLine("Obtaining Entity List from Source Organization " + sourceServerConn..OrganizationName + "..........");
            List<EntityMetadata> semdid = SourceEntity.GetEntityEntityList();

            //LoggingConfig.WriteLine("Obtaining Entity List from Target Organization " + targetServerConfig.OrganizationName + "..........");
            List<EntityMetadata> temdid = TargetEntity.GetEntityEntityList();

            // Roll through the source get the associated Metadata ID from the target to use to get the EntityMetadata
            // then compare the detail of both.
            foreach (EntityMetadata SourceEmd in semdid)
            {
                EntityMetadata TargetEmd = temdid.Find(
                   delegate(EntityMetadata mdp)
                   {
                       return mdp.SchemaName == SourceEmd.SchemaName;
                   }
                   );

                if (TargetEmd != null)
                {
                    // go run the compare of the two entity metadata ojbects
                    if (!(SourceEntity.CompareEntityInformation(SourceEmd, TargetEmd, LoggingConfig) == true))
                    {
                        isValidateEntityDetails = false;
                        LoggingConfig.WriteLine("***** Entity comparison for source entity " + SourceEmd.SchemaName.ToString() + " Failed");
                    }
                    else
                    {
                        //LoggingConfig.WriteLine("Entity " + SourceEmd.SchemaName.ToString() + " was compared");
                    }
                }
                else
                {
                    isValidateEntityDetails = false;
                    LoggingConfig.WriteLine("*** Source Entity " + SourceEmd.SchemaName.ToString() + " Not Found in the Target Organization ");
                }
            }

            // Reverse the process to identify any missing entities
            foreach (EntityMetadata TargetEmd in temdid)
            {
                EntityMetadata SourceEmd = semdid.Find(
                   delegate(EntityMetadata mdp)
                   {
                       return mdp.SchemaName == TargetEmd.SchemaName;
                   }
                   );


                if (SourceEmd == null)
                {
                    isValidateEntityDetails = false;
                    LoggingConfig.WriteLine("***** Target Entity " + TargetEmd.SchemaName.ToString() + " Not Found in the Source Organization ");
                }
            }

            if (isValidateEntityDetails)
            {
                LoggingConfig.BlankLine();
                LoggingConfig.WriteLine("***** Entity Information Comparison PASSED *****");
                LoggingConfig.BlankLine();
            }
            else
            {
                LoggingConfig.BlankLine();
                LoggingConfig.WriteLine("***** Entity Information Comparison FAILED *****");
                LoggingConfig.BlankLine();
            }
            return isValidateEntityDetails;
        }



        #endregion Entity
    }
}
