﻿// **********************************************************************************************************
// Program.cs
// Microsoft MCS Enterprise Services
// Author: Allen Barge
// Date: 10/26/2011
// This is the main method class is designed to facilitate accessing components within the Entity
//
// This file also contains the following Classes
// OrgParameters - used to hold the user parameters passed in on execution of the console application
// MetaDataPair - used to hold a key value pair of Guid and string.
//
// Methods:
// Main - console startup method
// ValidateParameters - uses various checks to validate the paramters met the expected criteria
//
// Call this application by executing the CRMDiffingTool.exe with a minimum of two parameters
// -sc:<source connection string>
// -tc:<target connection string>
//
// Additional Parameters
// -su:<source user> if only the username is supplied must also supply a -sd parameter to supply the login domain.
// -tu:<target user> if only the username is supplied must also supply a -td parameter to supply the login domain.
// -sp:<source user password> Must be supplied if you supply an -su paramater
// -tp:<target user password> Must be supplied if you supply an -tu paramater
// -sd:<source user login domain> Must be supplied if the source user name does not contain the <domain\user> format
// -td:<target user login domain> Must be supplied if the target user name does not contain the <domain\user> format
//
// To add additional parameters code them as key/Value pairs -<key>:<value> as the format of the parameter where
// -<key> is the key and <value> is the value you wish to act on.
//
// Additionally make sure that you make changes to the ValidateParameters method to allow your parameters
// to pass the validation test as well as not to fail the validataion test with the presence of your parmaters.
// **********************************************************************************************************

using System;
using System.Runtime.Serialization;
using System.Configuration;
using System.ServiceModel;

using Microsoft.MCS.Logging;
using CRM2013OrgCompare.Helpers;

using Microsoft.Crm.Sdk.Messages;

using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;

using Microsoft.Xrm.Client;
using Microsoft.Xrm.Client.Services;

namespace Microsoft.MCS
{
    /// <summary>
    /// 
    /// </summary>
    class OrgParameters
    {
        // Store the connection strings with or without the user info.
        public string CrmConnectionString { get; set; }

        // Store the user credentials
        public string Domain { get; set; }
        public string User { get; set; }
        public string Password { get; set; }

        public enum CrmVersion
        {
            DynamicsCrm4,
            DynamicsCrm2011,
            DynamicsCrm2013
        };
        public CrmVersion ApplicationVersion { get; set; }
    }

    class MetaDataPair
    {
        public Guid MetaDataId { get; set; }
        public string SchemaName { get; set; }
    }
    /// <summary>
    /// 
    /// </summary>
    static class Program
    {
        private static OrganizationService SorgService;
        private static OrganizationService TorgService;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="args"></param>
        /// 
        static void Main(string[] args)
        {
            Environment.ExitCode = 0; // Start with the assumption that they will all pass so if any step failes set the exit code to -1 so the run fails.
            Logger tLog = new Logger();
            OrgParameters sorgParam = new OrgParameters();
            OrgParameters torgParam = new OrgParameters();
            ConnectionHelpers sourceConnHelper = new ConnectionHelpers();
            ConnectionHelpers targetConnHelper = new ConnectionHelpers();

            ParseParameter.Arguments param = new ParseParameter.Arguments(args);
            if (ValidateParameters(param) != true)
            {
                tLog.WriteLine("Invalid Parameters used in execution : Error Code 20");
                Environment.Exit(-20);
            }

            foreach (System.Collections.DictionaryEntry arg in param.Parameters)
            {

                switch (arg.Key.ToString())
                {
                    case "sc":
                        sorgParam.CrmConnectionString = arg.Value.ToString();
                        break;
                    case "tc":
                        torgParam.CrmConnectionString = arg.Value.ToString();
                        break;
                    case "su":
                        sorgParam.User = arg.Value.ToString();
                        break;
                    case "sp":
                        torgParam.User = arg.Value.ToString();
                        break;
                    case "sd":
                        sorgParam.Domain = arg.Value.ToString();
                        break;
                    case "tu":
                        torgParam.Domain = arg.Value.ToString();
                        break;
                    case "tp":
                        sorgParam.Password = arg.Value.ToString();
                        break;
                    case "td":
                        torgParam.Password = arg.Value.ToString();
                        break;
                }
            }

            var sCrmConn = CrmConnection.Parse(sorgParam.CrmConnectionString);
            var tCrmConn = CrmConnection.Parse(torgParam.CrmConnectionString);

            // Validate the organization information

            // Get a connection handle
            SorgService = sourceConnHelper.GetConnection(sCrmConn);
            TorgService = targetConnHelper.GetConnection(tCrmConn);

            RetrieveVersionRequest sversionRequest = new RetrieveVersionRequest();
            RetrieveVersionResponse sversionResponse =
                (RetrieveVersionResponse)SorgService.Execute(sversionRequest);
            Console.WriteLine("Microsoft Dynamics CRM version {0}.", sversionResponse.Version);

            RetrieveVersionRequest tversionRequest = new RetrieveVersionRequest();
            RetrieveVersionResponse tversionResponse =
                (RetrieveVersionResponse)TorgService.Execute(tversionRequest);
            Console.WriteLine("Microsoft Dynamics CRM version {0}.", tversionResponse.Version);




        }

        private static Boolean ValidateParameters(ParseParameter.Arguments param)
        {
            var sourceParameter = false;
            var targetParameter = false;
            // Stop the application if there were not any parameters passed in at all
            if (param.Parameters.Count <= 0)
            {
                return false;
            }

            // Stop the application if -s and -t were not both passed in
            foreach (System.Collections.DictionaryEntry args in param.Parameters)
            {
                // Check for invalid parameters. If you add a parameter make sure to put it in this switch as a case
                // Deadman switch (If it hits a value that is not a case the app will bail with exit code -1
                switch (args.Key.ToString())
                {
                    case "sc":
                        sourceParameter = true;
                        break;
                    case "tc":
                        targetParameter = true;
                        break;
                    case "su":
                        break;
                    case "sp":
                        break;
                    case "sd":
                        break;
                    case "tu":
                        break;
                    case "tp":
                        break;
                    case "td":
                        break;
                    default:
                        return false;
                }
            }

            // Validates that both the s and the t were passed in
            // Make sure that both an s and a t parameter were passed in
            if (!(sourceParameter && targetParameter))
            {
                return false;
            }

            //// In order to make sure that a user does not pass in more than one s or t parameter.
            //// This also mandates that they MUST pass in an s and a t parameter
            //// validate that only 1 s and 1 t parameters were passed in
            //if( sCount != 1 || tCount != 1 )
            //{
            //    return false;
            //}

            // passed all validation checks
            return true;
        }
    }
}
