﻿using System;
using System.Data;
using Microsoft.Xrm.Sdk.Metadata;
using CRM2011OrgCompare.Helpers;

namespace Microsoft.MCS
{
    class AttributeHelpers
    {
        ServerConnection.Configuration _serverConfig;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="ServerConfiguration"></param>
        public AttributeHelpers()
        {
        }
        
        /// <summary>
        /// 
        /// </summary>
        /// <param name="ServerConfiguration"></param>
        public AttributeHelpers(ServerConnection.Configuration ServerConfiguration)
        {
            _serverConfig = ServerConfiguration;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="EntityID"></param>
        /// <param name="ServerConfiguration"></param>
        /// <returns></returns>
        public DataTable GetAttributeListByMetaDataID(Guid EntityID, ServerConnection.Configuration ServerConfiguration)
        {
            _serverConfig = ServerConfiguration;
            return GetAttributeListByMetaDataID(EntityID, ServerConfiguration);
        }

        ///// <summary>
        ///// 
        ///// </summary>
        ///// <param name="EntityID"></param>
        ///// <returns></returns>
        //public DataTable GetAttributeListByMetaDataID(Guid EntityID)
        //{
        //    try
        //    {
        //        // Get the entity object with all the attributes
        //        EntityHelpers ent = new EntityHelpers(_serverConfig);
        //        EntityMetadata emd = ent.GetEntityAttributeDetail(EntityID);

        //        DataTable AttributeList = new DataTable("AttributeList");
        //        DataColumn dcAttributeID = new DataColumn("AttributeId");
        //        DataColumn dcAttributeName = new DataColumn("AttributeName");
        //        AttributeList.Columns.Add(dcAttributeID);
        //        AttributeList.Columns.Add(dcAttributeName);
        //        DataColumn[] pkAttributeID = new DataColumn[1];
        //        pkAttributeID[0] = dcAttributeID;
        //        AttributeList.PrimaryKey = pkAttributeID;

        //        foreach (AttributeMetadata amd in emd.Attributes)
        //        {
        //            DataRow dr = AttributeList.NewRow();

        //            dr["AttributeId"] = new Guid(amd.MetadataId.ToString());
        //            dr["AttributeName"] = amd.SchemaName;
        //        }

        //        return AttributeList;

        //    }
        //    catch (TimeoutException Timeex)
        //    {
        //        Console.WriteLine("Timeout Exception - " + Timeex.Message );
        //    }
        //    catch (FaultException<Microsoft.Xrm.Sdk.OrganizationServiceFault> Orgex)
        //    {
        //        Console.WriteLine("Organization Service Fault Exception - " + Orgex.Message);
        //    }
        //    catch (Exception ex)
        //    {
        //        Console.WriteLine("Entity Metadata Exception - " + ex.Message);
        //    }

        //    // If it gets here it has failed return a null entity metadata object
        //    return new DataTable();
        //}

        // TODO: need to put in validation for nulls here
        public Boolean CompareAttributes(AttributeMetadata SourceAttributeMetadata, AttributeMetadata TargetAttributeMetadata)
        {
            Boolean IsMatch = true;

            if (SourceAttributeMetadata != null && TargetAttributeMetadata != null)
            {
                if (SourceAttributeMetadata.AttributeOf != TargetAttributeMetadata.AttributeOf)
                    IsMatch = false;
                if (SourceAttributeMetadata.AttributeType.Value != TargetAttributeMetadata.AttributeType.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.CanBeSecuredForCreate.Value != TargetAttributeMetadata.CanBeSecuredForCreate.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.CanBeSecuredForRead.Value != TargetAttributeMetadata.CanBeSecuredForRead.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.CanBeSecuredForUpdate.Value != TargetAttributeMetadata.CanBeSecuredForUpdate.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.CanModifyAdditionalSettings.Value != TargetAttributeMetadata.CanModifyAdditionalSettings.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.ColumnNumber.Value != TargetAttributeMetadata.ColumnNumber.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.DeprecatedVersion != TargetAttributeMetadata.DeprecatedVersion)
                    IsMatch = false;
                if ((SourceAttributeMetadata.Description.UserLocalizedLabel != null && TargetAttributeMetadata.Description.UserLocalizedLabel != null) && SourceAttributeMetadata.Description.UserLocalizedLabel.Label.ToString() != TargetAttributeMetadata.Description.UserLocalizedLabel.Label.ToString())
                    IsMatch = false;
                if ((SourceAttributeMetadata.DisplayName.UserLocalizedLabel != null && TargetAttributeMetadata.DisplayName.UserLocalizedLabel != null) && SourceAttributeMetadata.DisplayName.UserLocalizedLabel.Label.ToString() != TargetAttributeMetadata.DisplayName.UserLocalizedLabel.Label.ToString())
                    IsMatch = false;
                if (SourceAttributeMetadata.EntityLogicalName != TargetAttributeMetadata.EntityLogicalName)
                    IsMatch = false;
                //if (SourceAttributeMetadata.ExtensionData != TargetAttributeMetadata.ExtensionData)
                //    IsMatch = false;
                if (SourceAttributeMetadata.IsAuditEnabled.Value != TargetAttributeMetadata.IsAuditEnabled.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.IsCustomAttribute.Value != TargetAttributeMetadata.IsCustomAttribute.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.IsCustomizable.Value != TargetAttributeMetadata.IsCustomizable.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.IsManaged.Value != TargetAttributeMetadata.IsManaged.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.IsPrimaryId.Value != TargetAttributeMetadata.IsPrimaryId.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.IsPrimaryName.Value != TargetAttributeMetadata.IsPrimaryName.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.IsRenameable.Value != TargetAttributeMetadata.IsRenameable.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.IsSecured.Value != TargetAttributeMetadata.IsSecured.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.IsValidForAdvancedFind.Value != TargetAttributeMetadata.IsValidForAdvancedFind.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.IsValidForCreate.Value != TargetAttributeMetadata.IsValidForCreate.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.IsValidForRead.Value != TargetAttributeMetadata.IsValidForRead.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.IsValidForUpdate.Value != TargetAttributeMetadata.IsValidForUpdate.Value)
                    IsMatch = false;
                if ((SourceAttributeMetadata.LinkedAttributeId != null && TargetAttributeMetadata.LinkedAttributeId != null) && SourceAttributeMetadata.LinkedAttributeId.Value != TargetAttributeMetadata.LinkedAttributeId.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.LogicalName != TargetAttributeMetadata.LogicalName)
                    IsMatch = false;
                if (SourceAttributeMetadata.MetadataId.Value != TargetAttributeMetadata.MetadataId.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.RequiredLevel.Value != TargetAttributeMetadata.RequiredLevel.Value)
                    IsMatch = false;
                if (SourceAttributeMetadata.SchemaName != TargetAttributeMetadata.SchemaName)
                    IsMatch = false;
            }
            else
            {
                if(!(SourceAttributeMetadata == null && TargetAttributeMetadata == null))
                    IsMatch = false;
            }


            return IsMatch;
        }
    }
}
