﻿// **********************************************************************************************************
// Microsoft MCS Enterprise Services
// Author: Allen Barge
// Date: 01/15/2013
// CmdLet: PublishAll-Customizations
// This is a Custom Cmdlet that will execute a publish all against the CRM organization supplied in the -OrganizationUri parameter
//
// No additional parameters over and above the base classes required parameters are necessary.
// 
// **********************************************************************************************************
using System;
using System.Management.Automation;
using System.Web.Services.Protocols;
using Microsoft.Crm.Sdk.Messages;

namespace Microsoft.MCS.Commandlets
{
    [Cmdlet(VerbsData.Publish, "CRMCustomizations")]

    public class PublishAllCRMCustomizations : CrmServiceCommand
    {
        protected override void ProcessRecord()
        {
            try
            {
                WriteVerbose("Publishing all customizations...");
                Service.Execute(new PublishAllXmlRequest());
            }
            catch (SoapException exception)
            {
                WriteVerbose("Publish All CRM Customizations Failed: " + GetErrorMessageFromSoapException(exception));
                throw new Exception(GetErrorMessageFromSoapException(exception));
            }
        }
    }
}


