﻿// Conditional compilation. dont want this on in production yet.
#define Debug
#if Debug

using System;
using System.IO;
using System.Collections.Generic;
using System.Management.Automation;
using System.Web.Services.Protocols;
using System.ServiceModel;
using System.Xml;

using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Sdk.Messages;

namespace Microsoft.MCS.Commandlets
{
    [Cmdlet("Load", "EntityRecords", SupportsShouldProcess = true)]

    public class LoadDataRecords : CrmServiceCommand
    {
        [Parameter(Mandatory = true, HelpMessage = "Provide the full path to the xml data file you wish to import. It must be well formed.")]
        public string DataFile { get; set; }

        protected override void ProcessRecord()
        {
            try
            {
                IOrganizationService os = _service;
                  
                WriteVerbose("Loading data records from XML file " + DataFile.ToString());

                // Load the data file and parse it into an entity
                List<Entity> eList = LoadMap(DataFile);

            }
            catch (SoapException exception)
            {
                throw new Exception(GetErrorMessageFromSoapException(exception));
            }
        }

        private List<Entity> LoadMap(string ConfigFilePath)
        {
            // Check to see if the file exists. If not return false
            if (!File.Exists(ConfigFilePath.ToString()))
            {
                return new List<Entity>();
            }

            // Create an XML reader for this file.
            using (XmlReader reader = XmlReader.Create(ConfigFilePath))
            {
                while (reader.Read())
                {
                    // Only detect start elements.
                    if (reader.IsStartElement())
                    {
                        // Get element name and switch on it.
                        switch (reader.Name)
                        {
                            case "Entity":
                                Console.WriteLine("Start an new <Entity> element.");
                                // Search for the attribute name on this current node.
                                string attribute = reader["name"];
                                if (attribute != null)
                                {
                                    Console.WriteLine("  Has attribute name: " + attribute);
                                }
                                break;
                            default:
                                // This is record data. Add it to the entity
                                if (reader.Read())
                                {
                                    Console.WriteLine("  Text node: " + reader.Value.Trim());
                                }
                                break;
                        }
                    }
                }

                return new List<Entity>();
            }
        }

    }
}
#endif