﻿using System;
using System.Text;
using Microsoft.Xrm.Sdk;
using System.ServiceModel;

namespace Btsss.Plugins.VIMT.ContactProfile.Runner
{
    internal class RetrieveContactRunner : ContactProfileBaseRunner
    {

        internal RetrieveContactRunner(IServiceProvider serviceProvider) : base(serviceProvider)
        {

        }

        public override string McsSettingsDebugField
        {
            get
            {
                return "btsss_debuguserprofile";
            }
        }

        public override Entity GetPrimaryEntity()
        {
            return PluginExecutionContext.InputParameters["Target"] as Entity;
        }

        public override Entity GetSecondaryEntity()
        {
            return PluginExecutionContext.InputParameters["Target"] as Entity;
        }

        public void Execute()
        {
            
            try
            {
                if (PluginExecutionContext.OutputParameters.ContainsKey("BusinessEntity"))
                {
                    Logger.WriteDebugMessage("Starting Retrieve Plugin Runner");
                    var businessEntity = PluginExecutionContext.OutputParameters["BusinessEntity"] as Entity;
                    Logger.WriteDebugMessage("Check Business Entity to see if it is null");

                    if (businessEntity != null)
                    {
                        Logger.WriteDebugMessage("Business Entity Is not Null");

                        UpdateBusinessEntity(businessEntity);
                    }
                }
            }
            catch (FaultException<OrganizationServiceFault> ex)
            {
                Logger.WriteToFile(ex.Message);
                throw new InvalidPluginExecutionException(McsSettings.getUnexpectedErrorMessage);
            }
            catch (InvalidOperationException ex)
            {
                throw new InvalidPluginExecutionException(ex.Message.ToString());
            }
            catch (Exception ex)
            {
                Logger.WriteToFile(ex.Message);
                throw new InvalidPluginExecutionException(McsSettings.getUnexpectedErrorMessage);
            }
        }

        private void LogAttributes(Entity businessEntity)
        {
            StringBuilder builder = new StringBuilder();
            foreach (var a in businessEntity.Attributes)
            {
                builder.Append(a.Key + ":::" + a.Value);
            }
            throw new InvalidPluginExecutionException(builder.ToString());
        }

    
    }
}
