﻿using MCSPlugins;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;
using System.Text;
using VRMRest;
using Btsss.Plugins.VIMT.ContactProfile.Messages;
using MCSUtilities2011;

namespace Btsss.Plugins.VIMT.ContactProfile.Runner
{
    abstract class ContactProfileBaseRunner : PluginRunner
    {
        MCSUtilities2011.LogSettings logSettings;
        protected ContactProfileBaseRunner(IServiceProvider serviceProvider) : base(serviceProvider)
        {
            logSettings = new MCSUtilities2011.LogSettings()
            {                 
                 Org = this.PluginExecutionContext.OrganizationName,
                 UserId=this.PluginExecutionContext.UserId,
                 ConfigFieldName = "btsss_debuguserprofile"
            };
        }

        internal void UpdateBusinessEntity(Entity businessEntity)
        {
            if (businessEntity != null)
            {
                if (businessEntity.Attributes.ContainsKey("btsss_icn"))
                {
                    MCSUtilities2011.UtilityFunctions mcUtil = new MCSUtilities2011.UtilityFunctions();
                    mcUtil.setService = OrganizationService;

                    base.Logger.WriteDebugMessage("Business Entity Contains a btsss_icn");

                    LoadVeteranProfileRequest request = new LoadVeteranProfileRequest()
                    {
                        OrganizationName = base.PluginExecutionContext.OrganizationName,
                        UserId = this.PluginExecutionContext.UserId
                    };

                    Entity User = OrganizationService.Retrieve("systemuser", this.PluginExecutionContext.UserId, new ColumnSet(new string[] { "firstname", "lastname" }));

                    if (User != null)
                    {
                        if (User.Attributes.Contains("firstname") && User.Attributes["firstname"] != null)
                        {
                            request.UserFirstName = User.Attributes["firstname"].ToString();
                        }
                        if (User.Attributes.Contains("lastname") && User.Attributes["lastname"] != null)
                        {
                            request.UserLastName = User.Attributes["lastname"].ToString();
                        }
                    }

                    //TODO: Hard coded for now but once worked out with MVI can be either config or pulled from vet records...Not sure if requried yet.
                    request.AssigningAuthority = "OID";
                    request.AssigningFacility = "317";

                    if (businessEntity.Attributes.Contains("btsss_icn") && businessEntity.Attributes["btsss_icn"] != null)
                        request.VeteranIdentifier = businessEntity["btsss_icn"].ToString();
                    if(businessEntity.Attributes.Contains("btsss_identifiertype") && businessEntity.Attributes["btsss_identifiertype"] != null)
                        request.VeteranIdentifierType = mcUtil.getOptionSetString(((OptionSetValue)businessEntity["btsss_identifiertype"]).Value,"contact", "btsss_identifiertype");

                    request.MessageId = Guid.NewGuid();

                    var vimtEndPoint = this.McsSettings.GetSingleSetting("btsss_vimtendpoint", "string");


                    // Go Get the data from VIMT for the respective message
                    var response = VRMRest.Utility.SendReceive<Messages.LoadVeteranProfileResponse>(new Uri(vimtEndPoint), MessageRegistry.LoadVeteranProfileRequest, request, new VRMRest.LogSettings());


                    if (response != null)
                    {
                        // TODO: need to make changes to accomodate an optionset for customertypecode Is Veteran or Is Caregiver or Both...
                        // if an MVI record is found then at a minimum he will be a vet however if he is both we will not know base on a record
                        // in MVI that he is both. So have to give that one some thought...

                        if (!string.IsNullOrEmpty(response.NamePrefix))
                        {
                            if (businessEntity.Attributes.Contains("salutation"))
                            {
                                SetValue(businessEntity, "salutation", response.NamePrefix);
                            }
                            else
                            {
                                businessEntity.Attributes.Add("salutation", response.NamePrefix);
                            }
                        }

                        if (!string.IsNullOrEmpty(response.NameSuffix))
                        {
                            if (businessEntity.Attributes.Contains("suffix"))
                            {
                                SetValue(businessEntity, "suffix", response.NameSuffix);
                            }
                            else
                            {
                                businessEntity.Attributes.Add("suffix", response.NameSuffix);
                            }
                        }

                        if (!string.IsNullOrEmpty(response.FullName))
                        {
                            if (businessEntity.Attributes.Contains("fullname"))
                            {
                                SetValue(businessEntity, "fullname", response.FullName);
                            }
                            else
                            {
                                businessEntity.Attributes.Add("fullname", response.FullName);
                            }
                        }

                        if (!string.IsNullOrEmpty(response.FirstName))
                        {
                            if (businessEntity.Attributes.Contains("firstname"))
                            {
                                SetValue(businessEntity, "firstname", response.FirstName);
                            }
                            else
                            {
                                businessEntity.Attributes.Add("firstname", response.FirstName);
                            }
                        }

                        if (!string.IsNullOrEmpty(response.MiddleName))
                        {
                            if (businessEntity.Attributes.Contains("middlename"))
                            {
                                SetValue(businessEntity, "middlename", response.MiddleName);
                            }
                            else
                            {
                                businessEntity.Attributes.Add("middlename", response.MiddleName);
                            }
                        }

                        if (!string.IsNullOrEmpty(response.LastName))
                        {
                            if (businessEntity.Attributes.Contains("lastname"))
                            {
                                SetValue(businessEntity, "lastname", response.LastName);
                            }
                            else
                            {
                                businessEntity.Attributes.Add("lastname", response.LastName);
                            }
                        }

                        if (!string.IsNullOrEmpty(response.MaskedSocial))
                        {
                            if (businessEntity.Attributes.Contains("btsss_maskedsocial"))
                            {
                                SetValue(businessEntity, "btsss_maskedsocial", response.MaskedSocial);
                            }
                            else
                            {
                                businessEntity.Attributes.Add("btsss_maskedsocial", response.MaskedSocial);
                            }
                        }

                        if (!string.IsNullOrEmpty(response.PhoneNumber))
                        {
                            if (businessEntity.Attributes.Contains("telephone2"))
                            {
                                SetValue(businessEntity, "telephone2", response.PhoneNumber);
                            }
                            else
                            {
                                businessEntity.Attributes.Add("telephone2", response.PhoneNumber);
                            }
                        }

                        if (response.DateOfBirth != null)
                        {
                            if (businessEntity.Attributes.Contains("birthdate"))
                            {
                                SetValue(businessEntity, "birthdate", (DateTime)response.DateOfBirth);
                            }
                            else
                            {
                                businessEntity.Attributes.Add("birthdate", (DateTime)response.DateOfBirth);
                            }
                        }

                        // Booleans are Never null
                        if (businessEntity.Attributes.Contains("btsss_isdeceased"))
                        {                                // if it is a valid code then use it otherwise default to not specified
                            SetValue(businessEntity, "btsss_isdeceased", response.IsDeceased);
                        }
                        else
                        {
                            SetValue(businessEntity, "btsss_isdeceased", false);
                        }

                        if (response.DeceasedDate != null)
                        {
                            if (businessEntity.Attributes.Contains("btsss_deceaseddate"))
                            {
                                SetValue(businessEntity, "btsss_deceaseddate", response.DeceasedDate);
                            }
                            else
                            {
                                businessEntity.Attributes.Add("btsss_deceaseddate", response.DeceasedDate);
                            }
                        }

                        if (response.PrimaryAddress != null)
                        {
                            if (businessEntity.Attributes.Contains("address1_composite"))
                            {
                                SetValue(businessEntity, "address1_composite", GetCompositeAddress(response.PrimaryAddress));
                            }
                            else
                            {
                                businessEntity.Attributes.Add("address1_composite", GetCompositeAddress(response.PrimaryAddress));
                            }

                            if (!string.IsNullOrEmpty(response.PrimaryAddress.Line1))
                            {
                                if (businessEntity.Attributes.Contains("address1_line1"))
                                {
                                    SetValue(businessEntity, "address1_line1", response.PrimaryAddress.Line1);
                                }
                                else
                                {
                                    businessEntity.Attributes.Add("address1_line1", response.PrimaryAddress.Line1);
                                }
                            }
                            if (!string.IsNullOrEmpty(response.PrimaryAddress.Line2))
                            {
                                if (businessEntity.Attributes.Contains("address1_line2"))
                                {
                                    SetValue(businessEntity, "address1_line2", response.PrimaryAddress.Line2);
                                }
                                else
                                {
                                    businessEntity.Attributes.Add("address1_line2", response.PrimaryAddress.Line2);
                                }
                            }
                            if (!string.IsNullOrEmpty(response.PrimaryAddress.City))
                            {
                                if (businessEntity.Attributes.Contains("address1_city"))
                                {
                                    SetValue(businessEntity, "address1_city", response.PrimaryAddress.City);
                                }
                                else
                                {
                                    businessEntity.Attributes.Add("address1_city", response.PrimaryAddress.City);
                                }
                            }
                            if (!string.IsNullOrEmpty(response.PrimaryAddress.State))
                            {
                                if (businessEntity.Attributes.Contains("address1_stateorprovince"))
                                {
                                    SetValue(businessEntity, "address1_stateorprovince", response.PrimaryAddress.State);
                                }
                                else
                                {
                                    businessEntity.Attributes.Add("address1_stateorprovince", response.PrimaryAddress.State);
                                }
                            }
                            if (!string.IsNullOrEmpty(response.PrimaryAddress.Zip))
                            {
                                if (businessEntity.Attributes.Contains("address1_postalcode"))
                                {
                                    SetValue(businessEntity, "address1_postalcode", response.PrimaryAddress.Zip);
                                }
                                else
                                {
                                    businessEntity.Attributes.Add("address1_postalcode", response.PrimaryAddress.Zip);
                                }
                            }
                            if (!string.IsNullOrEmpty(response.PrimaryAddress.Country))
                            {
                                if (businessEntity.Attributes.Contains("address1_country"))
                                {
                                    SetValue(businessEntity, "address1_country", response.PrimaryAddress.Country);
                                }
                                else
                                {
                                    businessEntity.Attributes.Add("address1_country", response.PrimaryAddress.Country);
                                }
                            }

                            switch(response.PrimaryAddress.Use.ToString())
                            {
                                case "":
                                    break;
                            }
                        }

                        if (response.TemporaryAddress != null)
                        {
                            if (businessEntity.Attributes.Contains("address2_composite"))
                            {
                                SetValue(businessEntity, "address2_composite", GetCompositeAddress(response.TemporaryAddress));
                            }
                            else
                            {
                                businessEntity.Attributes.Add("address2_composite", GetCompositeAddress(response.TemporaryAddress));
                            }

                            if (!string.IsNullOrEmpty(response.TemporaryAddress.Line1))
                            {
                                if (businessEntity.Attributes.Contains("address2_line1"))
                                {
                                    SetValue(businessEntity, "address2_line1", response.TemporaryAddress.Line1);
                                }
                                else
                                {
                                    businessEntity.Attributes.Add("address2_line1", response.TemporaryAddress.Line1);
                                }
                            }

                            if (!string.IsNullOrEmpty(response.TemporaryAddress.Line2))
                            {
                                if (businessEntity.Attributes.Contains("address2_line2"))
                                {
                                    SetValue(businessEntity, "address2_line2", response.TemporaryAddress.Line2);
                                }
                                else
                                {
                                    businessEntity.Attributes.Add("address2_line2", response.TemporaryAddress.Line2);
                                }
                            }

                            if (!string.IsNullOrEmpty(response.TemporaryAddress.City))
                            {
                                if (businessEntity.Attributes.Contains("address2_city"))
                                {
                                    SetValue(businessEntity, "address2_city", response.TemporaryAddress.City);
                                }
                                else
                                {
                                    businessEntity.Attributes.Add("address2_city", response.TemporaryAddress.City);
                                }
                            }

                            if (!string.IsNullOrEmpty(response.TemporaryAddress.State))
                            {
                                if (businessEntity.Attributes.Contains("address2_stateorprovince"))
                                {
                                    SetValue(businessEntity, "address2_stateorprovince", response.TemporaryAddress.State);
                                }
                                else
                                {
                                    businessEntity.Attributes.Add("address2_stateorprovince", response.TemporaryAddress.State);
                                }
                            }

                            if (!string.IsNullOrEmpty(response.TemporaryAddress.Zip))
                            {
                                if (businessEntity.Attributes.Contains("address2_postalcode"))
                                {
                                    SetValue(businessEntity, "address2_postalcode", response.TemporaryAddress.Zip);
                                }
                                else
                                {
                                    businessEntity.Attributes.Add("address2_postalcode", response.TemporaryAddress.Zip);
                                }
                            }

                            if (!string.IsNullOrEmpty(response.TemporaryAddress.Country))
                            {
                                if (businessEntity.Attributes.Contains("address2_country"))
                                {
                                    SetValue(businessEntity, "address2_country", response.TemporaryAddress.Country);
                                }
                                else
                                {
                                    businessEntity.Attributes.Add("address2_country", response.TemporaryAddress.Country);
                                }
                            }

                            switch (response.TemporaryAddress.Use.ToString())
                            {
                                case "":
                                    break;
                            }
                        }

                        // TODO: Need to determine if caregiver or veteran and put that here

                        if (!string.IsNullOrEmpty(response.GenderCode))
                        {
                            int genCode = mcUtil.getOptionSetValue(response.GenderCode.ToUpper(), "contact", "gendercode");
                            {
                                if (businessEntity.Attributes.Contains("gendercode"))
                                {                                // if it is a valid code then use it otherwise default to not specified
                                    SetValue(businessEntity, "gendercode", genCode > 0 ? new OptionSetValue(genCode) : new OptionSetValue(mcUtil.getOptionSetValue("NotSpecified", "contact", "gendercode")));
                                }
                                else
                                {
                                    businessEntity.Attributes.Add("gendercode", genCode > 0 ? new OptionSetValue(genCode) : new OptionSetValue(mcUtil.getOptionSetValue("NotSpecified", "contact", "gendercode")));
                                }
                            }
                        }
                        else
                        {
                            if (businessEntity.Attributes.Contains("gendercode"))
                            {                                // if it is a valid code then use it otherwise default to not specified
                                SetValue(businessEntity, "gendercode", new OptionSetValue(mcUtil.getOptionSetValue("NotSpecified", "contact", "gendercode")));
                            }
                            else
                            {
                                businessEntity.Attributes.Add("gendercode", new OptionSetValue(mcUtil.getOptionSetValue("NotSpecified", "contact", "gendercode")));
                            }
                        }

                        if (!string.IsNullOrEmpty(response.RecordSource))
                        {
                            if (businessEntity.Attributes.Contains("btsss_recordsource"))
                            {
                                SetValue(businessEntity, "btsss_recordsource", response.RecordSource);
                            }
                            else
                            {
                                businessEntity.Attributes.Add("btsss_recordsource", response.RecordSource);
                            }
                        }

                        if (!string.IsNullOrEmpty(response.MaskedBankAccountNumber))
                        {
                            if (businessEntity.Attributes.Contains("btsss_maskedbankaccountnumber"))
                            {
                                SetValue(businessEntity, "btsss_maskedbankaccountnumber", response.MaskedBankAccountNumber);
                            }
                            else
                            {
                                businessEntity.Attributes.Add("btsss_maskedbankaccountnumber", response.MaskedBankAccountNumber);
                            }
                        }

                        if (!string.IsNullOrEmpty(response.MaskedBankAccountNumber))
                        {
                            if (businessEntity.Attributes.Contains("btsss_bankaccountnumber"))
                            {
                                SetValue(businessEntity, "btsss_bankaccountnumber", response.MaskedBankAccountNumber);
                            }
                            else
                            {
                                businessEntity.Attributes.Add("btsss_bankaccountnumber", response.MaskedBankAccountNumber);
                            }
                        }

                        if (!string.IsNullOrEmpty(response.BankAccountRoutingNumber))
                        {
                            if (businessEntity.Attributes.Contains("btsss_bankroutingnumber"))
                            {
                                SetValue(businessEntity, "btsss_bankroutingnumber", response.BankAccountRoutingNumber);
                            }
                            else
                            {
                                businessEntity.Attributes.Add("btsss_bankroutingnumber", response.BankAccountRoutingNumber);
                            }
                        }

                        if (!string.IsNullOrEmpty(response.NetIncome))
                        {
                            if (businessEntity.Attributes.Contains("btsss_netincome"))
                            {
                                SetValue(businessEntity, "btsss_netincome", new Money(Convert.ToDecimal(response.NetIncome)));
                            }
                            else
                            {
                                businessEntity.Attributes.Add("btsss_netincome", new Money(Convert.ToDecimal(response.NetIncome)));
                            }
                        }
                    }
                }
                else
                {
                    base.Logger.WriteDebugMessage("Business Entity Does NOT Contain a btsss_icn");

                    //var contactProfile = base.OrganizationService.Retrieve(businessEntity.LogicalName, businessEntity.Id, new ColumnSet("btsss_profileid"));
                    //request.ProfileServiceIdentifier = contactProfile.Attributes["btsss_profileid"].ToString();
                }

                
            }
        }

        private string GetCompositeAddress(Address primaryAddress)
        {
            StringBuilder builder = new StringBuilder();
            if (!string.IsNullOrEmpty(primaryAddress.Line1))
            {
                builder.AppendLine(primaryAddress.Line1);
            }
            if (!string.IsNullOrEmpty(primaryAddress.Line2))
            {
                builder.AppendLine(primaryAddress.Line2);
            }
            if (!string.IsNullOrEmpty(primaryAddress.City))
            {
                builder.AppendLine(primaryAddress.City);
            }
            if (!string.IsNullOrEmpty(primaryAddress.State))
            {
                builder.AppendLine(primaryAddress.State);
            }
            if (!string.IsNullOrEmpty(primaryAddress.Country))
            {
                builder.AppendLine(primaryAddress.Country);
            }
            return builder.ToString();
        }

        private void SetValue(Entity entity, string key, object value)
        {
            if (value != null)
            {
                if (entity.Attributes.ContainsKey(key))
                {
                    entity.Attributes[key] = value;
                }
                else
                {
                    entity.Attributes.Add(key, value);
                }
            }
        }

    
    }
}
