using System;
using System.ServiceModel;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Sdk.Client;
using Microsoft.Xrm.Sdk.Metadata;
using Btsss.Plugins.VIMT.Appointments.Messages;
using MCSUtilities2011;

namespace Btsss.Plugins.VIMT.Appointments
{

    /// <summary>
    /// PluginEntryPoint plug-in.
    /// This is a generic entry point for a plug-in class. Use the Plug-in Registration tool found in the CRM SDK to register this class, import the assembly into CRM, and then create step associations.
    /// A given plug-in can have any number of steps associated with it. 
    /// </summary>    
    public class RetrieveMultiplePostAppointmentsRunner : AppointmentBase
    {
        private IOrganizationService _service { get; set; }

        private Uri vimtEndPoint { get; set; }

        /// <summary>
        /// Initializes a new instance of the <see cref="RetrieveMultiplePostAppointmentsRunner"/> class.
        /// </summary>
        /// <param name="unsecure">Contains public (unsecured) configuration information.</param>
        /// <param name="secure">Contains non-public (secured) configuration information. 
        /// When using Microsoft Dynamics CRM for Outlook with Offline Access, 
        /// the secure string is not passed to a plug-in that executes while the client is offline.</param>
        public RetrieveMultiplePostAppointmentsRunner(string unsecure, string secure)
            : base(typeof(RetrieveMultiplePostAppointmentsRunner))
        {

        }


    /// <summary>
    /// Main entry point for he business logic that the plug-in is to execute.
    /// </summary>
    /// <param name="localContext">The <see cref="LocalPluginContext"/> which contains the
    /// <see cref="IPluginExecutionContext"/>,
    /// <see cref="IOrganizationService"/>
    /// and <see cref="ITracingService"/>
    /// </param>
    /// <remarks>
    /// For improved performance, Microsoft Dynamics CRM caches plug-in instances.
    /// The plug-in's Execute method should be written to be stateless as the constructor
    /// is not called for every invocation of the plug-in. Also, multiple system threads
    /// could execute the plug-in at the same time. All per invocation state information
    /// is stored in the context. This means that you should not use global variables in plug-ins.
    /// </remarks>
    protected override void ExecuteCrmPlugin(LocalPluginContext localContext)
        {
            // Implement your custom plug-in business logic.
            try
            {
                // only process original first requests. Depth of 2 or greater will need to customize this further if needed.
                if (localContext == null || localContext.PluginExecutionContext.Depth == 1)
                {

                    _service = localContext.OrganizationService;

                    string searchType = "Unfiltered"; // Currently forcing the search type for now. string.Empty;


                    // find out if the query in the retrieve request contains specific filter statements so they can be replicated if possible
                    // Once the retrieveType has been determined you will know how to handle the call to VIMT
                    // retrieveType = NoMatchedParameters use the business entity collection appointment records to find the corresponding appointment record in the sub systems
                    // retrieveType = MatchedParameters then call the VIMT sub system method that corresponds to the parameters passed in.
                    // Otherwise only match the records in the return response to appointments in the integrated systems.
                    QueryExpression qe = new QueryExpression();

                    if (localContext.PluginExecutionContext.InputParameters["Query"] is QueryExpression || localContext.PluginExecutionContext.InputParameters.Contains("Query"))
                    {
                        // Determine the expression type and see if it contains a PatientIdentifier, FacilityIdentifier, neither or both
                        if (localContext.PluginExecutionContext.InputParameters["Query"].GetType() == typeof(FetchExpression))
                        {
                            // Extract the conditions so that we can determine how to handle the RetrieveMultiple
                            var retrieveType = base.TryGetSearchMatchesFromFetch(localContext);
                        }
                        else
                        {
                            var retrieveType = TryGetSearchMatchesFromConditions((QueryExpression)localContext.PluginExecutionContext.InputParameters["Query"]);
                            if (retrieveType != null && retrieveType.Count > 0)
                            {
                                // Do a filtered search of some sort for all appointments of either a date range or a facility or a patient identifier or combination of each
                            }
                            else
                            {
                                // none of our parameters were used so simply match up what was returned with appointments from sub systems based on the
                                // appointment records in the collection.
                            }
                        }
                    }
                    else
                    {
                        // TODO just code a call out for each appointment that is actually in the system so that the details can be displayed.
                    }

                    if (localContext.PluginExecutionContext.OutputParameters.ContainsKey("BusinessEntityCollection"))
                    {
                        // Go get the list of appointments from the appointment entity

                        localContext.Trace("Starting Retrieve Plugin Runner");
                        MCSUtilities2011.MCSSettings McsSettings = new MCSUtilities2011.MCSSettings();

                        McsSettings.setService = localContext.OrganizationService;
                        McsSettings.systemSetting = "Active Settings";

                        var businessEntityCollection = localContext.PluginExecutionContext.OutputParameters["BusinessEntityCollection"] as EntityCollection;
                        localContext.Trace("Check Business Entity to see if it is null");

                        if (businessEntityCollection == null)
                        {
                            return;
                        }

                        localContext.Trace("Business Entity Is not Null");
                        localContext.Trace(businessEntityCollection.EntityName.ToString());

                        vimtEndPoint = new Uri(McsSettings.GetSingleSetting("btsss_vimtendpoint", "string"));

                        Messages.LoadVISTAAppointmentsDateRangeRequest request = new Messages.LoadVISTAAppointmentsDateRangeRequest
                        {
                            OrganizationName = localContext.PluginExecutionContext.OrganizationName,
                            UserId = localContext.PluginExecutionContext.UserId
                        };

                        Entity User = localContext.OrganizationService.Retrieve("systemuser", localContext.PluginExecutionContext.UserId, new ColumnSet(new string[] { "firstname", "lastname" }));

                        if (User != null)
                        {
                            if (User.Attributes.Contains("firstname") && User.Attributes["firstname"] != null)
                            {
                                request.UserFirstName = User.Attributes["firstname"].ToString();
                            }
                            if (User.Attributes.Contains("lastname") && User.Attributes["lastname"] != null)
                            {
                                request.UserLastName = User.Attributes["lastname"].ToString();
                            }
                        }

                        request.AppointmentStartDate = DateTime.Now.AddDays(-90).ToString();
                        request.AppointmentEndDate = DateTime.Now.AddDays(90).ToString();

                        if (businessEntityCollection.Entities[0].Attributes["btsss_appointmentid"] != null)
                        {
                            Entity apptEnt = _service.Retrieve("btsss_appointment", (Guid)businessEntityCollection.Entities[0].Attributes["btsss_appointmentid"], new ColumnSet(true));
                            if (apptEnt != null && apptEnt.Attributes.Contains("btsss_contactid"))
                            {
                                Entity contEnt = _service.Retrieve("contact", ((EntityReference)apptEnt.Attributes["btsss_contactid"]).Id, new ColumnSet(true));
                                if (contEnt != null && contEnt.Attributes.Contains("btsss_icn") && contEnt.Attributes["btsss_icn"] != null)
                                    request.PatientIdentifier = contEnt.Attributes["btsss_icn"].ToString();
                                else
                                    return;
                            }
                        }

                        // **************************************************************************************************************************************
                        // *****************************   Stub in a Stub This section is incomplete for sprint 9  and needs ************************************
                        // *****************************   to be enhanced next sprint. Currenlty this will return a group    ************************************
                        // *****************************   of unchecked and unmatched appointments within a 90 day range     ************************************
                        // *****************************   but it will return records so we can start buiding and designing  ************************************
                        // *****************************   Additinally the search type is fixed at unfiltered at the top     ************************************
                        // **************************************************************************************************************************************
                        switch (searchType)
                        {
                            case "Unfiltered":
                                HandleUnFilteredSearch(ref businessEntityCollection, request);
                                break;
                            case "PatientIdentifier":
                                break;
                            case "FacilityIdentifier":
                                break;
                            case "AppointmentDate":
                                break;
                            default:
                                break;
                        }



                    }
                }
                }
                catch (FaultException<OrganizationServiceFault> ex)
                {
                    localContext.Trace(ex.Message);
                    throw new InvalidPluginExecutionException(ex.Message);
                }
                catch (InvalidOperationException ex)
                {
                    localContext.Trace(ex.Message);
                    throw new InvalidPluginExecutionException(ex.Message);
                }
                catch (Exception ex)
                {
                    localContext.Trace(ex.Message);
                    throw new InvalidPluginExecutionException(ex.Message);
                }
        }

        private void HandleUnFilteredSearch(ref EntityCollection beCollection, LoadVISTAAppointmentsDateRangeRequest request)
        {
            request.MessageId = Guid.NewGuid();
            var response = VRMRest.Utility.SendReceive<LoadVISTAAppointmentsDateRangeResponse>(vimtEndPoint, MessageRegistry.LoadVISTAAppointmentsDateRangeRequest, request, null);

            // Several things happen here.
            //  1. Find out if the appointment exists in the system. 
            //  2. If it does not exist then it should be created and then added to this collection.
            //  3. Find out if the appointment is in theis entity collection
            //  4. If it exists and is not in this collection then it probably should not be added
            //  5. If it exists and it is in this collection then it should be updated

            foreach (var appt in response.Appointments)
            {
                if (appt.AppointmentIdentifier != null)
                {
                    // 1. Find out if the appointment exists in the system. It must have an appointment Key and a system key that matches
                    //************************************************************************************************************************************
                    // TODO: Add to the code the filter for btsss_externalsystemkey. This means this needs to be a query expression not querybyattribute.
                    //************************************************************************************************************************************
                    QueryByAttribute qba = new QueryByAttribute("btsss_appointment");
                    qba.ColumnSet = new ColumnSet(true);
                    qba.Attributes.AddRange("btsss_externalappointmentkey");
                    qba.Values.AddRange(appt.AppointmentIdentifier);
                    var returnValue = _service.RetrieveMultiple(qba);

                    if (returnValue != null && returnValue.Entities.Count == 1)
                    {
                        // The record exists so is it in our collection
                        foreach(var buent in beCollection.Entities)
                        {
                            // Run through the records and see if the appointment exist and is in this collection so update the collection only. 
                            // If they select it then make another call to go get the detail.
                            if (buent.Id == returnValue[0].Id)
                            {
                                // run through all attributes and update the ones that exist. Add the ones that do not.
                                if(buent.Attributes.Contains("btsss_name"))
                                {
                                    buent.Attributes["btsss_name"] = appt.SOPCode.ToString();
                                }
                                else
                                {
                                    buent.Attributes.Add("btsss_name", appt.SOPCode.ToString());
                                }

                                if (buent.Attributes.Contains("btsss_appointmentdate"))
                                {
                                    buent.Attributes["btsss_appointmentdate"] = (DateTime)appt.AppointmentDate;
                                }
                                else
                                {
                                    buent.Attributes.Add("btsss_appointmentdate", (DateTime)appt.AppointmentDate);
                                }

                                if (buent.Attributes.Contains("btsss_facilityidentifier"))
                                {
                                    buent.Attributes["btsss_facilityidentifier"] = appt.FacilityIdentifier.ToString();
                                }
                                else
                                {
                                    buent.Attributes.Add("btsss_facilityidentifier", appt.FacilityIdentifier.ToString());
                                }

                                if (buent.Attributes.Contains("btsss_name"))
                                {
                                    buent.Attributes["btsss_name"] = appt.SOPCode.ToString();
                                }
                                else
                                {
                                    buent.Attributes.Add("btsss_name", appt.SOPCode.ToString());
                                }

                                // Never nulls
                                //er.Attributes.Add("btsss_appointmentstatus", appt.AppointmentStatus);
                                //er.Attributes.Add("btsss_exceptionoccured", appt.ExceptionOccured);

                                break;
                            }
                            else
                            {
                                // Next item in bu collection.
                            }
                        }
                    }
                    else
                    {
                        // TODO: Determine how much of this record we will actually be storing. Change accordingly
                        // The record does not exist so add it
                        Entity erAdd = new Entity("btsss_appointment");

                        if (appt.SOPCode != null)
                            erAdd.Attributes.Add("btsss_name", appt.SOPCode.ToString());
                        if (appt.AppointmentIdentifier != null)
                            erAdd.Attributes.Add("btsss_externalappointmentkey", appt.AppointmentIdentifier.ToString());
                        if (appt.OriginatingSystemIdentifier != null)
                            erAdd.Attributes.Add("btsss_externalsystemkey", appt.OriginatingSystemIdentifier);
                        if (appt.AppointmentDate != null)
                            erAdd.Attributes.Add("btsss_appointmentscheduledate", appt.AppointmentDate);

                        // Never nulls
                        //er.Attributes.Add("btsss_appointmentstatus", appt.AppointmentStatus);
                        //er.Attributes.Add("btsss_exceptionoccured", appt.ExceptionOccured);

                        //TODO: Will have to add code to go out and get the actual contact id or facility id if they exist in order to show them on the record.
                        // Will have to go out and get the actual identifier for the value passed in if it exists in our system... then
                        // add the entity reference to the record... 
                        //if (appt.PatientIdentifier != null)
                        //    erAdd.Attributes.Add("btsss_patientidentifier", appt.PatientIdentifier);
                        //if (appt.FacilityIdentifier != null)
                        //    erAdd.Attributes.Add("btsss_facilityidentifier", appt.FacilityIdentifier);

                        // Create the record and get the guid for the record we add to the collection
                        erAdd.Id = _service.Create(erAdd);

                        // now add it to the collection
                        beCollection.Entities.Add(erAdd);
                    }
                }
            }
        }
        private EntityCollection HandlePatientFilteredSearch()
        {
            return new EntityCollection();
        }
        private EntityCollection HandleFacilityFilteredSearch()
        {
            return new EntityCollection();
        }
        private EntityCollection HandleDateFilteredSearch()
        {
            return new EntityCollection();
        }
    }
}
